/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util;

import com.solacesystems.common.util.Arrays;
import com.solacesystems.common.util.ByteArray;
import java.io.EOFException;
import java.io.OutputStream;
import java.math.BigInteger;

public class SolByteBuffer
extends OutputStream {
    private static final short MAX_UBYTE = 255;
    private static final int MAX_USHORT = 65535;
    private static final int MAX_UTHRINT = 0xFFFFFF;
    private static final long MAX_UINT = 0xFFFFFFFFL;
    private static final BigInteger MAX_ULONG = new BigInteger("18446744073709551615");
    private static final boolean ALLOCATION_DOUBLING_ENABLED = true;
    protected byte[] mData;
    protected int mOffset;
    protected int mCapacity;
    protected int mReadPosition;
    protected int mWritePosition;
    protected boolean mReadOnly;
    protected int mReadMark;
    protected int mWriteMark;

    public SolByteBuffer(int capacity) {
        this.mData = new byte[capacity];
        this.mOffset = 0;
        this.mCapacity = capacity;
        this.mReadPosition = 0;
        this.mWritePosition = 0;
        this.mReadOnly = false;
        this.mReadMark = this.mReadPosition;
        this.mWriteMark = this.mWritePosition;
    }

    public SolByteBuffer(byte[] data, int offset) {
        this.mData = data;
        this.mOffset = offset;
        this.mCapacity = data.length;
        this.mReadPosition = this.mOffset;
        this.mWritePosition = data.length;
        this.mReadOnly = false;
        this.mReadMark = this.mReadPosition;
        this.mWriteMark = this.mWritePosition;
    }

    public SolByteBuffer(ByteArray data) {
        this.mData = data.getBuffer();
        this.mOffset = data.getOffset();
        this.mCapacity = data.getLength();
        this.mReadPosition = data.getOffset();
        this.mWritePosition = data.getOffset() + data.getLength();
        this.mReadOnly = false;
        this.mReadMark = this.mReadPosition;
        this.mWriteMark = this.mWritePosition;
    }

    public SolByteBuffer(SolByteBuffer toclone) {
        this.mData = Arrays.copyOf(toclone.mData);
        this.mOffset = toclone.mOffset;
        this.mCapacity = toclone.mCapacity;
        this.mReadPosition = toclone.mReadPosition;
        this.mWritePosition = toclone.mWritePosition;
        this.mReadOnly = toclone.mReadOnly;
        this.mReadMark = toclone.mReadMark;
        this.mWriteMark = toclone.mWriteMark;
    }

    public ByteArray asByteArray() {
        return new ByteArray(this.mData, this.mOffset, this.mWritePosition - this.mOffset);
    }

    public byte[] getBackingArray() {
        return this.mData;
    }

    public int getBackingArrayOffset() {
        return this.mOffset;
    }

    public int getLength() {
        return this.mWritePosition - this.mOffset;
    }

    public boolean isReadOnly() {
        return this.mReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.mReadOnly = readOnly;
    }

    public boolean hasRemaining() {
        return this.mReadPosition < this.mWritePosition;
    }

    public int remaining() {
        int left = this.mWritePosition - this.mReadPosition;
        if (left < 0) {
            return 0;
        }
        return left;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SolByteBuffer) {
            SolByteBuffer other = (SolByteBuffer)obj;
            return this.asByteArray().equals(other.asByteArray());
        }
        return false;
    }

    public int readPosition() {
        return this.mReadPosition;
    }

    public void mark() {
        this.mReadMark = this.mReadPosition;
    }

    public void reset() {
        this.mReadPosition = this.mReadMark;
    }

    public void writeMark() {
        this.mWriteMark = this.mWritePosition;
    }

    public int getWriteMark() {
        return this.mWriteMark;
    }

    public void rewind() {
        this.mReadPosition = this.mOffset;
    }

    public void clear() {
        this.rewind();
        this.mWritePosition = this.mOffset;
    }

    public byte readByte() throws EOFException {
        if (this.mReadPosition + 1 > this.mWritePosition) {
            throw new EOFException("unexpected end of buffer reached");
        }
        return this.mData[this.mReadPosition++];
    }

    public short readUByte() throws EOFException {
        if (this.mReadPosition + 1 > this.mWritePosition) {
            throw new EOFException("unexpected end of buffer reached");
        }
        return (short)(0xFF & this.mData[this.mReadPosition++]);
    }

    public short readShort() throws EOFException {
        if (this.mReadPosition + 2 > this.mWritePosition) {
            throw new EOFException("unexpected end of buffer reached");
        }
        int b0 = 0xFF & this.mData[this.mReadPosition++];
        int b1 = 0xFF & this.mData[this.mReadPosition++];
        return (short)(b0 << 8 | b1);
    }

    public char readChar() throws EOFException {
        return (char)this.readShort();
    }

    public int readUShort() throws EOFException {
        if (this.mReadPosition + 2 > this.mWritePosition) {
            throw new EOFException("unexpected end of buffer reached");
        }
        int b0 = 0xFF & this.mData[this.mReadPosition++];
        int b1 = 0xFF & this.mData[this.mReadPosition++];
        return b0 << 8 | b1;
    }

    public int readUThrint() throws EOFException {
        if (this.mReadPosition + 3 > this.mWritePosition) {
            throw new EOFException("unexpected end of buffer reached");
        }
        int b0 = 0xFF & this.mData[this.mReadPosition++];
        int b1 = 0xFF & this.mData[this.mReadPosition++];
        int b2 = 0xFF & this.mData[this.mReadPosition++];
        return b0 << 16 | b1 << 8 | b2;
    }

    public int readInt() throws EOFException {
        if (this.mReadPosition + 4 > this.mWritePosition) {
            throw new EOFException("unexpected end of buffer reached");
        }
        int b0 = 0xFF & this.mData[this.mReadPosition++];
        int b1 = 0xFF & this.mData[this.mReadPosition++];
        int b2 = 0xFF & this.mData[this.mReadPosition++];
        int b3 = 0xFF & this.mData[this.mReadPosition++];
        return b0 << 24 | b1 << 16 | b2 << 8 | b3;
    }

    public long readUInt() throws EOFException {
        if (this.mReadPosition + 4 > this.mWritePosition) {
            throw new EOFException("unexpected end of buffer reached");
        }
        int b0 = 0xFF & this.mData[this.mReadPosition++];
        int b1 = 0xFF & this.mData[this.mReadPosition++];
        int b2 = 0xFF & this.mData[this.mReadPosition++];
        int b3 = 0xFF & this.mData[this.mReadPosition++];
        return (long)b0 << 24 | (long)b1 << 16 | (long)b2 << 8 | (long)b3;
    }

    public long readLong() throws EOFException {
        if (this.mReadPosition + 8 > this.mWritePosition) {
            throw new EOFException("unexpected end of buffer reached");
        }
        int b0 = 0xFF & this.mData[this.mReadPosition++];
        int b1 = 0xFF & this.mData[this.mReadPosition++];
        int b2 = 0xFF & this.mData[this.mReadPosition++];
        int b3 = 0xFF & this.mData[this.mReadPosition++];
        int b4 = 0xFF & this.mData[this.mReadPosition++];
        int b5 = 0xFF & this.mData[this.mReadPosition++];
        int b6 = 0xFF & this.mData[this.mReadPosition++];
        int b7 = 0xFF & this.mData[this.mReadPosition++];
        return (long)b0 << 56 | (long)b1 << 48 | (long)b2 << 40 | (long)b3 << 32 | (long)b4 << 24 | (long)b5 << 16 | (long)b6 << 8 | (long)b7;
    }

    public BigInteger readULong() throws EOFException {
        if (this.mReadPosition + 8 > this.mWritePosition) {
            throw new EOFException("unexpected end of buffer reached");
        }
        byte[] bytes = new byte[9];
        bytes[0] = 0;
        for (int i = 0; i < 8; ++i) {
            bytes[i + 1] = (byte)(this.mData[this.mReadPosition++] & 0xFF);
        }
        return new BigInteger(bytes);
    }

    public float readFloat() throws EOFException {
        int value = this.readInt();
        return Float.intBitsToFloat(value);
    }

    public double readDouble() throws EOFException {
        long value = this.readLong();
        return Double.longBitsToDouble(value);
    }

    public ByteArray readBytes(int length) throws EOFException {
        if (this.mReadPosition + length > this.mWritePosition) {
            throw new EOFException("end of buffer reached");
        }
        ByteArray ba = new ByteArray(this.mData, this.mReadPosition, length);
        this.mReadPosition += length;
        return ba;
    }

    public void writeByte(byte b) {
        this.realloc(1);
        this.mData[this.mWritePosition++] = b;
    }

    public void writeByteUnsafe(byte b) {
        this.mData[this.mWritePosition++] = b;
    }

    public void writeUByte(short s) {
        if (s < 0 || s > 255) {
            throw new IllegalArgumentException("unsigned byte value out of range (" + s + ")");
        }
        this.writeByte((byte)(s & 0xFF));
    }

    public void writeByte(int position, byte b) {
        this.mData[position] = b;
    }

    public void writeUByte(int position, short s) {
        if (s < 0 || s > 255) {
            throw new IllegalArgumentException("unsigned byte value out of range (" + s + ")");
        }
        this.mData[position] = (byte)(s & 0xFF);
    }

    public void writeBytes(byte[] src) {
        this.realloc(src.length);
        System.arraycopy(src, 0, this.mData, this.mWritePosition, src.length);
        this.mWritePosition += src.length;
    }

    public void writeBytes(byte[] src, int offset, int length) {
        this.realloc(length);
        System.arraycopy(src, offset, this.mData, this.mWritePosition, length);
        this.mWritePosition += length;
    }

    public void writeBytes(ByteArray src) {
        this.realloc(src.getLength());
        System.arraycopy(src.getBuffer(), src.getOffset(), this.mData, this.mWritePosition, src.getLength());
        this.mWritePosition += src.getLength();
    }

    public void writeChar(char c) {
        this.writeShort((short)c);
    }

    public void writeChar(int position, char c) {
        this.writeShort(position, (short)c);
    }

    public void writeShort(short s) {
        this.realloc(2);
        this.mData[this.mWritePosition++] = (byte)(((long)s & 0xFF00L) >> 8);
        this.mData[this.mWritePosition++] = (byte)((long)s & 0xFFL);
    }

    public void writeShort(int position, short s) {
        this.mData[position] = (byte)(((long)s & 0xFF00L) >> 8);
        this.mData[position + 1] = (byte)((long)s & 0xFFL);
    }

    public void writeUShort(int i) {
        if (i < 0 || i > 65535) {
            throw new IllegalArgumentException("unsigned short value out of range (" + i + ")");
        }
        this.realloc(2);
        this.mData[this.mWritePosition++] = (byte)(((long)i & 0xFF00L) >> 8);
        this.mData[this.mWritePosition++] = (byte)((long)i & 0xFFL);
    }

    public void writeUShort(int position, int i) {
        if (i < 0 || i > 65535) {
            throw new IllegalArgumentException("unsigned short value out of range (" + i + ")");
        }
        this.mData[position] = (byte)(((long)i & 0xFF00L) >> 8);
        this.mData[position + 1] = (byte)((long)i & 0xFFL);
    }

    public void writeUThrint(int i) {
        if (i < 0 || i > 0xFFFFFF) {
            throw new IllegalArgumentException("unsigned three byte value out of range (" + i + ")");
        }
        this.realloc(3);
        this.mData[this.mWritePosition++] = (byte)(((long)i & 0xFF0000L) >> 16);
        this.mData[this.mWritePosition++] = (byte)(((long)i & 0xFF00L) >> 8);
        this.mData[this.mWritePosition++] = (byte)((long)i & 0xFFL);
    }

    public void writeUThrint(int position, int i) {
        if (i < 0 || i > 0xFFFFFF) {
            throw new IllegalArgumentException("unsigned three byte value out of range (" + i + ")");
        }
        this.mData[position] = (byte)(((long)i & 0xFF0000L) >> 16);
        this.mData[position + 1] = (byte)(((long)i & 0xFF00L) >> 8);
        this.mData[position + 2] = (byte)((long)i & 0xFFL);
    }

    public void writeInt(int i) {
        this.realloc(4);
        this.mData[this.mWritePosition++] = (byte)(((long)i & 0xFF000000L) >> 24);
        this.mData[this.mWritePosition++] = (byte)(((long)i & 0xFF0000L) >> 16);
        this.mData[this.mWritePosition++] = (byte)(((long)i & 0xFF00L) >> 8);
        this.mData[this.mWritePosition++] = (byte)((long)i & 0xFFL);
    }

    public void writeInt(int position, int i) {
        this.mData[position] = (byte)(((long)i & 0xFF000000L) >> 24);
        this.mData[position + 1] = (byte)(((long)i & 0xFF0000L) >> 16);
        this.mData[position + 2] = (byte)(((long)i & 0xFF00L) >> 8);
        this.mData[position + 3] = (byte)((long)i & 0xFFL);
    }

    public void writeUInt(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("unsigned int value out of range (" + l + ")");
        }
        this.realloc(4);
        this.mData[this.mWritePosition++] = (byte)((l & 0xFF000000L) >> 24);
        this.mData[this.mWritePosition++] = (byte)((l & 0xFF0000L) >> 16);
        this.mData[this.mWritePosition++] = (byte)((l & 0xFF00L) >> 8);
        this.mData[this.mWritePosition++] = (byte)(l & 0xFFL);
    }

    public void writeUInt(int position, long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("unsigned int value out of range (" + l + ")");
        }
        this.mData[position] = (byte)((l & 0xFF000000L) >> 24);
        this.mData[position + 1] = (byte)((l & 0xFF0000L) >> 16);
        this.mData[position + 2] = (byte)((l & 0xFF00L) >> 8);
        this.mData[position + 3] = (byte)(l & 0xFFL);
    }

    public void writeLong(long l) {
        this.realloc(8);
        this.mData[this.mWritePosition++] = (byte)((l & 0xFF00000000000000L) >> 56);
        this.mData[this.mWritePosition++] = (byte)((l & 0xFF000000000000L) >> 48);
        this.mData[this.mWritePosition++] = (byte)((l & 0xFF0000000000L) >> 40);
        this.mData[this.mWritePosition++] = (byte)((l & 0xFF00000000L) >> 32);
        this.mData[this.mWritePosition++] = (byte)((l & 0xFF000000L) >> 24);
        this.mData[this.mWritePosition++] = (byte)((l & 0xFF0000L) >> 16);
        this.mData[this.mWritePosition++] = (byte)((l & 0xFF00L) >> 8);
        this.mData[this.mWritePosition++] = (byte)(l & 0xFFL);
    }

    public void writeLong(int position, long l) {
        this.mData[position] = (byte)((l & 0xFF00000000000000L) >> 56);
        this.mData[position + 1] = (byte)((l & 0xFF000000000000L) >> 48);
        this.mData[position + 2] = (byte)((l & 0xFF0000000000L) >> 40);
        this.mData[position + 3] = (byte)((l & 0xFF00000000L) >> 32);
        this.mData[position + 4] = (byte)((l & 0xFF000000L) >> 24);
        this.mData[position + 5] = (byte)((l & 0xFF0000L) >> 16);
        this.mData[position + 6] = (byte)((l & 0xFF00L) >> 8);
        this.mData[position + 7] = (byte)(l & 0xFFL);
    }

    public void writeULong(BigInteger bi) {
        if (bi.compareTo(BigInteger.ZERO) < 0 || bi.compareTo(MAX_ULONG) > 0) {
            throw new IllegalArgumentException("unsigned long value out of range (" + bi + ")");
        }
        this.realloc(8);
        byte[] bytes = bi.toByteArray();
        int len = bytes.length;
        int offset = 0;
        if (bytes.length > 8) {
            len = 8;
            offset = bytes.length - 8;
        }
        for (int i = 0; i < 8; ++i) {
            this.mData[this.mWritePosition++] = i < 8 - len ? (byte)0 : bytes[offset + (i - (8 - len))];
        }
    }

    public void writeULong(int position, BigInteger bi) {
        if (bi.compareTo(BigInteger.ZERO) < 0 || bi.compareTo(MAX_ULONG) > 0) {
            throw new IllegalArgumentException("unsigned long value out of range (" + bi + ")");
        }
        byte[] bytes = bi.toByteArray();
        int len = bytes.length;
        int offset = 0;
        if (bytes.length > 8) {
            len = 8;
            offset = bytes.length - 8;
        }
        int pos = position;
        for (int i = 0; i < 8; ++i) {
            this.mData[pos++] = i < 8 - len ? (byte)0 : bytes[offset + (i - (8 - len))];
        }
    }

    public void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeFloat(int position, float f) {
        this.writeInt(position, Float.floatToIntBits(f));
    }

    public void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeDouble(int position, double d) {
        this.writeLong(position, Double.doubleToLongBits(d));
    }

    public void skipRead(int num) throws EOFException {
        if (this.remaining() < num) {
            throw new EOFException("unexpected end of buffer reached");
        }
        this.mReadPosition += num;
    }

    public void skipWrite(int num) {
        this.realloc(num);
        this.mWritePosition += num;
    }

    public void skipToEnd() {
        this.mReadPosition = this.mWritePosition;
    }

    public void realloc(int quantum) {
        int newCapacity = this.mWritePosition - this.mOffset + quantum;
        if (newCapacity > this.mCapacity || this.mReadOnly) {
            newCapacity = newCapacity <= this.mCapacity ? this.mCapacity : Math.max(newCapacity, this.mCapacity * 2);
            byte[] newData = new byte[newCapacity];
            System.arraycopy(this.mData, this.mOffset, newData, 0, this.mCapacity);
            this.mData = newData;
            this.mReadPosition -= this.mOffset;
            this.mWritePosition -= this.mOffset;
            this.mReadMark -= this.mOffset;
            this.mWriteMark -= this.mOffset;
            this.mOffset = 0;
            this.mCapacity = newCapacity;
            this.mReadOnly = false;
        }
    }

    public void write(byte[] b, int off, int len) {
        this.writeBytes(b, off, len);
    }

    public void write(byte[] b) {
        this.writeBytes(b);
    }

    public void write(int b) {
        this.writeByte((byte)b);
    }
}

