/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util;

import com.solacesystems.common.util.BufferedDebugLogMXBean;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;

public abstract class BufferedDebugLog
implements BufferedDebugLogMXBean {
    private static final BufferedDebugLog _i = new BufferedDebugLogImpl();

    public static BufferedDebugLog instance() {
        return _i;
    }

    private BufferedDebugLog() {
    }

    public abstract void log(String var1);

    public abstract void dumpToFile();

    private static class BufferedDebugLogImpl
    extends BufferedDebugLog {
        private StringBuilder _buf;
        private List<StringBuilder> _bufs = new ArrayList<StringBuilder>();
        private final long _tsBase = System.currentTimeMillis();
        private final int _newSz = 0x100000;

        public BufferedDebugLogImpl() {
            this._buf = BufferedDebugLogImpl.newBuf();
            this._bufs.add(this._buf);
            try {
                ManagementFactory.getPlatformMBeanServer().registerMBean(this, new ObjectName("com.solacesystems.BufferedDebugLog:type=1"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private static StringBuilder newBuf() {
            return new StringBuilder(0x100000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void log(String s) {
            String ts = "[" + (System.currentTimeMillis() - this._tsBase) + ", th=" + Thread.currentThread().getId() + "]";
            List<StringBuilder> list = this._bufs;
            synchronized (list) {
                this._buf.append(ts);
                this._buf.append(s);
                if (!s.endsWith("\n")) {
                    this._buf.append("\n");
                }
                if ((double)this._buf.capacity() < 996147.2) {
                    this._buf = BufferedDebugLogImpl.newBuf();
                    this._bufs.add(this._buf);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dumpToFile() {
            List<StringBuilder> list = this._bufs;
            synchronized (list) {
                try {
                    FileWriter wr = new FileWriter("SdkBufLog.java.log", false);
                    for (StringBuilder sb : this._bufs) {
                        for (int i = 0; i < sb.length(); ++i) {
                            wr.write(sb.charAt(i));
                        }
                    }
                    wr.flush();
                    wr.close();
                    this._bufs.clear();
                    this._buf = BufferedDebugLogImpl.newBuf();
                    this._bufs.add(this._buf);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static class NullBufferedDebugLog
    extends BufferedDebugLog {
        private NullBufferedDebugLog() {
        }

        public void log(String s) {
        }

        public void dumpToFile() {
        }
    }
}

