/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.jms.SolQueueConnection;
import com.solacesystems.jms.SolXAQueueSession;
import com.solacesystems.jms.SolXASession;
import com.solacesystems.jms.impl.SessionTransactionType;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.property.JMSProperties;
import javax.jms.JMSException;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolXAQueueConnection
extends SolQueueConnection
implements XAQueueConnection {
    private static final Log log = LogFactory.getLog(SolXAQueueConnection.class);

    public SolXAQueueConnection(JMSProperties properties) throws JMSException {
        super(properties, true);
    }

    public SolXAQueueConnection(JMSProperties properties, String userName, String password) throws JMSException {
        super(properties, true, userName, password);
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering createXAQueueSession()");
        }
        this.checkClosed();
        Validator.checkTransactedAndAckMode(SessionTransactionType.XATransaction, 0, this.mConnectionProps.getPropertyBean().getDirectTransport());
        Validator.checkTransactedAndLargeMessaging(SessionTransactionType.XATransaction, this.mJCSMPProperties.getBooleanProperty("large_messaging"));
        this.mHasBeenAccessed = true;
        SolXAQueueSession newSession = new SolXAQueueSession(this, this.mState);
        this.mSessions.add(newSession);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving createXAQueueSession()");
        }
        return newSession;
    }

    public XASession createXASession() throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering createXASession()");
        }
        this.checkClosed();
        Validator.checkTransactedAndAckMode(SessionTransactionType.XATransaction, 0, this.mConnectionProps.getPropertyBean().getDirectTransport());
        Validator.checkTransactedAndLargeMessaging(SessionTransactionType.XATransaction, this.mJCSMPProperties.getBooleanProperty("large_messaging"));
        this.mHasBeenAccessed = true;
        SolXASession newSession = new SolXASession(this, this.mState);
        this.mSessions.add(newSession);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving createXASession()");
        }
        return newSession;
    }
}

