/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf.impl;

import com.solacesystems.common.util.BitTwiddleUtil;
import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.protocol.HeaderDescriptionBean;
import com.solacesystems.jcsmp.protocol.WireDecoder;
import com.solacesystems.jcsmp.protocol.smf.ClientCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.ClientCtrlHeaderParameters;
import com.solacesystems.jcsmp.protocol.smf.impl.NetworkIOUtil;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvCoderUtil;
import java.io.IOException;
import java.io.InputStream;

public class ClientCtrlHeaderDecoder
implements WireDecoder {
    public void decodeHeader(InputStream in, HeaderDescriptionBean headerBean) throws IOException {
        ClientCtrlHeaderBean h = (ClientCtrlHeaderBean)headerBean;
        byte[] twobytes = new byte[2];
        NetworkIOUtil.readDataSafely(in, twobytes, 0, 2);
        long twoBytesLong = NetworkByteOrderNumberUtil.twoByteToUInt(twobytes);
        h.setClientCtrlVersion((int)BitTwiddleUtil.extractBits(twoBytesLong, 3L, 8L));
        h.setMsgType((int)BitTwiddleUtil.extractBits(twoBytesLong, 8L, 0L));
        byte[] fourbytes = new byte[4];
        NetworkIOUtil.readDataSafely(in, fourbytes, 0, 4);
        int client_data_len = (int)NetworkByteOrderNumberUtil.fourByteToUInt(fourbytes);
        int bytesRead = 6;
        while (bytesRead < client_data_len) {
            bytesRead = TlvCoderUtil.readClientCtrlTlvParam(in, bytesRead, client_data_len, h, ClientCtrlHeaderParameters.KNOWN_PARAMS);
        }
    }
}

