/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf.impl;

import com.solacesystems.common.util.BitTwiddleUtil;
import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.protocol.HeaderDescriptionBean;
import com.solacesystems.jcsmp.protocol.WireEncoder;
import com.solacesystems.jcsmp.protocol.smf.ClientCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.ClientCtrlTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvCoderUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ClientCtrlHeaderEncoder
implements WireEncoder {
    ByteBuffer buf = ByteBuffer.allocate(4096);

    public void encodeHeader(OutputStream in, HeaderDescriptionBean headerBean) throws IOException {
        ClientCtrlHeaderBean h = (ClientCtrlHeaderBean)headerBean;
        this.buf.clear();
        long c1 = 0L;
        c1 = BitTwiddleUtil.setBits(c1, h.getClientCtrlVersion(), 3, 8);
        c1 = BitTwiddleUtil.setBits(c1, h.getMsgType(), 8, 0);
        long len = 0L;
        len = BitTwiddleUtil.setBits(len, h.getSmfEncodedLength(), 32, 0);
        this.buf.put(NetworkByteOrderNumberUtil.intToTwoByte((int)c1));
        this.buf.put(NetworkByteOrderNumberUtil.intToFourByte(len));
        for (ClientCtrlTLVParameter param : h.getParams()) {
            TlvCoderUtil.writeTlvParam(this.buf, param);
        }
        this.buf.flip();
        byte[] clientdata = new byte[this.buf.limit()];
        this.buf.get(clientdata);
        in.write(clientdata);
        in.flush();
    }
}

