/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.queues;

import com.solacesystems.jcsmp.impl.flow.FlowHandle;
import com.solacesystems.jcsmp.impl.queues.AbstractUnackedMessageList;
import com.solacesystems.jcsmp.impl.queues.AppAckRangeCache;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WindowAckMessageList
extends AbstractUnackedMessageList {
    private static final Log Trace = LogFactory.getLog(AbstractUnackedMessageList.class);
    private final int m_sz;
    private final LinkedList<AbstractUnackedMessageList.MessageAckInfo> m_list;
    private volatile transient long m_highestAppAcked = 0L;
    private volatile transient long m_lastInOrderTpMsgId = 0L;
    private final int m_queueSize;

    public WindowAckMessageList(int size, FlowHandle flow) {
        super(flow);
        this.m_sz = size;
        this.m_list = new LinkedList();
        this.m_queueSize = 1024;
    }

    public WindowAckMessageList(int size, FlowHandle flow, int queueSize) {
        super(flow);
        this.m_sz = size;
        this.m_list = new LinkedList();
        this.m_queueSize = queueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.rLock.lock();
        try {
            this.m_list.clear();
            this.m_highestAppAcked = 0L;
            this.m_lastInOrderTpMsgId = 0L;
            Object var2_1 = null;
            this.rLock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.rLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractUnackedMessageList.EAddResult add(long msgId) {
        block3: {
            this.rLock.lock();
            try {
                if (this.m_list.size() <= 0 || this.m_list.getLast().msgId < msgId) break block3;
                AbstractUnackedMessageList.EAddResult eAddResult = AbstractUnackedMessageList.EAddResult.DUPLICATE;
                Object var5_4 = null;
                this.rLock.unlock();
                return eAddResult;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.rLock.unlock();
                throw throwable;
            }
        }
        this.m_list.add(new AbstractUnackedMessageList.MessageAckInfo(msgId));
        this.m_lastInOrderTpMsgId = msgId;
        AbstractUnackedMessageList.EAddResult eAddResult = AbstractUnackedMessageList.EAddResult.OK;
        Object var5_5 = null;
        this.rLock.unlock();
        return eAddResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractUnackedMessageList.EAppAckResult applicationAck(long msgId, boolean forceSend) {
        boolean advanced_window = false;
        this.rLock.lock();
        try {
            Iterator it_ackinfo = this.m_list.iterator();
            while (it_ackinfo.hasNext()) {
                AbstractUnackedMessageList.MessageAckInfo mai = (AbstractUnackedMessageList.MessageAckInfo)it_ackinfo.next();
                if (mai.msgId > msgId) break;
                it_ackinfo.remove();
                mai.appAcked = true;
                mai.ackSent = true;
                if (mai.msgId <= this.m_highestAppAcked) continue;
                this.m_highestAppAcked = mai.msgId;
                advanced_window = true;
            }
            Object var8_6 = null;
            this.rLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.rLock.unlock();
            throw throwable;
        }
        if (advanced_window) {
            this.sendAcks("WindowAck-AckExplicitAlways", true);
        }
        return AbstractUnackedMessageList.EAppAckResult.OK;
    }

    public boolean hasUnsentAcks() {
        return false;
    }

    public void sendAcks(String reason, boolean allowReactorComplete) {
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)String.format("WindowAck>> highestAck=%s (%s)", this.m_highestAppAcked, reason));
        }
        this.flowHandle.setNumUnackedTpMsgs(0);
        WireMessage ackMsg = this.flowHandle.tpCreateAck();
        AppAckRangeCache rangecache = null;
        if (this.m_highestAppAcked > 0L) {
            rangecache = new AppAckRangeCache();
            rangecache.addTmp(1L, this.m_highestAppAcked);
            this.tpAddApplicationAcks((AssuredCtrlHeaderBean)ackMsg.getHeaderBean(), rangecache);
        } else {
            Trace.debug((Object)String.format("No need to add app ack!", new Object[0]));
        }
        this.flowHandle.tpSendAck(ackMsg, false, allowReactorComplete);
    }

    public int getWindowSize() {
        return this.getCurrentUnackedMessageListInfo().getWindowSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractUnackedMessageList.UnackedMessageListInfo getCurrentUnackedMessageListInfo() {
        this.rLock.lock();
        try {
            AbstractUnackedMessageList.UnackedMessageListInfo umli = new AbstractUnackedMessageList.UnackedMessageListInfo();
            umli.setLastInOrderTpMsgId(this.m_lastInOrderTpMsgId);
            int cur_list_sz = this.m_list.size();
            if (cur_list_sz >= this.m_queueSize) {
                umli.setWindowSize(0);
            } else {
                int rv = Math.min(this.m_sz, this.m_queueSize - cur_list_sz);
                umli.setWindowSize(rv);
            }
            AbstractUnackedMessageList.UnackedMessageListInfo unackedMessageListInfo = umli;
            Object var5_5 = null;
            this.rLock.unlock();
            return unackedMessageListInfo;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.rLock.unlock();
            throw throwable;
        }
    }

    public boolean isKnownAppAcked(long msgId) {
        return false;
    }

    public void sendCloseAcks(String reason, boolean allowReactorComplete) {
    }
}

