/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf.impl;

import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.InvalidMessageReceivedException;
import com.solacesystems.jcsmp.impl.ContentBuffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryMetadataEncoder {
    public ByteBuffer encodeBinaryMetadata(int type, ContentBuffer cb) {
        int enc_sz = BinaryMetadataEncoder.getBinaryMetaEncodedLength(cb);
        byte[] enc_data = new byte[enc_sz];
        if (enc_sz == 0) {
            return ByteBuffer.wrap(enc_data, 0, 0);
        }
        int pos = 0;
        enc_data[pos++] = NetworkByteOrderNumberUtil.intToOneByte(1);
        enc_data[pos++] = NetworkByteOrderNumberUtil.intToOneByte(type);
        NetworkByteOrderNumberUtil.intToThreeByte(cb.getLimit(), enc_data, pos);
        pos += 3;
        int len = cb.getLimit();
        if (len > 0) {
            cb.read(0, enc_data, pos, len);
            pos += len;
        }
        return ByteBuffer.wrap(enc_data, 0, pos);
    }

    public static HashMap<Integer, ContentBuffer> decodeBinaryMetadata(byte[] encoded, int client_offset, int client_length) throws InvalidMessageReceivedException {
        int sz;
        int buf_cnt = (int)NetworkByteOrderNumberUtil.oneByteToUInt(encoded[client_offset]);
        int cur_offset = client_offset + 1;
        ArrayList<Integer> keys = new ArrayList<Integer>();
        HashMap<Integer, Integer> keysLengths = new HashMap<Integer, Integer>();
        HashMap<Integer, ContentBuffer> retMap = new HashMap<Integer, ContentBuffer>();
        for (int i = 0; i < buf_cnt; ++i) {
            int type = (int)NetworkByteOrderNumberUtil.oneByteToUInt(encoded[cur_offset]);
            sz = (int)NetworkByteOrderNumberUtil.threeByteToUInt(encoded, cur_offset + 1);
            keys.add(type);
            keysLengths.put(type, sz);
            cur_offset += 4;
        }
        for (Integer i : keys) {
            sz = (Integer)keysLengths.get(i);
            ContentBuffer buf = new ContentBuffer(sz, false);
            buf.writeFromBytes(encoded, cur_offset, sz);
            cur_offset += sz;
            retMap.put(i, buf);
        }
        if (cur_offset != client_offset + client_length) {
            throw new InvalidMessageReceivedException("Error parsing binary metadata.");
        }
        return retMap;
    }

    public static int getBinaryMetaEncodedLength(ContentBuffer cb) {
        int sz;
        int encodedLen = 0;
        if (cb != null && (sz = cb.getLimit()) > 0) {
            encodedLen += 4 + sz;
        }
        return encodedLen == 0 ? 0 : encodedLen + 1;
    }

    public static int getBinaryMetaEncodedLength(Collection<ContentBuffer> buffers) {
        int encodedLen = 0;
        for (ContentBuffer cb : buffers) {
            int sz = cb.getLimit();
            if (sz <= 0) continue;
            encodedLen += 4 + sz;
        }
        return encodedLen == 0 ? 0 : encodedLen + 1;
    }
}

