/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.flow;

import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFatalErrorException;
import com.solacesystems.jcsmp.impl.JCSMPErrorResponseSubcodeMapper;
import com.solacesystems.jcsmp.impl.flow.FlowTask;
import com.solacesystems.jcsmp.impl.flow.TaskSessionRefs;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.impl.TcpChannel;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnsubscribeRequestTask
extends FlowTask {
    private static final Log Trace = LogFactory.getLog(UnsubscribeRequestTask.class);
    private final String dteName;

    public UnsubscribeRequestTask(String dteName, TaskSessionRefs t_refs) {
        super(null, t_refs);
        this.dteName = dteName;
    }

    public Object execute(Object obj) {
        Trace.debug((Object)"Executing response handler.");
        this.cancelTimer();
        assert (obj instanceof WireMessage);
        WireMessage respMsg = (WireMessage)obj;
        SMFHeaderBean smfHeader = respMsg.getSmfHeader();
        assert (smfHeader.getProtocol() == 9);
        if (smfHeader.getPm_respcode() != 200) {
            String networkInfoString = new String();
            if (this.subFlowMgr != null && this.subFlowMgr.subChannel != null) {
                networkInfoString = this.subFlowMgr.subChannel.getNetworkInfoString();
            }
            this.opEx = new JCSMPErrorResponseException(smfHeader.getPm_respcode(), smfHeader.getPm_respstr(), "", networkInfoString, JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
            if (Trace.isInfoEnabled()) {
                Trace.info((Object)("Error Response (" + smfHeader.getPm_respcode() + ") - " + smfHeader.getPm_respstr()));
            }
            Trace.debug((Object)"Got unsubscribe exception. ", (Throwable)((Object)this.opEx));
        } else {
            Trace.debug((Object)"Got OK UnsubscribeResponse");
        }
        this.responseLatch.countDown();
        return null;
    }

    public boolean submit(int corrTag, boolean allowOnStateSub, TcpChannel.WriteBlockPolicy wpolicy) throws JCSMPException {
        this.initTimerFlag();
        this.taskRefs.getChannel().sendUnsubscribeRequest(this.dteName, corrTag, allowOnStateSub, wpolicy);
        this.startTimer();
        return true;
    }

    public void waitResponse() throws JCSMPException {
        block3: {
            try {
                this.responseLatch.await();
            }
            catch (InterruptedException e) {
                if (this.opEx != null) break block3;
                this.opEx = new JCSMPFatalErrorException("Interrupted.", e);
            }
        }
        if (this.opEx != null) {
            throw this.opEx;
        }
    }
}

