/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.xa;

import com.solacesystems.common.SolReserved;
import com.solacesystems.common.xa.DefaultXidFormatter;
import com.solacesystems.common.xa.XidFormatter;
import java.io.Serializable;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public class SolXid
implements Xid,
Serializable {
    private static final long serialVersionUID = 152672982973869533L;
    private static XidFormatter _formatter = DefaultXidFormatter.onlyInstance;
    private int _formatId;
    private byte[] _globalTxId;
    private byte[] _branchQual;

    @SolReserved
    public static void setFormatter(XidFormatter fmtr) {
        _formatter = fmtr == null ? DefaultXidFormatter.onlyInstance : fmtr;
    }

    @SolReserved
    public static XidFormatter getFormmater() {
        return _formatter;
    }

    public SolXid(int formatId, byte[] globalTxId, byte[] branchQual) {
        this._formatId = formatId;
        this._globalTxId = globalTxId;
        this._branchQual = branchQual;
    }

    public SolXid(int formatId, String globalTxId, String branchQual) {
        this._formatId = formatId;
        this._branchQual = branchQual.getBytes();
        this._globalTxId = globalTxId.getBytes();
    }

    public byte[] getBranchQualifier() {
        return this._branchQual;
    }

    public int getFormatId() {
        return this._formatId;
    }

    public byte[] getGlobalTransactionId() {
        return this._globalTxId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Xid) {
            int i;
            Xid other = (Xid)obj;
            if (this._formatId != other.getFormatId()) {
                return false;
            }
            if (this._branchQual == null && other.getBranchQualifier() != null || this._branchQual != null && other.getBranchQualifier() == null) {
                return false;
            }
            if (this._globalTxId == null && other.getGlobalTransactionId() != null || this._globalTxId != null && other.getGlobalTransactionId() == null) {
                return false;
            }
            if (this._branchQual != null) {
                byte[] otherBranchQual = other.getBranchQualifier();
                if (this._branchQual.length != otherBranchQual.length) {
                    return false;
                }
                for (i = 0; i < this._branchQual.length; ++i) {
                    if (this._branchQual[i] == otherBranchQual[i]) continue;
                    return false;
                }
            }
            if (this._globalTxId != null) {
                byte[] otherGlobalTxId = other.getGlobalTransactionId();
                if (this._globalTxId.length != otherGlobalTxId.length) {
                    return false;
                }
                for (i = 0; i < this._globalTxId.length; ++i) {
                    if (this._globalTxId[i] == otherGlobalTxId[i]) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getBranchQualifier()) ^ Arrays.hashCode(this.getGlobalTransactionId()) ^ this.getFormatId();
    }

    public String toString() {
        return _formatter.toString(this);
    }

    private static void test(int fmtId, int otherFmtId, byte[] branchQual, byte[] otherBranchQual, byte[] globalId, byte[] otherGlobalId, String test, boolean result) {
        SolXid one = new SolXid(fmtId, globalId, branchQual);
        SolXid two = new SolXid(otherFmtId, otherGlobalId, otherBranchQual);
        if (((Object)one).equals(two)) {
            if (result) {
                System.out.println(String.format("%s {%s, %s} - OK", test, ((Object)one).toString(), ((Object)two).toString()));
            } else {
                System.err.println(String.format("%s {%s, %s} - Unexpectedly succeeded", test, ((Object)one).toString(), ((Object)two).toString()));
            }
        } else if (result) {
            System.err.println(String.format("%s {%s, %s} - Unexpectedly failed", test, ((Object)one).toString(), ((Object)two).toString()));
        } else {
            System.out.println(String.format("%s {%s, %s} - OK", test, ((Object)one).toString(), ((Object)two).toString()));
        }
    }

    public static void main(String[] args) {
        SolXid one = new SolXid(0, (byte[])null, (byte[])null);
        if (((Object)one).equals(null)) {
            System.err.println("Comparing to null failed!");
        }
        if (!((Object)one).equals(one)) {
            System.err.println("Comparing to itself failed!");
        }
        SolXid.test(1, 2, null, null, null, null, "Test different FmtId", false);
        SolXid.test(1, 1, null, null, null, null, "Test same FmtId", true);
        SolXid.test(2, 2, new byte[]{1}, null, null, null, "Test null branch1", false);
        SolXid.test(14, 14, null, new byte[]{1}, null, null, "Test null branch2", false);
        SolXid.test(110, 110, new byte[]{1}, new byte[]{1}, null, null, "Test branch", true);
        SolXid.test(11, 11, null, null, new byte[]{1}, null, "Test null tx1", false);
        SolXid.test(12, 12, null, null, null, new byte[]{1}, "Test null tx2", false);
        SolXid.test(13, 13, null, null, new byte[]{1}, new byte[]{1}, "Test tx", true);
        SolXid.test(14, 14, new byte[]{1, 2, 3}, new byte[]{1, 2, 3}, new byte[]{1, 2, 3}, new byte[]{1, 2, 3}, "Test everything", true);
        SolXid.test(14, 14, new byte[]{1}, new byte[0], new byte[]{1}, new byte[0], "Test different lengths1", false);
        SolXid.test(14, 14, new byte[0], new byte[]{1}, new byte[0], new byte[]{1}, "Test different lengths2", false);
    }
}

