/*
 * Decompiled with CFR 0.152.
 */
package com.socketLabs.injectionApi.core;

import com.socketLabs.injectionApi.AddressResult;
import com.socketLabs.injectionApi.SendResponse;
import com.socketLabs.injectionApi.SendResult;
import com.socketLabs.injectionApi.message.BasicMessage;
import com.socketLabs.injectionApi.message.BulkMessage;
import com.socketLabs.injectionApi.message.BulkRecipient;
import com.socketLabs.injectionApi.message.CustomHeader;
import com.socketLabs.injectionApi.message.EmailAddress;
import com.socketLabs.injectionApi.message.MessageBase;
import com.socketLabs.injectionApi.message.Metadata;
import java.util.ArrayList;
import java.util.List;

public class SendValidator {
    private int MaximumRecipientsPerMessage = 50;

    public SendResponse ValidateCredentials(int serverId, String apiKey) {
        if (this.isNullOrEmpty(apiKey)) {
            return new SendResponse(SendResult.AuthenticationValidationFailed);
        }
        if (serverId <= 0) {
            return new SendResponse(SendResult.AuthenticationValidationFailed);
        }
        return new SendResponse(SendResult.Success);
    }

    public SendResponse ValidateMessage(BasicMessage message) {
        SendResult result = this.ValidateMessageBase(message);
        if (result == SendResult.Success) {
            return this.ValidateRecipients(message);
        }
        return new SendResponse(result);
    }

    public SendResponse ValidateMessage(BulkMessage message) {
        SendResult result = this.ValidateMessageBase(message);
        if (result == SendResult.Success) {
            return this.ValidateRecipients(message);
        }
        return new SendResponse(result);
    }

    private SendResult ValidateMessageBase(MessageBase message) {
        if (!this.HasSubject(message)) {
            return SendResult.MessageValidationEmptySubject;
        }
        if (!this.HasFromAddress(message)) {
            return SendResult.EmailAddressValidationMissingFrom;
        }
        if (!message.getFrom().isValid()) {
            return SendResult.EmailAddressValidationInvalidFrom;
        }
        if (!this.HasValidReplyTo(message)) {
            return SendResult.RecipientValidationInvalidReplyTo;
        }
        if (!this.HasMessageBody(message)) {
            return SendResult.MessageValidationEmptyMessage;
        }
        if (message.getCustomHeaders() != null && !message.getCustomHeaders().isEmpty() && !this.HasValidCustomHeaders(message.getCustomHeaders())) {
            return SendResult.MessageValidationInvalidCustomHeaders;
        }
        if (message.getMetadata() != null && !message.getMetadata().isEmpty() && !this.HasValidMetadata(message.getMetadata())) {
            return SendResult.MessageValidationInvalidMetadata;
        }
        return SendResult.Success;
    }

    private boolean HasSubject(MessageBase message) {
        return !this.isNullOrEmpty(message.getSubject());
    }

    private boolean HasFromAddress(MessageBase message) {
        if (message.getFrom() == null) {
            return false;
        }
        return !this.isNullOrEmpty(message.getFrom().getEmailAddress());
    }

    private boolean HasMessageBody(MessageBase message) {
        boolean hasApiTemplate = this.HasApiTemplate(message);
        if (hasApiTemplate) {
            return true;
        }
        boolean hasHtmlBody = !this.isNullOrEmpty(message.getHtmlBody());
        boolean hasPlainTextBody = !this.isNullOrEmpty(message.getPlainTextBody());
        return hasHtmlBody || hasPlainTextBody;
    }

    private boolean HasApiTemplate(MessageBase message) {
        return message.getApiTemplate() == null || message.getApiTemplate() != 0;
    }

    private boolean HasValidReplyTo(MessageBase message) {
        if (message.getReplyTo() == null) {
            return true;
        }
        if (this.isNullOrEmpty(message.getReplyTo().getEmailAddress()) && this.isNullOrEmpty(message.getReplyTo().getFriendlyName())) {
            return true;
        }
        return message.getReplyTo().isValid();
    }

    private SendResponse ValidateRecipients(BasicMessage message) {
        int fullRecipientCount = this.GetFullRecipientCount(message);
        if (fullRecipientCount <= 0) {
            return new SendResponse(SendResult.RecipientValidationNoneInMessage);
        }
        if (fullRecipientCount > this.MaximumRecipientsPerMessage) {
            return new SendResponse(SendResult.RecipientValidationMaxExceeded);
        }
        List<AddressResult> invalidRec = this.HasInvalidRecipients(message);
        if (invalidRec != null && !invalidRec.isEmpty()) {
            return new SendResponse(SendResult.RecipientValidationInvalidRecipients, invalidRec);
        }
        return new SendResponse(SendResult.Success);
    }

    private SendResponse ValidateRecipients(BulkMessage message) {
        if (message.getTo() == null || message.getTo().size() <= 0) {
            return new SendResponse(SendResult.RecipientValidationMissingTo);
        }
        if (message.getTo().size() > this.MaximumRecipientsPerMessage) {
            return new SendResponse(SendResult.RecipientValidationMaxExceeded);
        }
        List<AddressResult> invalidRec = this.HasInvalidRecipients(message);
        if (invalidRec != null && !invalidRec.isEmpty()) {
            return new SendResponse(SendResult.RecipientValidationInvalidRecipients, invalidRec);
        }
        return new SendResponse(SendResult.Success);
    }

    private int GetFullRecipientCount(BasicMessage message) {
        int recipientCount = 0;
        if (message.getTo() != null) {
            recipientCount += message.getTo().size();
        }
        if (message.getCc() != null) {
            recipientCount += message.getCc().size();
        }
        if (message.getBcc() != null) {
            recipientCount += message.getBcc().size();
        }
        return recipientCount;
    }

    private List<AddressResult> HasInvalidRecipients(BasicMessage message) {
        List<AddressResult> invalidBcc;
        List<AddressResult> invalidCc;
        ArrayList<AddressResult> result = new ArrayList<AddressResult>();
        List<AddressResult> invalidTo = this.FindInvalidEmailAddresses(message.getTo());
        if (invalidTo != null && !invalidTo.isEmpty()) {
            result.addAll(invalidTo);
        }
        if ((invalidCc = this.FindInvalidEmailAddresses(message.getCc())) != null && !invalidCc.isEmpty()) {
            result.addAll(invalidCc);
        }
        if ((invalidBcc = this.FindInvalidEmailAddresses(message.getBcc())) != null && !invalidBcc.isEmpty()) {
            result.addAll(invalidBcc);
        }
        return result;
    }

    private List<AddressResult> HasInvalidRecipients(BulkMessage message) {
        ArrayList<AddressResult> result = new ArrayList<AddressResult>();
        List<AddressResult> invalidTo = this.FindInvalidRecipients(message.getTo());
        if (invalidTo != null && !invalidTo.isEmpty()) {
            result.addAll(invalidTo);
        }
        return result;
    }

    private List<AddressResult> FindInvalidEmailAddresses(List<EmailAddress> recipients) {
        ArrayList<AddressResult> invalid = new ArrayList<AddressResult>();
        for (EmailAddress r : recipients) {
            if (r.isValid()) continue;
            invalid.add(new AddressResult(r.getEmailAddress(), false, "InvalidAddress"));
        }
        return !invalid.isEmpty() ? invalid : null;
    }

    private List<AddressResult> FindInvalidRecipients(List<BulkRecipient> recipients) {
        ArrayList<AddressResult> invalid = new ArrayList<AddressResult>();
        for (BulkRecipient r : recipients) {
            if (r.isValid()) continue;
            invalid.add(new AddressResult(r.getEmailAddress(), false, "InvalidAddress"));
        }
        return !invalid.isEmpty() ? invalid : null;
    }

    private boolean HasValidCustomHeaders(List<CustomHeader> customHeaders) {
        for (CustomHeader c : customHeaders) {
            if (c.isValid()) continue;
            return false;
        }
        return true;
    }

    private boolean HasValidMetadata(List<Metadata> metadata) {
        for (Metadata m : metadata) {
            if (m.isValid()) continue;
            return false;
        }
        return true;
    }

    private boolean isNullOrEmpty(String string) {
        if (string == null) {
            return true;
        }
        if (string.isEmpty()) {
            return true;
        }
        return string.trim().equals("");
    }
}

