/*
 * Decompiled with CFR 0.152.
 */
package com.socketLabs.injectionApi.core;

import com.socketLabs.injectionApi.RetrySettings;
import com.socketLabs.injectionApi.core.HttpRequest;
import com.socketLabs.injectionApi.core.serialization.InjectionResponseParser;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class RetryHandler {
    private HttpRequest httpRequest;
    private String endPointUrl;
    private RetrySettings retrySettings;
    private int attempts = 0;
    private Set<Integer> ErrorStatusCodes = new HashSet<Integer>(Arrays.asList(500, 502, 503, 504));
    private Set<Class<? extends Exception>> Exceptions = new HashSet<Class>(Arrays.asList(SocketTimeoutException.class, InterruptedIOException.class));

    public RetryHandler(HttpRequest request, String endpointUrl, RetrySettings settings) {
        this.httpRequest = request;
        this.endPointUrl = endpointUrl;
        this.retrySettings = settings;
    }

    public Response send() throws IOException, InterruptedException {
        if (this.retrySettings.getMaximumNumberOfRetries() == 0) {
            Response response = this.httpRequest.SendRequest();
            return response;
        }
        while (true) {
            Duration waitInterval = this.retrySettings.getNextWaitInterval(this.attempts);
            try {
                Response response = this.httpRequest.SendRequest();
                if (this.ErrorStatusCodes.contains(response.networkResponse().code())) {
                    throw new IOException("Received Http Status Code : " + response.networkResponse().code());
                }
                return response;
            }
            catch (SocketTimeoutException exception) {
                ++this.attempts;
                if (this.attempts > this.retrySettings.getMaximumNumberOfRetries()) {
                    throw new SocketTimeoutException();
                }
                TimeUnit.MILLISECONDS.sleep(waitInterval.toMillis());
                continue;
            }
            catch (InterruptedIOException exception) {
                ++this.attempts;
                if (this.attempts > this.retrySettings.getMaximumNumberOfRetries()) {
                    throw new InterruptedIOException();
                }
                TimeUnit.MILLISECONDS.sleep(waitInterval.toMillis());
                continue;
            }
            catch (IOException exception) {
                ++this.attempts;
                if (this.attempts > this.retrySettings.getMaximumNumberOfRetries()) {
                    throw new IOException(exception.getMessage());
                }
                TimeUnit.MILLISECONDS.sleep(waitInterval.toMillis());
                continue;
            }
            break;
        }
    }

    public void sendAsync(final Callback callback) throws IOException, InterruptedException {
        InjectionResponseParser parser = new InjectionResponseParser();
        final Duration waitInterval = this.retrySettings.getNextWaitInterval(this.attempts);
        this.httpRequest.SendAsyncRequest(new Callback(){

            public void onResponse(Call call, Response response) throws IOException {
                if (RetryHandler.this.ErrorStatusCodes.contains(response.networkResponse().code()) && RetryHandler.this.attempts <= RetryHandler.this.retrySettings.getMaximumNumberOfRetries()) {
                    RetryHandler.this.attempts++;
                    try {
                        TimeUnit.MILLISECONDS.sleep(waitInterval.toMillis());
                        RetryHandler.this.sendAsync(callback);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                } else {
                    callback.onResponse(call, response);
                }
            }

            public void onFailure(Call call, IOException exception) {
                if (RetryHandler.this.Exceptions.contains(exception.getClass()) && RetryHandler.this.attempts <= RetryHandler.this.retrySettings.getMaximumNumberOfRetries()) {
                    RetryHandler.this.attempts++;
                    try {
                        TimeUnit.MILLISECONDS.sleep(waitInterval.toMillis());
                        RetryHandler.this.sendAsync(callback);
                    }
                    catch (IOException ioException) {
                        ioException.printStackTrace();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                } else {
                    RetryHandler.this.attempts = RetryHandler.this.retrySettings.getMaximumNumberOfRetries() + 1;
                    callback.onFailure(call, exception);
                }
            }
        });
    }
}

