/*
 * Decompiled with CFR 0.152.
 */
package com.socketLabs.injectionApi.message;

import com.socketLabs.injectionApi.message.CustomHeader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;

public class Attachment {
    private String name;
    private String mimeType;
    private String contentId;
    private byte[] content;
    private List<CustomHeader> customHeaders = new ArrayList<CustomHeader>();

    public Attachment() {
    }

    public Attachment(String filePath) throws IOException {
        this.content = this.getContentFromFilePath(filePath);
        this.name = new File(filePath).getName();
        String[] splitPath = this.name.split("\\.");
        this.mimeType = this.getMimeTypeFromExtension(splitPath[splitPath.length - 1]);
    }

    public Attachment(String name, String mimeType, String filePath) throws IOException {
        this.content = this.getContentFromFilePath(filePath);
        this.name = name;
        this.mimeType = mimeType;
    }

    public Attachment(String name, String mimeType, byte[] content) {
        this.name = name;
        this.mimeType = mimeType;
        this.content = content;
    }

    public Attachment(String name, String mimeType, InputStream stream) throws IOException {
        this.name = name;
        this.mimeType = mimeType;
        this.content = this.getBase64String(stream);
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public String getContentId() {
        return this.contentId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<CustomHeader> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(List<CustomHeader> customHeaders) {
        this.customHeaders = customHeaders;
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.add(new CustomHeader(name, value));
    }

    private byte[] getContentFromFilePath(String filepath) throws IOException {
        return Files.readAllBytes(new File(filepath).toPath());
    }

    private String getMimeTypeFromExtension(String extension) {
        switch (extension.toLowerCase()) {
            case "txt": 
            case "ini": 
            case "sln": 
            case "cs": 
            case "js": 
            case "config": 
            case "vb": {
                return "text/plain";
            }
            case "jpg": 
            case "jpeg": {
                return "image/jpeg";
            }
            case "bmp": {
                return "image/bmp";
            }
            case "csv": {
                return "text/csv";
            }
            case "doc": {
                return "application/msword";
            }
            case "docx": {
                return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
            }
            case "gif": {
                return "image/gif";
            }
            case "html": {
                return "text/html";
            }
            case "pdf": {
                return "application/pdf";
            }
            case "png": {
                return "image/png";
            }
            case "ppt": {
                return "application/vnd.ms-powerpoint";
            }
            case "pptx": {
                return "application/vnd.openxmlformats-officedocument.presentationml.presentation";
            }
            case "xls": {
                return "application/vnd.ms-excel";
            }
            case "xlsx": {
                return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
            }
            case "xml": {
                return "application/xml";
            }
            case "zip": {
                return "application/x-zip-compressed";
            }
            case "wav": {
                return "audio/wav";
            }
            case "eml": {
                return "message/rfc822";
            }
            case "mp3": {
                return "audio/mpeg";
            }
            case "mp4": {
                return "video/mp4";
            }
            case "mov": {
                return "video/quicktime";
            }
        }
        return "application/octet-stream";
    }

    private byte[] getBase64String(InputStream stream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = stream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public String toString() {
        return String.format("%s, %s", this.name, this.mimeType);
    }
}

