/*
 * Decompiled with CFR 0.152.
 */
package com.socketLabs.injectionApi.core;

import com.socketLabs.injectionApi.SendResponse;
import com.socketLabs.injectionApi.core.serialization.InjectionResponseParser;
import java.io.IOException;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpRequest {
    private HttpRequestMethod method;
    private String endPointUrl;
    private String body;
    private Proxy proxy;
    private Map<String, String> headers = new HashMap<String, String>();
    private int timeout;
    public static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");

    public HttpRequest(HttpRequestMethod method, String endPointUrl, int timeout) {
        this.method = method;
        this.endPointUrl = endPointUrl;
        this.timeout = timeout;
    }

    public void setBody(String value) {
        this.body = value;
    }

    public void setHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void setProxy(Proxy value) {
        this.proxy = value;
    }

    public Response SendRequest() throws IOException {
        Call call = this.BuildClientCall();
        Response response = call.execute();
        return response;
    }

    public void SendAsyncRequest(final Callback callback) {
        Call call = this.BuildClientCall();
        call.enqueue(new Callback(){

            public void onResponse(Call call, Response response) throws IOException {
                callback.onResponse(call, response);
            }

            public void onFailure(Call call, IOException ex) {
                callback.onFailure(call, ex);
            }
        });
    }

    private Call BuildClientCall() {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectTimeout((long)this.timeout, TimeUnit.SECONDS).writeTimeout((long)this.timeout, TimeUnit.SECONDS).readTimeout((long)this.timeout, TimeUnit.SECONDS).callTimeout((long)this.timeout, TimeUnit.SECONDS);
        OkHttpClient client = clientBuilder.build();
        if (this.proxy != null) {
            client = clientBuilder.proxy(this.proxy).build();
        }
        Request.Builder builder = new Request.Builder().url(this.endPointUrl);
        RequestBody reqBody = RequestBody.create((MediaType)JSON, (String)this.body);
        switch (this.method) {
            case POST: {
                builder.post(reqBody);
                break;
            }
            case GET: {
                builder.get();
                break;
            }
            case PUT: {
                builder.put(reqBody);
                break;
            }
            case DELETE: {
                builder.delete(reqBody);
            }
        }
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            builder.addHeader(header.getKey(), header.getValue());
        }
        return client.newCall(builder.build());
    }

    private SendResponse ParseResponse(Response response) throws IOException {
        InjectionResponseParser parser = new InjectionResponseParser();
        return parser.Parse(response);
    }

    public static enum HttpRequestMethod {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

