/*
 * Decompiled with CFR 0.152.
 */
package com.socketLabs.injectionApi;

import com.socketLabs.injectionApi.RetrySettings;
import com.socketLabs.injectionApi.SendResponse;
import com.socketLabs.injectionApi.SendResult;
import com.socketLabs.injectionApi.SocketLabsClientAPI;
import com.socketLabs.injectionApi.core.HttpRequest;
import com.socketLabs.injectionApi.core.RetryHandler;
import com.socketLabs.injectionApi.core.SendAsyncCallback;
import com.socketLabs.injectionApi.core.SendValidator;
import com.socketLabs.injectionApi.core.serialization.InjectionRequestFactory;
import com.socketLabs.injectionApi.core.serialization.InjectionResponseParser;
import com.socketLabs.injectionApi.message.BasicMessage;
import com.socketLabs.injectionApi.message.BulkMessage;
import java.io.IOException;
import java.net.Proxy;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class SocketLabsClient
implements SocketLabsClientAPI {
    private int serverId;
    private String apiKey;
    private String endPointUrl = "https://inject.socketlabs.com/api/v1/email";
    private Proxy proxy;
    private int requestTimeout = 100;
    private int numberOfRetries = 0;
    private final String VERSION = "1.0.0";
    private final String userAgent = String.format("SocketLabs-java/%s(%s)", "1.0.0", Package.getPackage("java.util").getImplementationVersion());

    public void setEndPointUrl(String value) {
        this.endPointUrl = value;
    }

    public void setRequestTimeout(int value) {
        this.requestTimeout = value;
    }

    public void setNumberOfRetries(int value) {
        this.numberOfRetries = value;
    }

    public SocketLabsClient(int serverId, String apiKey) {
        this.serverId = serverId;
        this.apiKey = apiKey;
    }

    public SocketLabsClient(int serverId, String apiKey, Proxy optionalProxy) {
        this.serverId = serverId;
        this.apiKey = apiKey;
        this.proxy = optionalProxy;
    }

    @Override
    public SendResponse send(BasicMessage message) throws Exception {
        SendResponse result = this.Validate(message);
        if (result.getResult() != SendResult.Success) {
            return result;
        }
        HttpRequest request = this.buildHttpRequest(this.proxy);
        request.setBody(new InjectionRequestFactory(this.serverId, this.apiKey).GenerateRequest(message));
        RetryHandler retryHandler = new RetryHandler(request, this.endPointUrl, new RetrySettings(this.numberOfRetries));
        Response response = retryHandler.send();
        InjectionResponseParser parser = new InjectionResponseParser();
        return parser.Parse(response);
    }

    @Override
    public SendResponse send(BulkMessage message) throws Exception {
        SendResponse result = this.Validate(message);
        if (result.getResult() != SendResult.Success) {
            return result;
        }
        HttpRequest request = this.buildHttpRequest(this.proxy);
        request.setBody(new InjectionRequestFactory(this.serverId, this.apiKey).GenerateRequest(message));
        RetryHandler retryHandler = new RetryHandler(request, this.endPointUrl, new RetrySettings(this.numberOfRetries));
        Response response = retryHandler.send();
        InjectionResponseParser parser = new InjectionResponseParser();
        return parser.Parse(response);
    }

    @Override
    public void sendAsync(BasicMessage message, final SendAsyncCallback callback) throws Exception {
        SendResponse result = this.Validate(message);
        if (result.getResult() != SendResult.Success) {
            callback.onResponse(result);
            return;
        }
        HttpRequest request = this.buildHttpRequest(this.proxy);
        request.setBody(new InjectionRequestFactory(this.serverId, this.apiKey).GenerateRequest(message));
        RetryHandler retryHandler = new RetryHandler(request, this.endPointUrl, new RetrySettings(this.numberOfRetries));
        final InjectionResponseParser parser = new InjectionResponseParser();
        retryHandler.sendAsync(new Callback(){

            public void onResponse(Call call, Response response) throws IOException {
                callback.onResponse(parser.Parse(response));
            }

            public void onFailure(Call call, IOException ex) {
                callback.onError(ex);
            }
        });
    }

    @Override
    public void sendAsync(BulkMessage message, final SendAsyncCallback callback) throws Exception {
        SendResponse result = this.Validate(message);
        if (result.getResult() != SendResult.Success) {
            callback.onResponse(result);
            return;
        }
        HttpRequest request = this.buildHttpRequest(this.proxy);
        request.setBody(new InjectionRequestFactory(this.serverId, this.apiKey).GenerateRequest(message));
        RetryHandler retryHandler = new RetryHandler(request, this.endPointUrl, new RetrySettings(this.numberOfRetries));
        final InjectionResponseParser parser = new InjectionResponseParser();
        retryHandler.sendAsync(new Callback(){

            public void onResponse(Call call, Response response) throws IOException {
                callback.onResponse(parser.Parse(response));
            }

            public void onFailure(Call call, IOException ex) {
                callback.onError(ex);
            }
        });
    }

    private SendResponse Validate(BasicMessage message) {
        SendValidator validator = new SendValidator();
        SendResponse result = validator.ValidateCredentials(this.serverId, this.apiKey);
        if (result.getResult() != SendResult.Success) {
            return result;
        }
        return validator.ValidateMessage(message);
    }

    private SendResponse Validate(BulkMessage message) {
        SendValidator validator = new SendValidator();
        SendResponse result = validator.ValidateCredentials(this.serverId, this.apiKey);
        if (result.getResult() != SendResult.Success) {
            return result;
        }
        return validator.ValidateMessage(message);
    }

    private HttpRequest buildHttpRequest(Proxy optionalProxy) {
        HttpRequest request = new HttpRequest(HttpRequest.HttpRequestMethod.POST, this.endPointUrl, this.requestTimeout);
        request.setHeader("User-Agent", this.userAgent);
        request.setHeader("content-type", "application/json");
        request.setHeader("Accept", "application/json");
        if (optionalProxy != null) {
            request.setProxy(optionalProxy);
        }
        return request;
    }
}

