/*
 * Decompiled with CFR 0.152.
 */
package com.socketLabs.injectionApi;

import java.time.Duration;
import java.util.Random;

public class RetrySettings {
    private final int defaultNumberOfRetries = 0;
    private final int maximumAllowedNumberOfRetries = 5;
    private Duration minimumRetryTIme = Duration.ofSeconds(1L);
    private Duration maximumRetryTime = Duration.ofSeconds(10L);
    private int maximumNumberOfRetries = 0;

    public RetrySettings(int maximumRetries) {
        if (maximumRetries < 0) {
            throw new IllegalArgumentException("maximumNumberOfRetries must be greater than 0");
        }
        if (maximumRetries > 5) {
            throw new IllegalArgumentException("The maximum number of allowed retries is 5");
        }
        this.maximumNumberOfRetries = maximumRetries;
    }

    public int getMaximumNumberOfRetries() {
        return this.maximumNumberOfRetries;
    }

    public Duration getNextWaitInterval(int numberOfAttempts) {
        long interval = Math.min(this.minimumRetryTIme.toMillis() + (long)this.getRetryDelta(numberOfAttempts), this.maximumRetryTime.toMillis());
        return Duration.ofMillis(interval);
    }

    public int getRetryDelta(int numberOfAttempts) {
        Random random = new Random();
        int min = (int)((double)Duration.ofSeconds(1L).toMillis() * 0.8);
        int max = (int)((double)Duration.ofSeconds(1L).toMillis() * 1.2);
        int randomNumber = random.nextInt(max - min) + min;
        return (int)((Math.pow(2.0, numberOfAttempts) - 1.0) * (double)randomNumber);
    }
}

