package com.socketLabs.injectionApi.core.serialization;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/**
 * Data transfer object representing the Injection Api response.
 */
class InjectionResponseDto {

    /** The resulting response ErrorCode of the Injection Api send request */
    @JsonProperty("ErrorCode")
    private String errorCode;

    /**
    * A unique key generated by the Injection API if an unexpected error occurs during the SocketLabsClient send request.
    * This unique key can be used by SocketLabs support to troubleshoot the issue.
    */
    @JsonProperty("TransactionReceipt")
    private String transactionReceipt;

    /** An array of MessageResultDto objects that contain the status of each message sent. */
    @JsonProperty("MessageResults")
    private List<MessageResultDto> messageResults;

    /**
     * Get the resulting response ErrorCode of the Injection Api send request
     * @return String
     */
    public String getErrorCode() {
        return errorCode;
    }
    /**
     * Set the resulting response ErrorCode of the Injection Api send request
     * @param value String
     */
    public void setErrorCode(String value) {
        this.errorCode = value;
    }

    /**
     * Get the unique key generated by the Injection API if an unexpected error occurs during the SocketLabsClient send request.
     * @return String
     */
    public String getTransactionReceipt() {
        return transactionReceipt;
    }
    /**
     * Set the unique key generated by the Injection API if an unexpected error occurs during the SocketLabsClient send request.
     * @param value String
     */
    public void setTransactionReceipt(String value) {
        this.transactionReceipt = value;
    }

    /**
     * Get the array of MessageResultDto objects that contain the status of each message sent.
     * @return List<MessageResultDto>
     */
    public List<MessageResultDto> getMessageResults() {
        return messageResults;
    }
    /**
     * Set the array of MessageResultDto objects that contain the status of each message sent.
     * @param value List<MessageResultDto>
     */
    public void setMessageResults(List<MessageResultDto> value) {
        this.messageResults = value;
    }
}
