/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.util;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0005J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/snowplowanalytics/snowplow/util/TimeMeasure;", "Ljava/io/Serializable;", "value", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)V", "getUnit", "()Ljava/util/concurrent/TimeUnit;", "getValue", "()J", "convert", "toUnit", "equals", "", "other", "", "hashCode", "", "toString", "", "snowplow-android-tracker_release"})
public final class TimeMeasure
implements Serializable {
    private final long value;
    @NotNull
    private final TimeUnit unit;

    public TimeMeasure(long value, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this.value = value;
        this.unit = unit;
    }

    public final long getValue() {
        return this.value;
    }

    @NotNull
    public final TimeUnit getUnit() {
        return this.unit;
    }

    public final long convert(@NotNull TimeUnit toUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)toUnit), (String)"toUnit");
        return toUnit.convert(this.value, this.unit);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        TimeMeasure that = other instanceof TimeMeasure ? (TimeMeasure)other : null;
        long ms1 = this.convert(TimeUnit.MILLISECONDS);
        TimeMeasure timeMeasure = that;
        Long ms2 = timeMeasure != null ? Long.valueOf(timeMeasure.convert(TimeUnit.MILLISECONDS)) : null;
        Long l = ms2;
        return l != null && ms1 == l;
    }

    public int hashCode() {
        int result = (int)(this.value ^ this.value >>> 32);
        result = 31 * result + this.unit.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "TimeMeasure{value=" + this.value + ", unit=" + (Object)((Object)this.unit) + '}';
    }
}

