/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.network;

import android.content.Context;
import android.net.TrafficStats;
import android.net.Uri;
import android.os.Build;
import com.snowplowanalytics.core.emitter.EmitterDefaults;
import com.snowplowanalytics.core.emitter.Executor;
import com.snowplowanalytics.core.emitter.TLSArguments;
import com.snowplowanalytics.core.emitter.TLSVersion;
import com.snowplowanalytics.core.tracker.Logger;
import com.snowplowanalytics.snowplow.network.CollectorCookieJar;
import com.snowplowanalytics.snowplow.network.HttpMethod;
import com.snowplowanalytics.snowplow.network.NetworkConnection;
import com.snowplowanalytics.snowplow.network.Protocol;
import com.snowplowanalytics.snowplow.network.Request;
import com.snowplowanalytics.snowplow.network.RequestResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.CookieJar;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 -2\u00020\u0001:\u0002-.B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\bH\u0002J\u0018\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\bH\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0'2\u0006\u0010\"\u001a\u00020!H\u0002J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020!H\u0002J\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020#0*H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/snowplowanalytics/snowplow/network/OkHttpNetworkConnection;", "Lcom/snowplowanalytics/snowplow/network/NetworkConnection;", "builder", "Lcom/snowplowanalytics/snowplow/network/OkHttpNetworkConnection$OkHttpNetworkConnectionBuilder;", "(Lcom/snowplowanalytics/snowplow/network/OkHttpNetworkConnection$OkHttpNetworkConnectionBuilder;)V", "JSON", "Lokhttp3/MediaType;", "TAG", "", "kotlin.jvm.PlatformType", "client", "Lokhttp3/OkHttpClient;", "customPostPath", "emitTimeout", "", "httpMethod", "Lcom/snowplowanalytics/snowplow/network/HttpMethod;", "getHttpMethod", "()Lcom/snowplowanalytics/snowplow/network/HttpMethod;", "networkUri", "protocol", "Lcom/snowplowanalytics/snowplow/network/Protocol;", "requestHeaders", "", "serverAnonymisation", "", "uri", "Landroid/net/Uri;", "getUri", "()Landroid/net/Uri;", "uriBuilder", "Landroid/net/Uri$Builder;", "buildGetRequest", "Lokhttp3/Request;", "request", "Lcom/snowplowanalytics/snowplow/network/Request;", "userAgent", "buildPostRequest", "getRequestCallable", "Ljava/util/concurrent/Callable;", "requestSender", "sendRequests", "", "Lcom/snowplowanalytics/snowplow/network/RequestResult;", "requests", "Companion", "OkHttpNetworkConnectionBuilder", "snowplow-android-tracker_release"})
@SourceDebugExtension(value={"SMAP\nOkHttpNetworkConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHttpNetworkConnection.kt\ncom/snowplowanalytics/snowplow/network/OkHttpNetworkConnection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,388:1\n1#2:389\n215#3,2:390\n215#3,2:392\n*S KotlinDebug\n*F\n+ 1 OkHttpNetworkConnection.kt\ncom/snowplowanalytics/snowplow/network/OkHttpNetworkConnection\n*L\n313#1:390,2\n339#1:392,2\n*E\n"})
public final class OkHttpNetworkConnection
implements NetworkConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final String TAG;
    @Nullable
    private final MediaType JSON;
    @NotNull
    private final String networkUri;
    @NotNull
    private final Protocol protocol;
    @NotNull
    private final HttpMethod httpMethod;
    private final int emitTimeout;
    @Nullable
    private final String customPostPath;
    private final boolean serverAnonymisation;
    @Nullable
    private final Map<String, String> requestHeaders;
    @Nullable
    private OkHttpClient client;
    @NotNull
    private final Uri.Builder uriBuilder;
    private static final int TRAFFIC_STATS_TAG = 1;
    @NotNull
    private static final String DEFAULT_USER_AGENT;

    /*
     * Unable to fully structure code
     */
    private OkHttpNetworkConnection(OkHttpNetworkConnectionBuilder builder) {
        block18: {
            block17: {
                super();
                this.TAG = OkHttpNetworkConnection.class.getSimpleName();
                this.JSON = MediaType.Companion.parse("application/json; charset=utf-8");
                tempUri = builder.getUri();
                url = Uri.parse((String)builder.getUri());
                tempProtocol = Protocol.HTTPS;
                if (url.getScheme() != null) break block17;
                tempUri = "https://" + builder.getUri();
                break block18;
            }
            var5_5 = url.getScheme();
            if (var5_5 == null) ** GOTO lbl-1000
            tmp = -1;
            switch (var5_5.hashCode()) {
                case 3213448: {
                    if (var5_5.equals("http")) {
                        tmp = 1;
                    }
                    break;
                }
                case 99617003: {
                    if (var5_5.equals("https")) {
                        tmp = 2;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    tempProtocol = Protocol.HTTP;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    tempUri = "https://" + builder.getUri();
                }
                case 2: 
            }
        }
        this.networkUri = tempUri;
        this.protocol = tempProtocol;
        this.httpMethod = builder.getHttpMethod();
        this.emitTimeout = builder.getEmitTimeout();
        this.customPostPath = builder.getCustomPostPath();
        this.serverAnonymisation = builder.getServerAnonymisation();
        this.requestHeaders = builder.getRequestHeaders();
        tlsArguments = new TLSArguments(builder.getTlsVersions());
        v0 = Uri.parse((String)this.networkUri).buildUpon();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"parse(networkUri).buildUpon()");
        this.uriBuilder = v0;
        if (this.getHttpMethod() == HttpMethod.GET) {
            this.uriBuilder.appendPath("i");
        } else if (this.customPostPath == null) {
            this.uriBuilder.appendEncodedPath("com.snowplowanalytics.snowplow/tp2");
        } else {
            this.uriBuilder.appendEncodedPath(this.customPostPath);
        }
        if (builder.getClient() == null) {
            v1 = new OkHttpClient.Builder().sslSocketFactory(tlsArguments.getSslSocketFactory(), tlsArguments.getTrustManager()).connectTimeout(15L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS);
            v2 = builder.getCookieJar();
            if (v2 == null) {
                v2 = new CollectorCookieJar(builder.getContext());
            }
            v3 = v1.cookieJar(v2).build();
        } else {
            v3 = builder.getClient();
        }
        this.client = v3;
    }

    @Override
    @NotNull
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    @NotNull
    public Uri getUri() {
        Uri uri = this.uriBuilder.clearQuery().build();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uriBuilder.clearQuery().build()");
        return uri;
    }

    @Override
    @NotNull
    public List<RequestResult> sendRequests(@NotNull List<Request> requests) {
        Intrinsics.checkNotNullParameter(requests, (String)"requests");
        List futures = new ArrayList();
        List results = new ArrayList();
        for (Request request : requests) {
            String string = request.getCustomUserAgent();
            if (string == null) {
                string = DEFAULT_USER_AGENT;
            }
            String userAgent = string;
            okhttp3.Request okHttpRequest = this.getHttpMethod() == HttpMethod.GET ? this.buildGetRequest(request, userAgent) : this.buildPostRequest(request, userAgent);
            futures.add(Executor.futureCallable(this.getRequestCallable(okHttpRequest)));
        }
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Object[] objectArray = new Object[]{futures.size()};
        Logger.d(string, "Request Futures: %s", objectArray);
        int n = futures.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            int code = 0;
            code = -1;
            try {
                Integer tempCode;
                object = ((Future)futures.get(i)).get(this.emitTimeout, TimeUnit.SECONDS);
                Integer n2 = tempCode = object instanceof Integer ? (Integer)object : null;
                if (n2 != null) {
                    int it = ((Number)n2).intValue();
                    boolean bl = false;
                    code = it;
                }
            }
            catch (InterruptedException ie) {
                String string2 = this.TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
                object = new Object[]{ie.getMessage()};
                Logger.e(string2, "Request Future was interrupted: %s", object);
            }
            catch (ExecutionException ee) {
                String string3 = this.TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TAG");
                object = new Object[]{ee.getMessage()};
                Logger.e(string3, "Request Future failed: %s", object);
            }
            catch (TimeoutException te) {
                String string4 = this.TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"TAG");
                object = new Object[]{te.getMessage()};
                Logger.e(string4, "Request Future had a timeout: %s", object);
            }
            Request request = requests.get(i);
            List<Long> eventIds = request.getEmitterEventIds();
            results.add(new RequestResult(code, request.getOversize(), eventIds));
            if (!request.getOversize()) continue;
            String string5 = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"TAG");
            Object[] objectArray2 = new Object[]{eventIds.toString()};
            Logger.track(string5, "Request is oversized for emitter event IDs: %s", objectArray2);
        }
        return results;
    }

    private final okhttp3.Request buildGetRequest(Request request, String userAgent) {
        Request.Builder builder2;
        block3: {
            this.uriBuilder.clearQuery();
            Map<String, Object> hashMap = request.getPayload().getMap();
            for (String key : hashMap.keySet()) {
                Object object = hashMap.get(key);
                String value = object instanceof String ? (String)object : null;
                this.uriBuilder.appendQueryParameter(key, value);
            }
            String string = this.uriBuilder.build().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uriBuilder.build().toString()");
            String reqUrl = string;
            builder2 = new Request.Builder().url(reqUrl).header("User-Agent", userAgent).get();
            if (this.serverAnonymisation) {
                builder2.header("SP-Anonymous", "*");
            }
            Map<String, String> map = this.requestHeaders;
            if (map == null) break block3;
            Map<String, String> it = map;
            boolean bl = false;
            Map<String, String> $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl2 = false;
                String key = entry.getKey();
                String value = entry.getValue();
                builder2.header(key, value);
            }
        }
        return builder2.build();
    }

    private final okhttp3.Request buildPostRequest(Request request, String userAgent) {
        Request.Builder builder2;
        block2: {
            String string = this.uriBuilder.build().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uriBuilder.build().toString()");
            String reqUrl = string;
            RequestBody reqBody = RequestBody.Companion.create(((Object)request.getPayload()).toString(), this.JSON);
            builder2 = new Request.Builder().url(reqUrl).header("User-Agent", userAgent).post(reqBody);
            if (this.serverAnonymisation) {
                builder2.header("SP-Anonymous", "*");
            }
            Map<String, String> map = this.requestHeaders;
            if (map == null) break block2;
            Map<String, String> it = map;
            boolean bl = false;
            Map<String, String> $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl2 = false;
                String key = entry.getKey();
                String value = entry.getValue();
                builder2.header(key, value);
            }
        }
        return builder2.build();
    }

    private final Callable<Integer> getRequestCallable(okhttp3.Request request) {
        return () -> OkHttpNetworkConnection.getRequestCallable$lambda$5(this, request);
    }

    private final int requestSender(okhttp3.Request request) {
        int n;
        try {
            Response resp;
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Object[] objectArray = new Object[]{request};
            Logger.v(string, "Sending request: %s", objectArray);
            TrafficStats.setThreadStatsTag((int)1);
            OkHttpClient okHttpClient = this.client;
            Response response = resp = okHttpClient != null && (okHttpClient = okHttpClient.newCall(request)) != null ? okHttpClient.execute() : null;
            if (response != null) {
                Response it = response;
                boolean bl = false;
                ResponseBody responseBody = resp.body();
                if (responseBody != null) {
                    responseBody.close();
                }
                return resp.code();
            }
            n = -1;
        }
        catch (IOException e) {
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Object[] objectArray = new Object[]{e.toString()};
            Logger.e(string, "Request sending failed: %s", objectArray);
            n = -1;
        }
        return n;
    }

    private static final Integer getRequestCallable$lambda$5(OkHttpNetworkConnection this$0, okhttp3.Request $request) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        return this$0.requestSender($request);
    }

    public /* synthetic */ OkHttpNetworkConnection(OkHttpNetworkConnectionBuilder builder2, DefaultConstructorMarker $constructor_marker) {
        this(builder2);
    }

    static {
        String string = "snowplow/%s android/%s";
        Object[] objectArray = new Object[]{"andr-5.6.0", Build.VERSION.RELEASE};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        DEFAULT_USER_AGENT = string2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010:\u001a\u00020;J\u0010\u0010\u0007\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0010\u0010\u0015\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010<\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!J\u001c\u0010&\u001a\u00020\u00002\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010'J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010,\u001a\u00020-J\u000e\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u000204J\u0014\u0010=\u001a\u00020\u00002\f\u0010?\u001a\b\u0012\u0004\u0012\u00020403R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R(\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R \u00102\u001a\b\u0012\u0004\u0012\u00020403X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u0017\u00a8\u0006@"}, d2={"Lcom/snowplowanalytics/snowplow/network/OkHttpNetworkConnection$OkHttpNetworkConnectionBuilder;", "", "uri", "", "context", "Landroid/content/Context;", "(Ljava/lang/String;Landroid/content/Context;)V", "client", "Lokhttp3/OkHttpClient;", "getClient", "()Lokhttp3/OkHttpClient;", "setClient", "(Lokhttp3/OkHttpClient;)V", "getContext", "()Landroid/content/Context;", "cookieJar", "Lokhttp3/CookieJar;", "getCookieJar", "()Lokhttp3/CookieJar;", "setCookieJar", "(Lokhttp3/CookieJar;)V", "customPostPath", "getCustomPostPath", "()Ljava/lang/String;", "setCustomPostPath", "(Ljava/lang/String;)V", "emitTimeout", "", "getEmitTimeout", "()I", "setEmitTimeout", "(I)V", "httpMethod", "Lcom/snowplowanalytics/snowplow/network/HttpMethod;", "getHttpMethod", "()Lcom/snowplowanalytics/snowplow/network/HttpMethod;", "setHttpMethod", "(Lcom/snowplowanalytics/snowplow/network/HttpMethod;)V", "requestHeaders", "", "getRequestHeaders", "()Ljava/util/Map;", "setRequestHeaders", "(Ljava/util/Map;)V", "serverAnonymisation", "", "getServerAnonymisation", "()Z", "setServerAnonymisation", "(Z)V", "tlsVersions", "Ljava/util/EnumSet;", "Lcom/snowplowanalytics/core/emitter/TLSVersion;", "getTlsVersions", "()Ljava/util/EnumSet;", "setTlsVersions", "(Ljava/util/EnumSet;)V", "getUri", "build", "Lcom/snowplowanalytics/snowplow/network/OkHttpNetworkConnection;", "method", "tls", "version", "versions", "snowplow-android-tracker_release"})
    public static final class OkHttpNetworkConnectionBuilder {
        @NotNull
        private final String uri;
        @NotNull
        private final Context context;
        @NotNull
        private HttpMethod httpMethod;
        @NotNull
        private EnumSet<TLSVersion> tlsVersions;
        private int emitTimeout;
        @Nullable
        private OkHttpClient client;
        @Nullable
        private CookieJar cookieJar;
        @Nullable
        private String customPostPath;
        private boolean serverAnonymisation;
        @Nullable
        private Map<String, String> requestHeaders;

        public OkHttpNetworkConnectionBuilder(@NotNull String uri, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.uri = uri;
            this.context = context;
            this.httpMethod = EmitterDefaults.INSTANCE.getHttpMethod();
            this.tlsVersions = EmitterDefaults.INSTANCE.getTlsVersions();
            this.emitTimeout = EmitterDefaults.INSTANCE.getEmitTimeout();
            this.serverAnonymisation = EmitterDefaults.INSTANCE.getServerAnonymisation();
        }

        @NotNull
        public final String getUri() {
            return this.uri;
        }

        @NotNull
        public final Context getContext() {
            return this.context;
        }

        @NotNull
        public final HttpMethod getHttpMethod() {
            return this.httpMethod;
        }

        public final void setHttpMethod(@NotNull HttpMethod httpMethod) {
            Intrinsics.checkNotNullParameter((Object)((Object)httpMethod), (String)"<set-?>");
            this.httpMethod = httpMethod;
        }

        @NotNull
        public final EnumSet<TLSVersion> getTlsVersions() {
            return this.tlsVersions;
        }

        public final void setTlsVersions(@NotNull EnumSet<TLSVersion> enumSet) {
            Intrinsics.checkNotNullParameter(enumSet, (String)"<set-?>");
            this.tlsVersions = enumSet;
        }

        public final int getEmitTimeout() {
            return this.emitTimeout;
        }

        public final void setEmitTimeout(int n) {
            this.emitTimeout = n;
        }

        @Nullable
        public final OkHttpClient getClient() {
            return this.client;
        }

        public final void setClient(@Nullable OkHttpClient okHttpClient) {
            this.client = okHttpClient;
        }

        @Nullable
        public final CookieJar getCookieJar() {
            return this.cookieJar;
        }

        public final void setCookieJar(@Nullable CookieJar cookieJar) {
            this.cookieJar = cookieJar;
        }

        @Nullable
        public final String getCustomPostPath() {
            return this.customPostPath;
        }

        public final void setCustomPostPath(@Nullable String string) {
            this.customPostPath = string;
        }

        public final boolean getServerAnonymisation() {
            return this.serverAnonymisation;
        }

        public final void setServerAnonymisation(boolean bl) {
            this.serverAnonymisation = bl;
        }

        @Nullable
        public final Map<String, String> getRequestHeaders() {
            return this.requestHeaders;
        }

        public final void setRequestHeaders(@Nullable Map<String, String> map) {
            this.requestHeaders = map;
        }

        @NotNull
        public final OkHttpNetworkConnectionBuilder method(@NotNull HttpMethod httpMethod) {
            Intrinsics.checkNotNullParameter((Object)((Object)httpMethod), (String)"httpMethod");
            this.httpMethod = httpMethod;
            return this;
        }

        @NotNull
        public final OkHttpNetworkConnectionBuilder tls(@NotNull TLSVersion version) {
            Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
            EnumSet<Enum> enumSet = EnumSet.of((Enum)version);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(version)");
            this.tlsVersions = enumSet;
            return this;
        }

        @NotNull
        public final OkHttpNetworkConnectionBuilder tls(@NotNull EnumSet<TLSVersion> versions) {
            Intrinsics.checkNotNullParameter(versions, (String)"versions");
            this.tlsVersions = versions;
            return this;
        }

        @NotNull
        public final OkHttpNetworkConnectionBuilder emitTimeout(int emitTimeout) {
            this.emitTimeout = emitTimeout;
            return this;
        }

        @NotNull
        public final OkHttpNetworkConnectionBuilder client(@Nullable OkHttpClient client) {
            this.client = client;
            return this;
        }

        @NotNull
        public final OkHttpNetworkConnectionBuilder cookieJar(@Nullable CookieJar cookieJar) {
            this.cookieJar = cookieJar;
            return this;
        }

        @NotNull
        public final OkHttpNetworkConnectionBuilder customPostPath(@Nullable String customPostPath) {
            this.customPostPath = customPostPath;
            return this;
        }

        @NotNull
        public final OkHttpNetworkConnectionBuilder serverAnonymisation(boolean serverAnonymisation) {
            this.serverAnonymisation = serverAnonymisation;
            return this;
        }

        @NotNull
        public final OkHttpNetworkConnectionBuilder requestHeaders(@Nullable Map<String, String> requestHeaders) {
            this.requestHeaders = requestHeaders;
            return this;
        }

        @NotNull
        public final OkHttpNetworkConnection build() {
            return new OkHttpNetworkConnection(this, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/snowplowanalytics/snowplow/network/OkHttpNetworkConnection$Companion;", "", "()V", "DEFAULT_USER_AGENT", "", "TRAFFIC_STATS_TAG", "", "snowplow-android-tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

