/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Cookie;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/snowplowanalytics/snowplow/network/CollectorCookie;", "", "cookie", "Lokhttp3/Cookie;", "(Lokhttp3/Cookie;)V", "serialized", "", "(Ljava/lang/String;)V", "getCookie", "()Lokhttp3/Cookie;", "cookieKey", "getCookieKey", "()Ljava/lang/String;", "isExpired", "", "()Z", "equals", "other", "hashCode", "", "serialize", "Companion", "snowplow-android-tracker_release"})
public final class CollectorCookie {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cookie cookie;

    @NotNull
    public final Cookie getCookie() {
        return this.cookie;
    }

    public CollectorCookie(@NotNull Cookie cookie) {
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        this.cookie = cookie;
    }

    public CollectorCookie(@NotNull String serialized) {
        Intrinsics.checkNotNullParameter((Object)serialized, (String)"serialized");
        JSONObject object = new JSONObject(serialized);
        Cookie.Builder builder2 = new Cookie.Builder();
        String string = object.getString("name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"`object`.getString(\"name\")");
        Cookie.Builder builder3 = builder2.name(string);
        String string2 = object.getString("value");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"`object`.getString(\"value\")");
        Cookie.Builder builder4 = builder3.value(string2).expiresAt(object.getLong("expiresAt"));
        String string3 = object.getString("domain");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"`object`.getString(\"domain\")");
        Cookie.Builder builder5 = builder4.domain(string3);
        String string4 = object.getString("path");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"`object`.getString(\"path\")");
        this.cookie = builder5.path(string4).build();
    }

    public final boolean isExpired() {
        return this.cookie.expiresAt() < System.currentTimeMillis();
    }

    @NotNull
    public final String getCookieKey() {
        return (this.cookie.secure() ? "https" : "http") + "://" + this.cookie.domain() + this.cookie.path() + '|' + this.cookie.name();
    }

    @NotNull
    public final String serialize() {
        HashMap values = new HashMap();
        ((Map)values).put("name", this.cookie.name());
        ((Map)values).put("value", this.cookie.value());
        ((Map)values).put("expiresAt", this.cookie.expiresAt());
        ((Map)values).put("domain", this.cookie.domain());
        ((Map)values).put("path", this.cookie.path());
        String string = new JSONObject((Map)values).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSONObject(values).toString()");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof CollectorCookie)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((CollectorCookie)other).cookie.name(), (Object)this.cookie.name()) && Intrinsics.areEqual((Object)((CollectorCookie)other).cookie.domain(), (Object)this.cookie.domain()) && Intrinsics.areEqual((Object)((CollectorCookie)other).cookie.path(), (Object)this.cookie.path());
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.cookie.name().hashCode();
        hash = 31 * hash + this.cookie.domain().hashCode();
        hash = 31 * hash + this.cookie.path().hashCode();
        return hash;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\t"}, d2={"Lcom/snowplowanalytics/snowplow/network/CollectorCookie$Companion;", "", "()V", "decorateAll", "", "Lcom/snowplowanalytics/snowplow/network/CollectorCookie;", "cookies", "", "Lokhttp3/Cookie;", "snowplow-android-tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<CollectorCookie> decorateAll(@NotNull Collection<Cookie> cookies) {
            Intrinsics.checkNotNullParameter(cookies, (String)"cookies");
            List collectorCookies = new ArrayList(cookies.size());
            for (Cookie cookie : cookies) {
                collectorCookies.add(new CollectorCookie(cookie));
            }
            return collectorCookies;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

