/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.event;

import com.snowplowanalytics.core.utils.Util;
import com.snowplowanalytics.snowplow.event.AbstractSelfDescribing;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\"\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/snowplowanalytics/snowplow/event/TrackerError;", "Lcom/snowplowanalytics/snowplow/event/AbstractSelfDescribing;", "source", "", "message", "throwable", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)V", "dataPayload", "", "", "getDataPayload", "()Ljava/util/Map;", "schema", "getSchema", "()Ljava/lang/String;", "truncate", "s", "maxLength", "", "Companion", "snowplow-android-tracker_release"})
public final class TrackerError
extends AbstractSelfDescribing {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String source;
    @NotNull
    private final String message;
    @Nullable
    private final Throwable throwable;
    private static final int MAX_MESSAGE_LENGTH = 2048;
    private static final int MAX_STACK_LENGTH = 8192;
    private static final int MAX_EXCEPTION_NAME_LENGTH = 1024;

    public TrackerError(@NotNull String source, @NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.source = source;
        this.message = message;
        this.throwable = throwable;
    }

    public /* synthetic */ TrackerError(String string, String string2, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            throwable = null;
        }
        this(string, string2, throwable);
    }

    @Override
    @NotNull
    public Map<String, Object> getDataPayload() {
        String msg = this.truncate(this.message, 2048);
        if (msg == null || ((CharSequence)msg).length() == 0) {
            msg = "Empty message found";
        }
        HashMap payload = new HashMap();
        ((Map)payload).put("className", this.source);
        ((Map)payload).put("message", msg);
        if (this.throwable != null) {
            String stack = this.truncate(Util.stackTraceToString(this.throwable), 8192);
            String throwableName = this.truncate(this.throwable.getClass().getName(), 1024);
            ((Map)payload).put("stackTrace", stack);
            ((Map)payload).put("exceptionName", throwableName);
        }
        return payload;
    }

    @Override
    @NotNull
    public String getSchema() {
        return "iglu:com.snowplowanalytics.snowplow/diagnostic_error/jsonschema/1-0-0";
    }

    private final String truncate(String s, int maxLength) {
        String string;
        String string2 = s;
        if (string2 != null) {
            String string3 = string2.substring(0, RangesKt.coerceAtMost((int)s.length(), (int)maxLength));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = null;
        }
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/snowplowanalytics/snowplow/event/TrackerError$Companion;", "", "()V", "MAX_EXCEPTION_NAME_LENGTH", "", "MAX_MESSAGE_LENGTH", "MAX_STACK_LENGTH", "snowplow-android-tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

