/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.event;

import com.snowplowanalytics.core.tracker.Tracker;
import com.snowplowanalytics.snowplow.event.AbstractSelfDescribing;
import com.snowplowanalytics.snowplow.event.ConsentDocument;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010\u0014\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u001a\u001a\u00020\u00002\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005J\u0014\u0010\u001e\u001a\u00020\u00002\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\"\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0016\"\u0004\b\u001c\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0016R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000eR\u0014\u0010!\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0016\u00a8\u0006'"}, d2={"Lcom/snowplowanalytics/snowplow/event/ConsentWithdrawn;", "Lcom/snowplowanalytics/snowplow/event/AbstractSelfDescribing;", "all", "", "documentId", "", "documentVersion", "(ZLjava/lang/String;Ljava/lang/String;)V", "getAll", "()Z", "consentDocuments", "", "Lcom/snowplowanalytics/snowplow/event/ConsentDocument;", "getConsentDocuments", "()Ljava/util/List;", "dataPayload", "", "", "getDataPayload", "()Ljava/util/Map;", "documentDescription", "getDocumentDescription", "()Ljava/lang/String;", "setDocumentDescription", "(Ljava/lang/String;)V", "getDocumentId", "documentName", "getDocumentName", "setDocumentName", "getDocumentVersion", "documents", "", "getDocuments", "schema", "getSchema", "beginProcessing", "", "tracker", "Lcom/snowplowanalytics/core/tracker/Tracker;", "snowplow-android-tracker_release"})
@SourceDebugExtension(value={"SMAP\nConsentWithdrawn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsentWithdrawn.kt\ncom/snowplowanalytics/snowplow/event/ConsentWithdrawn\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public final class ConsentWithdrawn
extends AbstractSelfDescribing {
    private final boolean all;
    @NotNull
    private final String documentId;
    @NotNull
    private final String documentVersion;
    @Nullable
    private String documentName;
    @Nullable
    private String documentDescription;
    @NotNull
    private final List<ConsentDocument> consentDocuments;

    public ConsentWithdrawn(boolean all, @NotNull String documentId, @NotNull String documentVersion) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)documentVersion, (String)"documentVersion");
        this.consentDocuments = new LinkedList();
        if (!(((CharSequence)documentId).length() > 0)) {
            boolean $i$a$-require-ConsentWithdrawn$32 = false;
            String $i$a$-require-ConsentWithdrawn$32 = "Document ID cannot be empty";
            throw new IllegalArgumentException($i$a$-require-ConsentWithdrawn$32.toString());
        }
        if (!(((CharSequence)documentVersion).length() > 0)) {
            boolean bl = false;
            String string = "Document version cannot be empty";
            throw new IllegalArgumentException(string.toString());
        }
        this.all = all;
        this.documentId = documentId;
        this.documentVersion = documentVersion;
    }

    public final boolean getAll() {
        return this.all;
    }

    @NotNull
    public final String getDocumentId() {
        return this.documentId;
    }

    @NotNull
    public final String getDocumentVersion() {
        return this.documentVersion;
    }

    @Nullable
    public final String getDocumentName() {
        return this.documentName;
    }

    public final void setDocumentName(@Nullable String string) {
        this.documentName = string;
    }

    @Nullable
    public final String getDocumentDescription() {
        return this.documentDescription;
    }

    public final void setDocumentDescription(@Nullable String string) {
        this.documentDescription = string;
    }

    @NotNull
    public final List<ConsentDocument> getConsentDocuments() {
        return this.consentDocuments;
    }

    @NotNull
    public final List<ConsentDocument> getDocuments() {
        List docs = new ArrayList();
        ConsentDocument doc = new ConsentDocument(this.documentId, this.documentVersion).documentDescription(this.documentDescription).documentName(this.documentName);
        docs.add(doc);
        docs.addAll((Collection)this.consentDocuments);
        return docs;
    }

    @Override
    @NotNull
    public Map<String, Object> getDataPayload() {
        HashMap payload = new HashMap();
        ((Map)payload).put("all", this.all);
        return payload;
    }

    @Override
    @NotNull
    public String getSchema() {
        return "iglu:com.snowplowanalytics.snowplow/consent_withdrawn/jsonschema/1-0-0";
    }

    @NotNull
    public final ConsentWithdrawn documentName(@Nullable String documentName) {
        this.documentName = documentName;
        return this;
    }

    @NotNull
    public final ConsentWithdrawn documentDescription(@Nullable String documentDescription) {
        this.documentDescription = documentDescription;
        return this;
    }

    @NotNull
    public final ConsentWithdrawn documents(@NotNull List<ConsentDocument> documents) {
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        this.consentDocuments.clear();
        this.consentDocuments.addAll((Collection<ConsentDocument>)documents);
        return this;
    }

    @Override
    public void beginProcessing(@NotNull Tracker tracker) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        for (ConsentDocument document : this.getDocuments()) {
            SelfDescribingJson context = new SelfDescribingJson(document.getSchema(), document.getDataPayload());
            this.customContexts.add(context);
        }
    }
}

