/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.configuration;

import android.net.Uri;
import com.snowplowanalytics.snowplow.configuration.Configuration;
import com.snowplowanalytics.snowplow.network.HttpMethod;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0001H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/snowplowanalytics/snowplow/configuration/RemoteConfiguration;", "Lcom/snowplowanalytics/snowplow/configuration/Configuration;", "endpoint", "", "method", "Lcom/snowplowanalytics/snowplow/network/HttpMethod;", "(Ljava/lang/String;Lcom/snowplowanalytics/snowplow/network/HttpMethod;)V", "getEndpoint", "()Ljava/lang/String;", "getMethod", "()Lcom/snowplowanalytics/snowplow/network/HttpMethod;", "copy", "snowplow-android-tracker_release"})
public final class RemoteConfiguration
implements Configuration {
    @NotNull
    private final String endpoint;
    @NotNull
    private final HttpMethod method;

    /*
     * Enabled aggressive block sorting
     */
    public RemoteConfiguration(@NotNull String endpoint, @NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        this.method = method;
        Uri uri = Uri.parse((String)endpoint);
        String scheme = uri.getScheme();
        if (scheme != null) {
            Object[] objectArray = new String[]{"https", "http"};
            if (CollectionsKt.listOf((Object[])objectArray).contains(scheme)) {
                this.endpoint = endpoint;
                return;
            }
        }
        this.endpoint = "https://" + endpoint;
    }

    @NotNull
    public final String getEndpoint() {
        return this.endpoint;
    }

    @NotNull
    public final HttpMethod getMethod() {
        return this.method;
    }

    @Override
    @NotNull
    public Configuration copy() {
        return new RemoteConfiguration(this.endpoint, this.method);
    }
}

