/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.configuration;

import android.net.Uri;
import com.snowplowanalytics.core.emitter.EmitterDefaults;
import com.snowplowanalytics.core.emitter.NetworkConfigurationInterface;
import com.snowplowanalytics.core.tracker.Logger;
import com.snowplowanalytics.snowplow.configuration.Configuration;
import com.snowplowanalytics.snowplow.network.HttpMethod;
import com.snowplowanalytics.snowplow.network.NetworkConnection;
import com.snowplowanalytics.snowplow.network.Protocol;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.CookieJar;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0002\b1\u0018\u0000 L2\u00020\u00012\u00020\u0002:\u0001LB\u0019\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u0007\b\u0010\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010K\u001a\u00020\u0002H\u0016J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0004J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0014J\u000e\u00102\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0016J\u001a\u0010<\u001a\u00020\u00002\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001aJ\u000e\u0010F\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u001cR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR(\u0010\u001f\u001a\u0004\u0018\u00010\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R(\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010!\"\u0004\b%\u0010#R$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R(\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010+\"\u0004\b,\u0010\nR(\u0010-\u001a\u0004\u0018\u00010\u00142\b\u0010\u001e\u001a\u0004\u0018\u00010\u00148V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R(\u00102\u001a\u0004\u0018\u00010\u00162\b\u0010\u001e\u001a\u0004\u0018\u00010\u00168V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b3\u00104\"\u0004\b5\u00106R(\u00107\u001a\u0004\u0018\u00010\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u00188V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R@\u0010<\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001a2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001a8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u001c\u0010A\u001a\u0004\u0018\u00010\u0000X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER(\u0010F\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001c8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bG\u0010H\"\u0004\bI\u0010J\u00a8\u0006M"}, d2={"Lcom/snowplowanalytics/snowplow/configuration/NetworkConfiguration;", "Lcom/snowplowanalytics/core/emitter/NetworkConfigurationInterface;", "Lcom/snowplowanalytics/snowplow/configuration/Configuration;", "endpoint", "", "method", "Lcom/snowplowanalytics/snowplow/network/HttpMethod;", "(Ljava/lang/String;Lcom/snowplowanalytics/snowplow/network/HttpMethod;)V", "networkConnection", "Lcom/snowplowanalytics/snowplow/network/NetworkConnection;", "(Lcom/snowplowanalytics/snowplow/network/NetworkConnection;)V", "()V", "jsonObject", "Lorg/json/JSONObject;", "(Lorg/json/JSONObject;)V", "_customPostPath", "_endpoint", "_method", "_networkConnection", "_okHttpClient", "Lokhttp3/OkHttpClient;", "_okHttpCookieJar", "Lokhttp3/CookieJar;", "_protocol", "Lcom/snowplowanalytics/snowplow/network/Protocol;", "_requestHeaders", "", "_timeout", "", "Ljava/lang/Integer;", "value", "customPostPath", "getCustomPostPath", "()Ljava/lang/String;", "setCustomPostPath", "(Ljava/lang/String;)V", "getEndpoint", "setEndpoint", "getMethod", "()Lcom/snowplowanalytics/snowplow/network/HttpMethod;", "setMethod", "(Lcom/snowplowanalytics/snowplow/network/HttpMethod;)V", "getNetworkConnection", "()Lcom/snowplowanalytics/snowplow/network/NetworkConnection;", "setNetworkConnection", "okHttpClient", "getOkHttpClient", "()Lokhttp3/OkHttpClient;", "setOkHttpClient", "(Lokhttp3/OkHttpClient;)V", "okHttpCookieJar", "getOkHttpCookieJar", "()Lokhttp3/CookieJar;", "setOkHttpCookieJar", "(Lokhttp3/CookieJar;)V", "protocol", "getProtocol", "()Lcom/snowplowanalytics/snowplow/network/Protocol;", "setProtocol", "(Lcom/snowplowanalytics/snowplow/network/Protocol;)V", "requestHeaders", "getRequestHeaders", "()Ljava/util/Map;", "setRequestHeaders", "(Ljava/util/Map;)V", "sourceConfig", "getSourceConfig$snowplow_android_tracker_release", "()Lcom/snowplowanalytics/snowplow/configuration/NetworkConfiguration;", "setSourceConfig$snowplow_android_tracker_release", "(Lcom/snowplowanalytics/snowplow/configuration/NetworkConfiguration;)V", "timeout", "getTimeout", "()Ljava/lang/Integer;", "setTimeout", "(Ljava/lang/Integer;)V", "copy", "Companion", "snowplow-android-tracker_release"})
public final class NetworkConfiguration
implements NetworkConfigurationInterface,
Configuration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private NetworkConfiguration sourceConfig;
    @Nullable
    private String _endpoint;
    @Nullable
    private HttpMethod _method;
    @Nullable
    private Protocol _protocol;
    @Nullable
    private NetworkConnection _networkConnection;
    @Nullable
    private String _customPostPath;
    @Nullable
    private Integer _timeout;
    @Nullable
    private OkHttpClient _okHttpClient;
    @Nullable
    private CookieJar _okHttpCookieJar;
    @Nullable
    private Map<String, String> _requestHeaders;
    private static final String TAG = NetworkConfiguration.class.getSimpleName();

    @Nullable
    public final NetworkConfiguration getSourceConfig$snowplow_android_tracker_release() {
        return this.sourceConfig;
    }

    public final void setSourceConfig$snowplow_android_tracker_release(@Nullable NetworkConfiguration networkConfiguration) {
        this.sourceConfig = networkConfiguration;
    }

    @Override
    @Nullable
    public String getEndpoint() {
        String string = this._endpoint;
        if (string == null) {
            NetworkConfiguration networkConfiguration = this.sourceConfig;
            string = networkConfiguration != null ? networkConfiguration.getEndpoint() : null;
        }
        return string;
    }

    public void setEndpoint(@Nullable String value) {
        this._endpoint = value;
    }

    @Override
    @NotNull
    public HttpMethod getMethod() {
        HttpMethod httpMethod = this._method;
        if (httpMethod == null) {
            NetworkConfiguration networkConfiguration = this.sourceConfig;
            httpMethod = networkConfiguration != null ? networkConfiguration.getMethod() : null;
            if (httpMethod == null) {
                httpMethod = EmitterDefaults.INSTANCE.getHttpMethod();
            }
        }
        return httpMethod;
    }

    public void setMethod(@NotNull HttpMethod value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this._method = value;
    }

    @Override
    @Nullable
    public Protocol getProtocol() {
        Protocol protocol = this._protocol;
        if (protocol == null) {
            NetworkConfiguration networkConfiguration = this.sourceConfig;
            protocol = networkConfiguration != null ? networkConfiguration.getProtocol() : null;
            if (protocol == null) {
                protocol = EmitterDefaults.INSTANCE.getHttpProtocol();
            }
        }
        return protocol;
    }

    public void setProtocol(@Nullable Protocol value) {
        this._protocol = value;
    }

    @Override
    @Nullable
    public NetworkConnection getNetworkConnection() {
        NetworkConnection networkConnection = this._networkConnection;
        if (networkConnection == null) {
            NetworkConfiguration networkConfiguration = this.sourceConfig;
            networkConnection = networkConfiguration != null ? networkConfiguration.getNetworkConnection() : null;
        }
        return networkConnection;
    }

    public void setNetworkConnection(@Nullable NetworkConnection value) {
        this._networkConnection = value;
    }

    @Override
    @Nullable
    public String getCustomPostPath() {
        String string = this._customPostPath;
        if (string == null) {
            NetworkConfiguration networkConfiguration = this.sourceConfig;
            string = networkConfiguration != null ? networkConfiguration.getCustomPostPath() : null;
        }
        return string;
    }

    public void setCustomPostPath(@Nullable String value) {
        this._customPostPath = value;
    }

    @Override
    @Nullable
    public Integer getTimeout() {
        Integer n = this._timeout;
        if (n == null) {
            NetworkConfiguration networkConfiguration = this.sourceConfig;
            n = networkConfiguration != null ? networkConfiguration.getTimeout() : null;
            if (n == null) {
                n = EmitterDefaults.INSTANCE.getEmitTimeout();
            }
        }
        return n;
    }

    public void setTimeout(@Nullable Integer value) {
        this._timeout = value;
    }

    @Override
    @Nullable
    public OkHttpClient getOkHttpClient() {
        Object object = this._okHttpClient;
        if (object == null) {
            NetworkConfiguration networkConfiguration = this.sourceConfig;
            object = networkConfiguration != null ? networkConfiguration.getOkHttpClient() : null;
        }
        return object;
    }

    public void setOkHttpClient(@Nullable OkHttpClient value) {
        this._okHttpClient = value;
    }

    @Override
    @Nullable
    public CookieJar getOkHttpCookieJar() {
        Object object = this._okHttpCookieJar;
        if (object == null) {
            NetworkConfiguration networkConfiguration = this.sourceConfig;
            object = networkConfiguration != null ? networkConfiguration.getOkHttpCookieJar() : null;
        }
        return object;
    }

    public void setOkHttpCookieJar(@Nullable CookieJar value) {
        this._okHttpCookieJar = value;
    }

    @Override
    @Nullable
    public Map<String, String> getRequestHeaders() {
        Map<String, String> map = this._requestHeaders;
        if (map == null) {
            NetworkConfiguration networkConfiguration = this.sourceConfig;
            map = networkConfiguration != null ? networkConfiguration.getRequestHeaders() : null;
        }
        return map;
    }

    public void setRequestHeaders(@Nullable Map<String, String> value) {
        this._requestHeaders = value;
    }

    @JvmOverloads
    public NetworkConfiguration(@NotNull String endpoint, @NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        this.setMethod(method);
        Uri uri = Uri.parse((String)endpoint);
        String scheme = uri.getScheme();
        if (scheme == null) {
            this.setProtocol(Protocol.HTTPS);
            this.setEndpoint("https://" + endpoint);
            return;
        }
        String string = scheme;
        if (Intrinsics.areEqual((Object)string, (Object)"https")) {
            this.setProtocol(Protocol.HTTPS);
            this.setEndpoint(endpoint);
        } else if (Intrinsics.areEqual((Object)string, (Object)"http")) {
            this.setProtocol(Protocol.HTTP);
            this.setEndpoint(endpoint);
        } else {
            this.setProtocol(Protocol.HTTPS);
            this.setEndpoint("https://" + endpoint);
        }
    }

    public /* synthetic */ NetworkConfiguration(String string, HttpMethod httpMethod, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            httpMethod = HttpMethod.POST;
        }
        this(string, httpMethod);
    }

    public NetworkConfiguration(@NotNull NetworkConnection networkConnection) {
        Intrinsics.checkNotNullParameter((Object)networkConnection, (String)"networkConnection");
        this.setNetworkConnection(networkConnection);
    }

    public NetworkConfiguration() {
    }

    @NotNull
    public final NetworkConfiguration customPostPath(@NotNull String customPostPath) {
        Intrinsics.checkNotNullParameter((Object)customPostPath, (String)"customPostPath");
        this.setCustomPostPath(customPostPath);
        return this;
    }

    @NotNull
    public final NetworkConfiguration timeout(int timeout) {
        this.setTimeout(timeout);
        return this;
    }

    @NotNull
    public final NetworkConfiguration okHttpClient(@NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        this.setOkHttpClient(okHttpClient);
        return this;
    }

    @NotNull
    public final NetworkConfiguration okHttpCookieJar(@NotNull CookieJar okHttpCookieJar) {
        Intrinsics.checkNotNullParameter((Object)okHttpCookieJar, (String)"okHttpCookieJar");
        this.setOkHttpCookieJar(okHttpCookieJar);
        return this;
    }

    @NotNull
    public final NetworkConfiguration requestHeaders(@NotNull Map<String, String> requestHeaders) {
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        this.setRequestHeaders(requestHeaders);
        return this;
    }

    @Override
    @NotNull
    public Configuration copy() {
        NetworkConfiguration networkConfiguration;
        if (this.getNetworkConnection() != null) {
            NetworkConnection networkConnection = this.getNetworkConnection();
            Intrinsics.checkNotNull((Object)networkConnection);
            networkConfiguration = new NetworkConfiguration(networkConnection);
        } else {
            String scheme = this.getProtocol() == Protocol.HTTPS ? "https://" : "http://";
            networkConfiguration = new NetworkConfiguration(scheme + this.getEndpoint(), this.getMethod());
        }
        NetworkConfiguration copy = networkConfiguration;
        copy.setCustomPostPath(this.getCustomPostPath());
        copy.setTimeout(this.getTimeout());
        return copy;
    }

    public NetworkConfiguration(@NotNull JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        this("", null, 2, null);
        try {
            this.setEndpoint(jsonObject.getString("endpoint"));
            String methodStr = jsonObject.getString("method");
            Intrinsics.checkNotNullExpressionValue((Object)methodStr, (String)"methodStr");
            String string = methodStr;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
            this.setMethod(HttpMethod.valueOf(string2));
        }
        catch (Exception e) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.e(string, "Unable to get remote configuration", new Object[0]);
        }
    }

    @JvmOverloads
    public NetworkConfiguration(@NotNull String endpoint) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        this(endpoint, null, 2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/snowplowanalytics/snowplow/configuration/NetworkConfiguration$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "snowplow-android-tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

