/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.Looper;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import android.util.Pair;
import com.snowplowanalytics.core.tracker.Logger;
import com.snowplowanalytics.snowplow.configuration.TrackerConfiguration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0016\u0018\u0000 -2\u00020\u0001:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001e\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u001a\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0016\u001a\u00020\u0017J\u0014\u0010$\u001a\u0004\u0018\u00010\b2\b\u0010%\u001a\u0004\u0018\u00010#H\u0016J\u0012\u0010&\u001a\u00020\b2\b\u0010%\u001a\u0004\u0018\u00010#H\u0016J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0017\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0016\u0010\r\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006\u00a8\u0006."}, d2={"Lcom/snowplowanalytics/core/utils/DeviceInfoMonitor;", "", "()V", "availableStorage", "", "getAvailableStorage", "()J", "deviceModel", "", "getDeviceModel", "()Ljava/lang/String;", "deviceVendor", "getDeviceVendor", "language", "getLanguage", "osType", "getOsType", "osVersion", "getOsVersion", "totalStorage", "getTotalStorage", "getAndroidIdfa", "context", "Landroid/content/Context;", "getAppSetIdAndScope", "Landroid/util/Pair;", "getBatteryStateAndLevel", "", "getCarrier", "getIsPortrait", "", "(Landroid/content/Context;)Ljava/lang/Boolean;", "getMemoryInfo", "Landroid/app/ActivityManager$MemoryInfo;", "getNetworkInfo", "Landroid/net/NetworkInfo;", "getNetworkTechnology", "networkInfo", "getNetworkType", "getPhysicalMemory", "getResolution", "getScale", "", "(Landroid/content/Context;)Ljava/lang/Float;", "getSystemAvailableMemory", "Companion", "snowplow-android-tracker_release"})
@SourceDebugExtension(value={"SMAP\nDeviceInfoMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceInfoMonitor.kt\ncom/snowplowanalytics/core/utils/DeviceInfoMonitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,338:1\n1#2:339\n*E\n"})
public class DeviceInfoMonitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final String TAG = DeviceInfoMonitor.class.getSimpleName();

    @NotNull
    public String getOsType() {
        return "android";
    }

    @NotNull
    public String getOsVersion() {
        String string = Build.VERSION.RELEASE;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RELEASE");
        return string;
    }

    @NotNull
    public String getDeviceModel() {
        String string = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MODEL");
        return string;
    }

    @NotNull
    public String getDeviceVendor() {
        String string = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MANUFACTURER");
        return string;
    }

    @Nullable
    public String getCarrier(@NotNull Context context) {
        String carrierName;
        TelephonyManager telephonyManager;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        TelephonyManager telephonyManager2 = telephonyManager = object instanceof TelephonyManager ? (TelephonyManager)object : null;
        String string = carrierName = telephonyManager2 != null ? telephonyManager2.getNetworkOperatorName() : null;
        if (!Intrinsics.areEqual((Object)carrierName, (Object)"")) {
            return carrierName;
        }
        return null;
    }

    @Nullable
    public String getAndroidIdfa(@NotNull Context context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            String string2;
            Boolean limitedTracking;
            Object object;
            Object it;
            Object advertisingInfoObject;
            Object[] objectArray = new Class[]{Context.class};
            Class[] classArray = objectArray;
            objectArray = new Object[]{context};
            Object object2 = advertisingInfoObject = DeviceInfoMonitor.Companion.invokeStaticMethod("com.google.android.gms.ads.identifier.AdvertisingIdClient", "getAdvertisingIdInfo", classArray, objectArray);
            if (object2 != null) {
                it = object2;
                boolean bl = false;
                object = DeviceInfoMonitor.Companion.invokeInstanceMethod(it, "isLimitAdTrackingEnabled", null, new Object[0]);
            } else {
                object = null;
            }
            Object object3 = object;
            Boolean bl = limitedTracking = object3 instanceof Boolean ? (Boolean)object3 : null;
            if (Intrinsics.areEqual((Object)limitedTracking, (Object)true)) {
                string2 = "";
            } else {
                Object object4;
                Object object5 = advertisingInfoObject;
                if (object5 != null) {
                    it = object5;
                    boolean bl2 = false;
                    object4 = DeviceInfoMonitor.Companion.invokeInstanceMethod(it, "getId", null, new Object[0]);
                } else {
                    object4 = null;
                }
                object3 = object4;
                string2 = object3 instanceof String ? (String)object3 : null;
            }
            string = string2;
        }
        catch (Exception e) {
            String string3 = TrackerConfiguration.Companion.getTAG();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TrackerConfiguration.TAG");
            Object[] objectArray = new Object[]{e.toString()};
            Logger.e(string3, "Exception getting the Advertising ID: %s", objectArray);
            string = null;
        }
        return string;
    }

    @NotNull
    public String getNetworkType(@Nullable NetworkInfo networkInfo) {
        String networkType = "offline";
        if (networkInfo != null) {
            String maybeNetworkType;
            String string = networkInfo.getTypeName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"networkInfo.typeName");
            String string2 = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
            string2 = maybeNetworkType = string3;
            if (Intrinsics.areEqual((Object)string2, (Object)"mobile") ? true : Intrinsics.areEqual((Object)string2, (Object)"wifi")) {
                networkType = maybeNetworkType;
            }
        }
        return networkType;
    }

    @Nullable
    public String getNetworkTechnology(@Nullable NetworkInfo networkInfo) {
        String networkType;
        String networkTech = null;
        if (networkInfo != null && StringsKt.equals((String)(networkType = networkInfo.getTypeName()), (String)"MOBILE", (boolean)true)) {
            networkTech = networkInfo.getSubtypeName();
        }
        return networkTech;
    }

    @Nullable
    public final NetworkInfo getNetworkInfo(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        ConnectivityManager cm = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
        NetworkInfo ni = null;
        try {
            NetworkInfo maybeNi;
            ConnectivityManager connectivityManager = cm;
            Object object2 = maybeNi = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
            if (maybeNi != null && maybeNi.isConnected()) {
                ni = maybeNi;
            }
        }
        catch (SecurityException e) {
            String string = TrackerConfiguration.Companion.getTAG();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TrackerConfiguration.TAG");
            Object[] objectArray = new Object[]{e.toString()};
            Logger.e(string, "Security exception getting NetworkInfo: %s", objectArray);
        }
        return ni;
    }

    public long getPhysicalMemory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActivityManager.MemoryInfo mi = this.getMemoryInfo(context);
        return mi.totalMem;
    }

    public long getSystemAvailableMemory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActivityManager.MemoryInfo mi = this.getMemoryInfo(context);
        return mi.availMem;
    }

    @Nullable
    public Pair<String, Integer> getBatteryStateAndLevel(@NotNull Context context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, ifilter);
        if (intent == null) {
            return null;
        }
        Intent batteryIntent = intent;
        int status = batteryIntent.getIntExtra("status", -1);
        int level = batteryIntent.getIntExtra("level", -1);
        int scale = batteryIntent.getIntExtra("scale", -1);
        if (status == -1 || level == -1 || scale == -1) {
            return null;
        }
        String batteryState = null;
        switch (status) {
            case 1: {
                string = null;
                break;
            }
            case 5: {
                string = "full";
                break;
            }
            case 2: {
                string = "charging";
                break;
            }
            default: {
                string = "unplugged";
            }
        }
        batteryState = string;
        int batteryLevel = (int)((float)(level * 100) / (float)scale);
        return new Pair((Object)batteryState, (Object)batteryLevel);
    }

    public long getAvailableStorage() {
        StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
        return statFs.getFreeBytes();
    }

    public long getTotalStorage() {
        StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
        return statFs.getTotalBytes();
    }

    @Nullable
    public Boolean getIsPortrait(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getResources().getConfiguration().orientation == 1;
    }

    @Nullable
    public String getResolution(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int width = context.getResources().getDisplayMetrics().widthPixels;
        int height = context.getResources().getDisplayMetrics().heightPixels;
        return "" + width + 'x' + height;
    }

    @Nullable
    public Float getScale(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Float.valueOf(context.getResources().getDisplayMetrics().density);
    }

    @Nullable
    public String getLanguage() {
        String string;
        try {
            string = Locale.getDefault().getISO3Language();
        }
        catch (MissingResourceException e) {
            string = null;
        }
        return string;
    }

    @Nullable
    public Pair<String, String> getAppSetIdAndScope(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            return null;
        }
        try {
            Object[] objectArray = new Class[]{Context.class};
            Class[] classArray = objectArray;
            objectArray = new Object[]{context};
            Object object = DeviceInfoMonitor.Companion.invokeStaticMethod("com.google.android.gms.appset.AppSet", "getClient", classArray, objectArray);
            if (object == null) {
                return null;
            }
            Object client = object;
            Object object2 = DeviceInfoMonitor.Companion.invokeInstanceMethod(client, "getAppSetIdInfo", null, new Object[0]);
            if (object2 == null) {
                return null;
            }
            Object task = object2;
            Object[] objectArray2 = new Class[1];
            Intrinsics.checkNotNullExpressionValue(Class.forName("com.google.android.gms.tasks.Task"), (String)"forName(\"com.google.android.gms.tasks.Task\")");
            Class[] classArray2 = objectArray2;
            objectArray2 = new Object[]{task};
            Object object3 = DeviceInfoMonitor.Companion.invokeStaticMethod("com.google.android.gms.tasks.Tasks", "await", classArray2, objectArray2);
            if (object3 == null) {
                return null;
            }
            Object appSetInfo = object3;
            Object object4 = DeviceInfoMonitor.Companion.invokeInstanceMethod(appSetInfo, "getId", null, new Object[0]);
            if (object4 == null) {
                return null;
            }
            Object id = object4;
            Object object5 = DeviceInfoMonitor.Companion.invokeInstanceMethod(appSetInfo, "getScope", null, new Object[0]);
            if (object5 == null) {
                return null;
            }
            Object scope = object5;
            return new Pair((Object)((String)id), (Object)((Integer)scope == 1 ? "app" : "developer"));
        }
        catch (ClassNotFoundException e) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.d(string, "AppSetID error: Google Play Services not found", new Object[0]);
        }
        catch (InvocationTargetException e) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.d(string, "AppSetID error: Google Play Services not available", new Object[0]);
        }
        catch (Exception e) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.d(string, "AppSetID error: couldn't connect to Google Play Services", new Object[0]);
        }
        return null;
    }

    private final ActivityManager.MemoryInfo getMemoryInfo(Context context) {
        ActivityManager.MemoryInfo mi;
        block0: {
            Object object = context.getSystemService("activity");
            ActivityManager activityManager = object instanceof ActivityManager ? (ActivityManager)object : null;
            mi = new ActivityManager.MemoryInfo();
            ActivityManager activityManager2 = activityManager;
            if (activityManager2 == null) break block0;
            activityManager2.getMemoryInfo(mi);
        }
        return mi;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JG\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00042\u0012\u0010\t\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0018\u00010\n2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\n\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\rJU\u0010\u000e\u001a\u0004\u0018\u00010\u00012\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\b\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0012\u0010\t\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0018\u00010\n2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\n\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0010JE\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\n\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0013R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/snowplowanalytics/core/utils/DeviceInfoMonitor$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "invokeInstanceMethod", "instance", "methodName", "cArgs", "", "Ljava/lang/Class;", "args", "(Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Class;[Ljava/lang/Object;)Ljava/lang/Object;", "invokeMethod", "classObject", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/Class;[Ljava/lang/Object;)Ljava/lang/Object;", "invokeStaticMethod", "className", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Class;[Ljava/lang/Object;)Ljava/lang/Object;", "snowplow-android-tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Object invokeInstanceMethod(Object instance, String methodName, Class<?>[] cArgs, Object ... args) throws Exception {
            Class<?> classObject = instance.getClass();
            return this.invokeMethod(classObject, methodName, instance, cArgs, Arrays.copyOf(args, args.length));
        }

        private final Object invokeStaticMethod(String className, String methodName, Class<?>[] cArgs, Object ... args) throws Exception {
            Class<?> classObject = Class.forName(className);
            Intrinsics.checkNotNullExpressionValue(classObject, (String)"classObject");
            return this.invokeMethod(classObject, methodName, null, cArgs, Arrays.copyOf(args, args.length));
        }

        private final Object invokeMethod(Class<?> classObject, String methodName, Object instance, Class<?>[] cArgs, Object ... args) throws Exception {
            Method methodObject = cArgs == null ? classObject.getMethod(methodName, new Class[0]) : classObject.getMethod(methodName, Arrays.copyOf(cArgs, cArgs.length));
            return methodObject.invoke(instance, Arrays.copyOf(args, args.length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

