/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.tracker;

import android.webkit.JavascriptInterface;
import com.snowplowanalytics.core.tracker.Logger;
import com.snowplowanalytics.core.utils.JsonUtils;
import com.snowplowanalytics.snowplow.Snowplow;
import com.snowplowanalytics.snowplow.controller.TrackerController;
import com.snowplowanalytics.snowplow.event.AbstractEvent;
import com.snowplowanalytics.snowplow.event.PageView;
import com.snowplowanalytics.snowplow.event.ScreenView;
import com.snowplowanalytics.snowplow.event.SelfDescribing;
import com.snowplowanalytics.snowplow.event.Structured;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0019\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u0000 )2\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J/\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u000eJC\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u0010\u0013Ji\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u0010\u001cJ7\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u0010 JU\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\b\u0010$\u001a\u0004\u0018\u00010\u00072\b\u0010%\u001a\u0004\u0018\u00010\u00072\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u0010(\u00a8\u0006*"}, d2={"Lcom/snowplowanalytics/core/tracker/TrackerWebViewInterface;", "", "()V", "parseContext", "", "Lcom/snowplowanalytics/snowplow/payload/SelfDescribingJson;", "context", "", "trackEvent", "", "event", "Lcom/snowplowanalytics/snowplow/event/AbstractEvent;", "trackers", "", "(Lcom/snowplowanalytics/snowplow/event/AbstractEvent;Ljava/lang/String;[Ljava/lang/String;)V", "trackPageView", "pageUrl", "pageTitle", "referrer", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "trackScreenView", "name", "id", "type", "previousName", "previousId", "previousType", "transitionType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "trackSelfDescribingEvent", "schema", "data", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "trackStructEvent", "category", "action", "label", "property", "value", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Double;Ljava/lang/String;[Ljava/lang/String;)V", "Companion", "snowplow-android-tracker_release"})
public final class TrackerWebViewInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TAG = "SnowplowWebInterface";

    @JavascriptInterface
    public final void trackSelfDescribingEvent(@NotNull String schema, @NotNull String data, @Nullable String context, @Nullable String[] trackers) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        JSONObject json = new JSONObject(data);
        Map<String, Object> payload = JsonUtils.jsonToMap(json);
        SelfDescribing event = new SelfDescribing(schema, payload);
        this.trackEvent(event, context, trackers);
    }

    @JavascriptInterface
    public final void trackStructEvent(@NotNull String category, @NotNull String action, @Nullable String label, @Nullable String property, @Nullable Double value, @Nullable String context, @Nullable String[] trackers) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Structured event = new Structured(category, action);
        event.setLabel(label);
        event.setProperty(property);
        event.setValue(value);
        this.trackEvent(event, context, trackers);
    }

    @JavascriptInterface
    public final void trackScreenView(@NotNull String name, @NotNull String id, @Nullable String type, @Nullable String previousName, @Nullable String previousId, @Nullable String previousType, @Nullable String transitionType, @Nullable String context, @Nullable String[] trackers) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ScreenView event = new ScreenView(name, UUID.fromString(id)).type(type).previousId(previousId).previousName(previousName).previousType(previousType).transitionType(transitionType);
        this.trackEvent(event, context, trackers);
    }

    @JavascriptInterface
    public final void trackPageView(@NotNull String pageUrl, @Nullable String pageTitle, @Nullable String referrer, @Nullable String context, @Nullable String[] trackers) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)pageUrl, (String)"pageUrl");
        PageView event = new PageView(pageUrl).pageTitle(pageTitle).referrer(referrer);
        this.trackEvent(event, context, trackers);
    }

    private final void trackEvent(AbstractEvent event, String context, String[] trackers) throws JSONException {
        List<SelfDescribingJson> contextEntities;
        if (context != null && !((Collection)(contextEntities = this.parseContext(context))).isEmpty()) {
            event.entities(contextEntities);
        }
        if (trackers == null || trackers.length == 0) {
            TrackerController tracker = Snowplow.getDefaultTracker();
            if (tracker != null) {
                tracker.track(event);
            } else {
                Logger.e(TAG, "Tracker not initialized.", new Object[0]);
            }
        } else {
            Iterator iterator = ArrayIteratorKt.iterator((Object[])trackers);
            while (iterator.hasNext()) {
                String namespace = (String)iterator.next();
                TrackerController tracker = Snowplow.getTracker(namespace);
                if (tracker != null) {
                    tracker.track(event);
                    continue;
                }
                String string = "Tracker with namespace %s not found.";
                Object[] objectArray = new Object[]{namespace};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                Logger.e(TAG, string2, new Object[0]);
            }
        }
    }

    private final List<SelfDescribingJson> parseContext(String context) throws JSONException {
        List entities = new ArrayList();
        JSONArray contextJson = new JSONArray(context);
        int n = contextJson.length();
        for (int i = 0; i < n; ++i) {
            JSONObject itemJson = contextJson.getJSONObject(i);
            Intrinsics.checkNotNullExpressionValue((Object)itemJson, (String)"itemJson");
            Map<String, Object> item = JsonUtils.jsonToMap(itemJson);
            Object object = item.get("schema");
            String schema = object instanceof String ? (String)object : null;
            Object data = item.get("data");
            if (schema == null || data == null) continue;
            entities.add(new SelfDescribingJson(schema, data));
        }
        return entities;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/snowplowanalytics/core/tracker/TrackerWebViewInterface$Companion;", "", "()V", "TAG", "", "snowplow-android-tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

