/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.tracker;

import com.snowplowanalytics.core.statemachine.StateMachineEvent;
import com.snowplowanalytics.core.statemachine.TrackerState;
import com.snowplowanalytics.core.statemachine.TrackerStateSnapshot;
import com.snowplowanalytics.snowplow.event.AbstractPrimitive;
import com.snowplowanalytics.snowplow.event.AbstractSelfDescribing;
import com.snowplowanalytics.snowplow.event.Event;
import com.snowplowanalytics.snowplow.event.TrackerError;
import com.snowplowanalytics.snowplow.payload.Payload;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\tJ\u001c\u0010>\u001a\u00020\u00152\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020#0?H\u0016J\u0016\u0010@\u001a\u00020<2\u0006\u0010!\u001a\u00020A2\u0006\u0010B\u001a\u00020\u0015J\u0016\u0010C\u001a\u00020<2\u0006\u0010D\u001a\u00020A2\u0006\u0010B\u001a\u00020\u0015J\u0018\u0010E\u001a\u00020<2\u0006\u0010D\u001a\u00020A2\u0006\u0010B\u001a\u00020\u0015H\u0002R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0016\"\u0004\b\u001a\u0010\u0018R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R&\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020#0\"X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001e\"\u0004\b*\u0010 R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001e\u00105\u001a\u0004\u0018\u000100X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010:\u001a\u0004\b6\u00107\"\u0004\b8\u00109\u00a8\u0006F"}, d2={"Lcom/snowplowanalytics/core/tracker/TrackerEvent;", "Lcom/snowplowanalytics/core/statemachine/StateMachineEvent;", "event", "Lcom/snowplowanalytics/snowplow/event/Event;", "state", "Lcom/snowplowanalytics/core/statemachine/TrackerStateSnapshot;", "(Lcom/snowplowanalytics/snowplow/event/Event;Lcom/snowplowanalytics/core/statemachine/TrackerStateSnapshot;)V", "entities", "", "Lcom/snowplowanalytics/snowplow/payload/SelfDescribingJson;", "getEntities", "()Ljava/util/List;", "setEntities", "(Ljava/util/List;)V", "eventId", "Ljava/util/UUID;", "getEventId", "()Ljava/util/UUID;", "setEventId", "(Ljava/util/UUID;)V", "isPrimitive", "", "()Z", "setPrimitive", "(Z)V", "isService", "setService", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "payload", "", "", "getPayload", "()Ljava/util/Map;", "setPayload", "(Ljava/util/Map;)V", "schema", "getSchema", "setSchema", "getState", "()Lcom/snowplowanalytics/core/statemachine/TrackerStateSnapshot;", "setState", "(Lcom/snowplowanalytics/core/statemachine/TrackerStateSnapshot;)V", "timestamp", "", "getTimestamp", "()J", "setTimestamp", "(J)V", "trueTimestamp", "getTrueTimestamp", "()Ljava/lang/Long;", "setTrueTimestamp", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "addContextEntity", "", "entity", "addPayloadValues", "", "wrapEntitiesToPayload", "Lcom/snowplowanalytics/snowplow/payload/Payload;", "base64Encoded", "wrapPropertiesToPayload", "toPayload", "wrapSelfDescribingToPayload", "snowplow-android-tracker_release"})
public final class TrackerEvent
implements StateMachineEvent {
    @Nullable
    private String schema;
    @Nullable
    private String name;
    public Map<String, Object> payload;
    public TrackerStateSnapshot state;
    public List<SelfDescribingJson> entities;
    @NotNull
    private UUID eventId;
    private long timestamp;
    @Nullable
    private Long trueTimestamp;
    private boolean isPrimitive;
    private boolean isService;

    @JvmOverloads
    public TrackerEvent(@NotNull Event event, @Nullable TrackerStateSnapshot state) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID()");
        this.eventId = uUID;
        this.timestamp = System.currentTimeMillis();
        this.setEntities(CollectionsKt.toMutableList((Collection)event.getEntities()));
        this.trueTimestamp = event.getTrueTimestamp();
        this.setPayload((Map<String, Object>)new HashMap<String, Object>(event.getDataPayload()));
        if (state != null) {
            this.setState(state);
        } else {
            this.setState(new TrackerState());
        }
        this.isService = event instanceof TrackerError;
        if (event instanceof AbstractPrimitive) {
            this.setName(((AbstractPrimitive)event).getName());
            this.isPrimitive = true;
        } else {
            AbstractSelfDescribing abstractSelfDescribing = event instanceof AbstractSelfDescribing ? (AbstractSelfDescribing)event : null;
            this.setSchema(abstractSelfDescribing != null ? abstractSelfDescribing.getSchema() : null);
            this.isPrimitive = false;
        }
    }

    public /* synthetic */ TrackerEvent(Event event, TrackerStateSnapshot trackerStateSnapshot, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            trackerStateSnapshot = null;
        }
        this(event, trackerStateSnapshot);
    }

    @Override
    @Nullable
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(@Nullable String string) {
        this.schema = string;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String string) {
        this.name = string;
    }

    @Override
    @NotNull
    public Map<String, Object> getPayload() {
        Map<String, Object> map = this.payload;
        if (map != null) {
            return map;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"payload");
        return null;
    }

    public void setPayload(@NotNull Map<String, Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.payload = map;
    }

    @Override
    @NotNull
    public TrackerStateSnapshot getState() {
        TrackerStateSnapshot trackerStateSnapshot = this.state;
        if (trackerStateSnapshot != null) {
            return trackerStateSnapshot;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"state");
        return null;
    }

    public void setState(@NotNull TrackerStateSnapshot trackerStateSnapshot) {
        Intrinsics.checkNotNullParameter((Object)trackerStateSnapshot, (String)"<set-?>");
        this.state = trackerStateSnapshot;
    }

    @Override
    @NotNull
    public List<SelfDescribingJson> getEntities() {
        List<SelfDescribingJson> list = this.entities;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"entities");
        return null;
    }

    public void setEntities(@NotNull List<SelfDescribingJson> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.entities = list;
    }

    @NotNull
    public final UUID getEventId() {
        return this.eventId;
    }

    public final void setEventId(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.eventId = uUID;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final void setTimestamp(long l) {
        this.timestamp = l;
    }

    @Nullable
    public final Long getTrueTimestamp() {
        return this.trueTimestamp;
    }

    public final void setTrueTimestamp(@Nullable Long l) {
        this.trueTimestamp = l;
    }

    public final boolean isPrimitive() {
        return this.isPrimitive;
    }

    public final void setPrimitive(boolean bl) {
        this.isPrimitive = bl;
    }

    public final boolean isService() {
        return this.isService;
    }

    public final void setService(boolean bl) {
        this.isService = bl;
    }

    @Override
    public boolean addPayloadValues(@NotNull Map<String, ? extends Object> payload) {
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        boolean result = true;
        for (Map.Entry<String, ? extends Object> entry : payload.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (this.getPayload().get(key) == null) {
                this.getPayload().put(key, value);
                continue;
            }
            result = false;
        }
        return result;
    }

    public final void addContextEntity(@NotNull SelfDescribingJson entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.getEntities().add(entity);
    }

    public final void wrapEntitiesToPayload(@NotNull Payload payload, boolean base64Encoded) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        if (this.getEntities().isEmpty()) {
            return;
        }
        List data = new LinkedList();
        for (SelfDescribingJson entity : this.getEntities()) {
            data.add(entity.getMap());
        }
        SelfDescribingJson finalContext = new SelfDescribingJson("iglu:com.snowplowanalytics.snowplow/contexts/jsonschema/1-0-1", data);
        payload.addMap(finalContext.getMap(), base64Encoded, "cx", "co");
    }

    public final void wrapPropertiesToPayload(@NotNull Payload toPayload, boolean base64Encoded) {
        Intrinsics.checkNotNullParameter((Object)toPayload, (String)"toPayload");
        if (this.isPrimitive) {
            toPayload.addMap(this.getPayload());
        } else {
            this.wrapSelfDescribingToPayload(toPayload, base64Encoded);
        }
    }

    private final void wrapSelfDescribingToPayload(Payload toPayload, boolean base64Encoded) {
        String string = this.getSchema();
        if (string == null) {
            return;
        }
        String schema = string;
        SelfDescribingJson data = new SelfDescribingJson(schema, this.getPayload());
        HashMap unstructuredEventPayload = new HashMap();
        ((Map)unstructuredEventPayload).put("schema", "iglu:com.snowplowanalytics.snowplow/unstruct_event/jsonschema/1-0-0");
        ((Map)unstructuredEventPayload).put("data", data.getMap());
        toPayload.addMap(unstructuredEventPayload, base64Encoded, "ue_px", "ue_pr");
    }

    @JvmOverloads
    public TrackerEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this(event, null, 2, null);
    }
}

