/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.tracker;

import android.content.Context;
import com.snowplowanalytics.core.emitter.Emitter;
import com.snowplowanalytics.core.emitter.Executor;
import com.snowplowanalytics.core.gdpr.Gdpr;
import com.snowplowanalytics.core.session.ProcessObserver;
import com.snowplowanalytics.core.session.Session;
import com.snowplowanalytics.core.statemachine.DeepLinkStateMachine;
import com.snowplowanalytics.core.statemachine.LifecycleStateMachine;
import com.snowplowanalytics.core.statemachine.State;
import com.snowplowanalytics.core.statemachine.StateMachineEvent;
import com.snowplowanalytics.core.statemachine.StateMachineInterface;
import com.snowplowanalytics.core.statemachine.StateManager;
import com.snowplowanalytics.core.statemachine.TrackerStateSnapshot;
import com.snowplowanalytics.core.tracker.ActivityLifecycleHandler;
import com.snowplowanalytics.core.tracker.ApplicationInstallEvent;
import com.snowplowanalytics.core.tracker.ExceptionHandler;
import com.snowplowanalytics.core.tracker.Logger;
import com.snowplowanalytics.core.tracker.PlatformContext;
import com.snowplowanalytics.core.tracker.ScreenState;
import com.snowplowanalytics.core.tracker.ScreenStateMachine;
import com.snowplowanalytics.core.tracker.Subject;
import com.snowplowanalytics.core.tracker.TrackerDefaults;
import com.snowplowanalytics.core.tracker.TrackerEvent;
import com.snowplowanalytics.core.utils.NotificationCenter;
import com.snowplowanalytics.core.utils.Util;
import com.snowplowanalytics.snowplow.configuration.PlatformContextProperty;
import com.snowplowanalytics.snowplow.entity.DeepLink;
import com.snowplowanalytics.snowplow.event.Background;
import com.snowplowanalytics.snowplow.event.Event;
import com.snowplowanalytics.snowplow.event.Foreground;
import com.snowplowanalytics.snowplow.event.TrackerError;
import com.snowplowanalytics.snowplow.payload.Payload;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import com.snowplowanalytics.snowplow.payload.TrackerPayload;
import com.snowplowanalytics.snowplow.tracker.DevicePlatform;
import com.snowplowanalytics.snowplow.tracker.LogLevel;
import com.snowplowanalytics.snowplow.tracker.LoggerDelegate;
import com.snowplowanalytics.snowplow.util.Basis;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00e0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00cd\u00012\u00020\u0001:\u0002\u00cd\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u00a4\u0001\u001a\u00020\u000e2\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0002J\u001d\u0010\u00a7\u0001\u001a\u00020\u000e2\b\u0010\u00a8\u0001\u001a\u00030\u00a9\u00012\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0002J\u0011\u0010\u00aa\u0001\u001a\u00020\u000e2\b\u0010\u00ab\u0001\u001a\u00030\u00ac\u0001J\u0013\u0010\u00ad\u0001\u001a\u00020\u000e2\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0002J\u0013\u0010\u00ae\u0001\u001a\u00020\u000e2\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0002J\u0007\u0010\u00af\u0001\u001a\u00020\u000eJ\u0007\u0010\u00b0\u0001\u001a\u00020\u000eJ2\u0010\u00b1\u0001\u001a\u00020\u000e2\b\u0010\u00b2\u0001\u001a\u00030\u00b3\u00012\t\u0010\u00b4\u0001\u001a\u0004\u0018\u00010\u00052\t\u0010\u00b5\u0001\u001a\u0004\u0018\u00010\u00052\t\u0010\u00b6\u0001\u001a\u0004\u0018\u00010\u0005J\n\u0010\u00b7\u0001\u001a\u0005\u0018\u00010\u00b8\u0001J\t\u0010\u00b9\u0001\u001a\u00020\u000eH\u0002J\t\u0010\u00ba\u0001\u001a\u00020\u000eH\u0002J\t\u0010\u00bb\u0001\u001a\u00020\u000eH\u0002J\t\u0010\u00bc\u0001\u001a\u00020\u000eH\u0002J\u0007\u0010\u00bd\u0001\u001a\u00020\u000eJ\u0007\u0010\u00be\u0001\u001a\u00020\u000eJ\u0016\u0010\u00bf\u0001\u001a\u0005\u0018\u00010\u00a9\u00012\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0002J\t\u0010\u00c0\u0001\u001a\u00020\u000eH\u0002J\u0010\u0010\u00c1\u0001\u001a\u00020\u000e2\u0007\u0010\u00c2\u0001\u001a\u00020\u0005J\u0007\u0010\u00c3\u0001\u001a\u00020\u000eJ\u0007\u0010\u00c4\u0001\u001a\u00020\u000eJ\u0013\u0010\u00c5\u0001\u001a\u00020\u000e2\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0002J\u0007\u0010\u00c6\u0001\u001a\u00020\u000eJ\u0014\u0010\u00c7\u0001\u001a\u0005\u0018\u00010\u00c8\u00012\b\u0010\u00a5\u0001\u001a\u00030\u00c9\u0001J\t\u0010\u00ca\u0001\u001a\u00020\u000eH\u0002J\u001d\u0010\u00cb\u0001\u001a\u00020\u000e2\b\u0010\u00a8\u0001\u001a\u00030\u00a9\u00012\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0002J\u0013\u0010\u00cc\u0001\u001a\u00020\u000e2\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR$\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R$\u0010%\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001a\"\u0004\b'\u0010\u001cR\u000e\u0010(\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001aR$\u0010+\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u001a\"\u0004\b-\u0010\u001cR$\u0010/\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u001a\"\u0004\b1\u0010\u001cR$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R$\u00106\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u001a\"\u0004\b8\u0010\u001cR$\u00109\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010!\"\u0004\b;\u0010#R\u001c\u0010<\u001a\u0004\u0018\u00010=X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR$\u0010C\u001a\u00020\u00172\u0006\u0010B\u001a\u00020\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\u001a\"\u0004\bE\u0010\u001cR$\u0010F\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010\u001a\"\u0004\bH\u0010\u001cR$\u0010I\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010\u001a\"\u0004\bK\u0010\u001cR$\u0010N\u001a\u00020M2\u0006\u0010L\u001a\u00020M@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR(\u0010U\u001a\u0004\u0018\u00010T2\b\u0010S\u001a\u0004\u0018\u00010T@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010W\"\u0004\bX\u0010YR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010\u0013R\u001a\u0010[\u001a\u00020\\X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010^\"\u0004\b_\u0010`R$\u0010b\u001a\u00020\u00172\u0006\u0010a\u001a\u00020\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u0010\u001a\"\u0004\bd\u0010\u001cR\u000e\u0010e\u001a\u00020fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010g\u001a\u00020hX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010i\u001a\u00020hX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010j\u001a\u00020hX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010k\u001a\u00020hX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010l\u001a\u00020hX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010m\u001a\u00020\u00172\u0006\u0010m\u001a\u00020\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bn\u0010\u001a\"\u0004\bo\u0010\u001cR$\u0010p\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bq\u0010\u001a\"\u0004\br\u0010\u001cR\u001c\u0010s\u001a\u0004\u0018\u00010tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bu\u0010v\"\u0004\bw\u0010xR8\u0010|\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010{0z2\u000e\u0010y\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010{0z@FX\u0086\u000e\u00a2\u0006\u0012\n\u0003\u0010\u0081\u0001\u001a\u0004\b}\u0010~\"\u0005\b\u007f\u0010\u0080\u0001R(\u0010\u0082\u0001\u001a\u00020\u00172\u0007\u0010\u0082\u0001\u001a\u00020\u0017@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0083\u0001\u0010\u001a\"\u0005\b\u0084\u0001\u0010\u001cR\u0010\u0010\u0085\u0001\u001a\u00030\u0086\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0089\u0001\u0010\u008a\u0001\"\u0006\b\u008b\u0001\u0010\u008c\u0001R,\u0010\u008d\u0001\u001a\u00030\u008e\u00012\b\u0010\u008d\u0001\u001a\u00030\u008e\u0001@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u008f\u0001\u0010\u0090\u0001\"\u0006\b\u0091\u0001\u0010\u0092\u0001R,\u0010\u0095\u0001\u001a\u00030\u0094\u00012\b\u0010\u0093\u0001\u001a\u00030\u0094\u0001@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0096\u0001\u0010\u0097\u0001\"\u0006\b\u0098\u0001\u0010\u0099\u0001R!\u0010\u009b\u0001\u001a\u00020\u00052\u0007\u0010\u009a\u0001\u001a\u00020\u0005@BX\u0082\u000e\u00a2\u0006\t\n\u0000\"\u0005\b\u009c\u0001\u0010\u0015R,\u0010\u009e\u0001\u001a\u0004\u0018\u00010\u00052\t\u0010\u009d\u0001\u001a\u0004\u0018\u00010\u0005@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u009f\u0001\u0010\u0013\"\u0005\b\u00a0\u0001\u0010\u0015R(\u0010\u00a1\u0001\u001a\u00020\u00172\u0007\u0010\u00a1\u0001\u001a\u00020\u0017@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00a2\u0001\u0010\u001a\"\u0005\b\u00a3\u0001\u0010\u001c\u00a8\u0006\u00ce\u0001"}, d2={"Lcom/snowplowanalytics/core/tracker/Tracker;", "", "emitter", "Lcom/snowplowanalytics/core/emitter/Emitter;", "namespace", "", "appId", "platformContextProperties", "", "Lcom/snowplowanalytics/snowplow/configuration/PlatformContextProperty;", "context", "Landroid/content/Context;", "builder", "Lkotlin/Function1;", "", "(Lcom/snowplowanalytics/core/emitter/Emitter;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Landroid/content/Context;Lkotlin/jvm/functions/Function1;)V", "_dataCollection", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getAppId", "()Ljava/lang/String;", "setAppId", "(Ljava/lang/String;)V", "application", "", "applicationContext", "getApplicationContext", "()Z", "setApplicationContext", "(Z)V", "timeout", "", "backgroundTimeout", "getBackgroundTimeout", "()J", "setBackgroundTimeout", "(J)V", "base64", "base64Encoded", "getBase64Encoded", "setBase64Encoded", "builderFinished", "dataCollection", "getDataCollection", "deepLinkContext", "getDeepLinkContext", "setDeepLinkContext", "willTrack", "diagnosticAutotracking", "getDiagnosticAutotracking", "setDiagnosticAutotracking", "getEmitter", "()Lcom/snowplowanalytics/core/emitter/Emitter;", "setEmitter", "(Lcom/snowplowanalytics/core/emitter/Emitter;)V", "exceptionAutotracking", "getExceptionAutotracking", "setExceptionAutotracking", "foregroundTimeout", "getForegroundTimeout", "setForegroundTimeout", "gdprContext", "Lcom/snowplowanalytics/core/gdpr/Gdpr;", "getGdprContext", "()Lcom/snowplowanalytics/core/gdpr/Gdpr;", "setGdprContext", "(Lcom/snowplowanalytics/core/gdpr/Gdpr;)V", "geolocation", "geoLocationContext", "getGeoLocationContext", "setGeoLocationContext", "installAutotracking", "getInstallAutotracking", "setInstallAutotracking", "lifecycleAutotracking", "getLifecycleAutotracking", "setLifecycleAutotracking", "level", "Lcom/snowplowanalytics/snowplow/tracker/LogLevel;", "logLevel", "getLogLevel", "()Lcom/snowplowanalytics/snowplow/tracker/LogLevel;", "setLogLevel", "(Lcom/snowplowanalytics/snowplow/tracker/LogLevel;)V", "delegate", "Lcom/snowplowanalytics/snowplow/tracker/LoggerDelegate;", "loggerDelegate", "getLoggerDelegate", "()Lcom/snowplowanalytics/snowplow/tracker/LoggerDelegate;", "setLoggerDelegate", "(Lcom/snowplowanalytics/snowplow/tracker/LoggerDelegate;)V", "getNamespace", "platform", "Lcom/snowplowanalytics/snowplow/tracker/DevicePlatform;", "getPlatform", "()Lcom/snowplowanalytics/snowplow/tracker/DevicePlatform;", "setPlatform", "(Lcom/snowplowanalytics/snowplow/tracker/DevicePlatform;)V", "mobile", "platformContextEnabled", "getPlatformContextEnabled", "setPlatformContextEnabled", "platformContextManager", "Lcom/snowplowanalytics/core/tracker/PlatformContext;", "receiveCrashReportingNotification", "Lcom/snowplowanalytics/core/utils/NotificationCenter$FunctionalObserver;", "receiveDiagnosticNotification", "receiveInstallNotification", "receiveLifecycleNotification", "receiveScreenViewNotification", "screenContext", "getScreenContext", "setScreenContext", "screenViewAutotracking", "getScreenViewAutotracking", "setScreenViewAutotracking", "session", "Lcom/snowplowanalytics/core/session/Session;", "getSession", "()Lcom/snowplowanalytics/core/session/Session;", "setSession", "(Lcom/snowplowanalytics/core/session/Session;)V", "callbacksArray", "", "Ljava/lang/Runnable;", "sessionCallbacks", "getSessionCallbacks", "()[Ljava/lang/Runnable;", "setSessionCallbacks", "([Ljava/lang/Runnable;)V", "[Ljava/lang/Runnable;", "sessionContext", "getSessionContext", "setSessionContext", "stateManager", "Lcom/snowplowanalytics/core/statemachine/StateManager;", "subject", "Lcom/snowplowanalytics/core/tracker/Subject;", "getSubject", "()Lcom/snowplowanalytics/core/tracker/Subject;", "setSubject", "(Lcom/snowplowanalytics/core/tracker/Subject;)V", "threadCount", "", "getThreadCount", "()I", "setThreadCount", "(I)V", "timeunit", "Ljava/util/concurrent/TimeUnit;", "timeUnit", "getTimeUnit", "()Ljava/util/concurrent/TimeUnit;", "setTimeUnit", "(Ljava/util/concurrent/TimeUnit;)V", "version", "trackerVersion", "setTrackerVersion", "suffix", "trackerVersionSuffix", "getTrackerVersionSuffix", "setTrackerVersionSuffix", "userAnonymisation", "getUserAnonymisation", "setUserAnonymisation", "addBasicContexts", "event", "Lcom/snowplowanalytics/core/tracker/TrackerEvent;", "addBasicPropertiesToPayload", "payload", "Lcom/snowplowanalytics/snowplow/payload/Payload;", "addOrReplaceStateMachine", "stateMachine", "Lcom/snowplowanalytics/core/statemachine/StateMachineInterface;", "addStateMachineEntities", "addStateMachinePayloadValues", "close", "disableGdprContext", "enableGdprContext", "basisForProcessing", "Lcom/snowplowanalytics/snowplow/util/Basis;", "documentId", "documentVersion", "documentDescription", "getScreenState", "Lcom/snowplowanalytics/core/tracker/ScreenState;", "initializeCrashReporting", "initializeInstallTracking", "initializeLifecycleTracking", "initializeScreenviewTracking", "pauseEventTracking", "pauseSessionChecking", "payloadWithEvent", "registerNotificationHandlers", "removeStateMachine", "identifier", "resumeEventTracking", "resumeSessionChecking", "setApplicationInstallEventTimestamp", "startNewSession", "track", "Ljava/util/UUID;", "Lcom/snowplowanalytics/snowplow/event/Event;", "unregisterNotificationHandlers", "workaroundForCampaignAttributionEnrichment", "workaroundForIncoherentSessionContext", "Companion", "snowplow-android-tracker_release"})
@SourceDebugExtension(value={"SMAP\nTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Tracker.kt\ncom/snowplowanalytics/core/tracker/Tracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,741:1\n1#2:742\n*E\n"})
public final class Tracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String namespace;
    @NotNull
    private String appId;
    private boolean builderFinished;
    @NotNull
    private final Context context;
    @NotNull
    private final StateManager stateManager;
    @NotNull
    private String trackerVersion;
    @NotNull
    private final AtomicBoolean _dataCollection;
    @NotNull
    private final PlatformContext platformContextManager;
    @NotNull
    private Emitter emitter;
    @Nullable
    private Subject subject;
    @Nullable
    private Session session;
    private boolean base64Encoded;
    @NotNull
    private DevicePlatform platform;
    @NotNull
    private LogLevel logLevel;
    private long foregroundTimeout;
    private long backgroundTimeout;
    private int threadCount;
    @NotNull
    private TimeUnit timeUnit;
    private boolean exceptionAutotracking;
    private boolean diagnosticAutotracking;
    private boolean lifecycleAutotracking;
    private boolean installAutotracking;
    private boolean screenViewAutotracking;
    private boolean userAnonymisation;
    @Nullable
    private String trackerVersionSuffix;
    @NotNull
    private Runnable[] sessionCallbacks;
    private boolean sessionContext;
    private boolean geoLocationContext;
    private boolean platformContextEnabled;
    private boolean applicationContext;
    private boolean deepLinkContext;
    private boolean screenContext;
    @Nullable
    private Gdpr gdprContext;
    @Nullable
    private LoggerDelegate loggerDelegate;
    @NotNull
    private final NotificationCenter.FunctionalObserver receiveLifecycleNotification;
    @NotNull
    private final NotificationCenter.FunctionalObserver receiveScreenViewNotification;
    @NotNull
    private final NotificationCenter.FunctionalObserver receiveInstallNotification;
    @NotNull
    private final NotificationCenter.FunctionalObserver receiveDiagnosticNotification;
    @NotNull
    private final NotificationCenter.FunctionalObserver receiveCrashReportingNotification;
    private static final String TAG = Tracker.class.getSimpleName();

    public Tracker(@NotNull Emitter emitter, @NotNull String namespace, @NotNull String appId, @Nullable List<? extends PlatformContextProperty> platformContextProperties, @NotNull Context context, @Nullable Function1<? super Tracker, Unit> builder2) {
        Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.namespace = namespace;
        this.appId = appId;
        this.stateManager = new StateManager();
        this.trackerVersion = "andr-5.6.0";
        this._dataCollection = new AtomicBoolean(true);
        this.platformContextManager = new PlatformContext(platformContextProperties, context);
        this.emitter = emitter;
        this.base64Encoded = TrackerDefaults.INSTANCE.getBase64Encoded();
        this.platform = TrackerDefaults.INSTANCE.getDevicePlatform();
        this.logLevel = TrackerDefaults.INSTANCE.getLogLevel();
        this.foregroundTimeout = TrackerDefaults.INSTANCE.getForegroundTimeout();
        this.backgroundTimeout = TrackerDefaults.INSTANCE.getBackgroundTimeout();
        this.threadCount = TrackerDefaults.INSTANCE.getThreadCount();
        this.timeUnit = TrackerDefaults.INSTANCE.getTimeUnit();
        this.exceptionAutotracking = TrackerDefaults.INSTANCE.getExceptionAutotracking();
        this.diagnosticAutotracking = TrackerDefaults.INSTANCE.getDiagnosticAutotracking();
        this.lifecycleAutotracking = TrackerDefaults.INSTANCE.getLifecycleAutotracking();
        this.installAutotracking = TrackerDefaults.INSTANCE.getInstallAutotracking();
        this.screenViewAutotracking = TrackerDefaults.INSTANCE.getScreenViewAutotracking();
        this.userAnonymisation = TrackerDefaults.INSTANCE.getUserAnonymisation();
        Runnable[] runnableArray = new Runnable[]{null, null, null, null};
        this.sessionCallbacks = runnableArray;
        this.sessionContext = TrackerDefaults.INSTANCE.getSessionContext();
        this.geoLocationContext = TrackerDefaults.INSTANCE.getGeoLocationContext();
        this.platformContextEnabled = TrackerDefaults.INSTANCE.getPlatformContext();
        this.applicationContext = TrackerDefaults.INSTANCE.getApplicationContext();
        this.receiveLifecycleNotification = new NotificationCenter.FunctionalObserver(this){
            final /* synthetic */ Tracker this$0;
            {
                this.this$0 = $receiver;
            }

            public void apply(@NotNull Map<String, ? extends Object> data) {
                Intrinsics.checkNotNullParameter(data, (String)"data");
                Session session = this.this$0.getSession();
                if (session == null || !this.this$0.getLifecycleAutotracking()) {
                    return;
                }
                Object object = data.get("isForeground");
                Boolean bl = object instanceof Boolean ? (Boolean)object : null;
                if (bl == null) {
                    return;
                }
                boolean isForeground = bl;
                if (session.isBackground() == !isForeground) {
                    return;
                }
                if (isForeground) {
                    this.this$0.track(new Foreground().foregroundIndex(session.getForegroundIndex() + 1));
                } else {
                    this.this$0.track(new Background().backgroundIndex(session.getBackgroundIndex() + 1));
                }
                session.setBackground(!isForeground);
            }
        };
        this.receiveScreenViewNotification = new NotificationCenter.FunctionalObserver(this){
            final /* synthetic */ Tracker this$0;
            {
                this.this$0 = $receiver;
            }

            public void apply(@NotNull Map<String, ? extends Object> data) {
                block1: {
                    Event event;
                    Intrinsics.checkNotNullParameter(data, (String)"data");
                    if (!this.this$0.getScreenViewAutotracking()) break block1;
                    Object object = data.get("event");
                    Event event2 = event = object instanceof Event ? (Event)object : null;
                    if (event2 != null) {
                        object = event2;
                        Tracker tracker = this.this$0;
                        Object it = object;
                        boolean bl = false;
                        tracker.track((Event)it);
                    }
                }
            }
        };
        this.receiveInstallNotification = new NotificationCenter.FunctionalObserver(this){
            final /* synthetic */ Tracker this$0;
            {
                this.this$0 = $receiver;
            }

            public void apply(@NotNull Map<String, ? extends Object> data) {
                block1: {
                    Event event;
                    Intrinsics.checkNotNullParameter(data, (String)"data");
                    if (!this.this$0.getInstallAutotracking()) break block1;
                    Object object = data.get("event");
                    Event event2 = event = object instanceof Event ? (Event)object : null;
                    if (event2 != null) {
                        object = event2;
                        Tracker tracker = this.this$0;
                        Object it = object;
                        boolean bl = false;
                        tracker.track((Event)it);
                    }
                }
            }
        };
        this.receiveDiagnosticNotification = new NotificationCenter.FunctionalObserver(this){
            final /* synthetic */ Tracker this$0;
            {
                this.this$0 = $receiver;
            }

            public void apply(@NotNull Map<String, ? extends Object> data) {
                block1: {
                    Event event;
                    Intrinsics.checkNotNullParameter(data, (String)"data");
                    if (!this.this$0.getDiagnosticAutotracking()) break block1;
                    Object object = data.get("event");
                    Event event2 = event = object instanceof Event ? (Event)object : null;
                    if (event2 != null) {
                        object = event2;
                        Tracker tracker = this.this$0;
                        Object it = object;
                        boolean bl = false;
                        tracker.track((Event)it);
                    }
                }
            }
        };
        this.receiveCrashReportingNotification = new NotificationCenter.FunctionalObserver(this){
            final /* synthetic */ Tracker this$0;
            {
                this.this$0 = $receiver;
            }

            public void apply(@NotNull Map<String, ? extends Object> data) {
                block1: {
                    Event event;
                    Intrinsics.checkNotNullParameter(data, (String)"data");
                    if (!this.this$0.getExceptionAutotracking()) break block1;
                    Object object = data.get("event");
                    Event event2 = event = object instanceof Event ? (Event)object : null;
                    if (event2 != null) {
                        object = event2;
                        Tracker tracker = this.this$0;
                        Object it = object;
                        boolean bl = false;
                        tracker.track((Event)it);
                    }
                }
            }
        };
        this.context = context;
        Function1<? super Tracker, Unit> function1 = builder2;
        if (function1 != null) {
            Function1<? super Tracker, Unit> it = function1;
            boolean bl = false;
            it.invoke((Object)this);
        }
        emitter.flush();
        emitter.setNamespace(this.namespace);
        String string = this.trackerVersionSuffix;
        if (string != null) {
            String it = string;
            boolean bl = false;
            Regex regex = new Regex("[^A-Za-z0-9.-]");
            CharSequence charSequence = it;
            String string2 = "";
            String suffix = regex.replace(charSequence, string2);
            if (((CharSequence)suffix).length() > 0) {
                this.setTrackerVersion(this.trackerVersion + ' ' + suffix);
            }
        }
        if (this.diagnosticAutotracking && this.logLevel == LogLevel.OFF) {
            this.setLogLevel(LogLevel.ERROR);
        }
        Logger.updateLogLevel(this.logLevel);
        if (this.sessionContext) {
            Runnable[] runnableArray2 = new Runnable[]{null, null, null, null};
            Runnable[] callbacks = runnableArray2;
            if (this.sessionCallbacks.length == 4) {
                callbacks = this.sessionCallbacks;
            }
            this.session = Session.Companion.getInstance(context, this.foregroundTimeout, this.backgroundTimeout, this.timeUnit, this.namespace, callbacks);
        }
        this.registerNotificationHandlers();
        this.initializeCrashReporting();
        this.initializeInstallTracking();
        this.initializeScreenviewTracking();
        this.initializeLifecycleTracking();
        this.resumeSessionChecking();
        this.builderFinished = true;
        String string3 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TAG");
        Logger.v(string3, "Tracker created successfully.", new Object[0]);
    }

    public /* synthetic */ Tracker(Emitter emitter, String string, String string2, List list, Context context, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            function1 = null;
        }
        this(emitter, string, string2, list, context, (Function1<? super Tracker, Unit>)function1);
    }

    @NotNull
    public final String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public final String getAppId() {
        return this.appId;
    }

    public final void setAppId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.appId = string;
    }

    @Nullable
    public final ScreenState getScreenState() {
        State state = this.stateManager.getTrackerState().getState("ScreenContext");
        if (state == null) {
            return new ScreenState();
        }
        State state2 = state;
        return state2 instanceof ScreenState ? (ScreenState)state2 : null;
    }

    private final void setTrackerVersion(String version) {
        if (!this.builderFinished) {
            this.trackerVersion = version;
        }
    }

    public final boolean getDataCollection() {
        return this._dataCollection.get();
    }

    @NotNull
    public final Emitter getEmitter() {
        return this.emitter;
    }

    public final void setEmitter(@NotNull Emitter emitter) {
        Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
        this.emitter.shutdown();
        this.emitter = emitter;
    }

    @Nullable
    public final Subject getSubject() {
        return this.subject;
    }

    public final void setSubject(@Nullable Subject subject) {
        this.subject = subject;
    }

    @Nullable
    public final Session getSession() {
        return this.session;
    }

    public final void setSession(@Nullable Session session) {
        this.session = session;
    }

    public final boolean getBase64Encoded() {
        return this.base64Encoded;
    }

    public final void setBase64Encoded(boolean base64) {
        if (!this.builderFinished) {
            this.base64Encoded = base64;
        }
    }

    @NotNull
    public final DevicePlatform getPlatform() {
        return this.platform;
    }

    public final void setPlatform(@NotNull DevicePlatform devicePlatform) {
        Intrinsics.checkNotNullParameter((Object)((Object)devicePlatform), (String)"<set-?>");
        this.platform = devicePlatform;
    }

    @NotNull
    public final LogLevel getLogLevel() {
        return this.logLevel;
    }

    public final void setLogLevel(@NotNull LogLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        if (!this.builderFinished) {
            this.logLevel = level;
        }
    }

    public final long getForegroundTimeout() {
        return this.foregroundTimeout;
    }

    public final void setForegroundTimeout(long timeout) {
        if (!this.builderFinished) {
            this.foregroundTimeout = timeout;
        }
    }

    public final long getBackgroundTimeout() {
        return this.backgroundTimeout;
    }

    public final void setBackgroundTimeout(long timeout) {
        if (!this.builderFinished) {
            this.backgroundTimeout = timeout;
        }
    }

    public final int getThreadCount() {
        return this.threadCount;
    }

    public final void setThreadCount(int threadCount) {
        if (!this.builderFinished) {
            this.threadCount = Math.max(threadCount, 2);
        }
    }

    @NotNull
    public final TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public final void setTimeUnit(@NotNull TimeUnit timeunit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeunit), (String)"timeunit");
        if (!this.builderFinished) {
            this.timeUnit = timeunit;
        }
    }

    public final boolean getExceptionAutotracking() {
        return this.exceptionAutotracking;
    }

    public final void setExceptionAutotracking(boolean willTrack) {
        if (!this.builderFinished) {
            this.exceptionAutotracking = willTrack;
        }
    }

    public final boolean getDiagnosticAutotracking() {
        return this.diagnosticAutotracking;
    }

    public final void setDiagnosticAutotracking(boolean willTrack) {
        if (!this.builderFinished) {
            this.diagnosticAutotracking = willTrack;
        }
    }

    public final boolean getLifecycleAutotracking() {
        return this.lifecycleAutotracking;
    }

    public final void setLifecycleAutotracking(boolean willTrack) {
        if (!this.builderFinished) {
            this.lifecycleAutotracking = willTrack;
        }
    }

    public final boolean getInstallAutotracking() {
        return this.installAutotracking;
    }

    public final void setInstallAutotracking(boolean willTrack) {
        if (!this.builderFinished) {
            this.installAutotracking = willTrack;
        }
    }

    public final boolean getScreenViewAutotracking() {
        return this.screenViewAutotracking;
    }

    public final void setScreenViewAutotracking(boolean willTrack) {
        if (!this.builderFinished) {
            this.screenViewAutotracking = willTrack;
        }
    }

    public final boolean getUserAnonymisation() {
        return this.userAnonymisation;
    }

    public final void setUserAnonymisation(boolean userAnonymisation) {
        block2: {
            block1: {
                if (this.builderFinished) break block1;
                this.userAnonymisation = userAnonymisation;
                break block2;
            }
            if (this.userAnonymisation == userAnonymisation || !this.builderFinished) break block2;
            this.userAnonymisation = userAnonymisation;
            Session session = this.session;
            if (session != null) {
                session.startNewSession();
            }
        }
    }

    @Nullable
    public final String getTrackerVersionSuffix() {
        return this.trackerVersionSuffix;
    }

    public final void setTrackerVersionSuffix(@Nullable String suffix) {
        if (!this.builderFinished) {
            this.trackerVersionSuffix = suffix;
        }
    }

    @NotNull
    public final Runnable[] getSessionCallbacks() {
        return this.sessionCallbacks;
    }

    public final void setSessionCallbacks(@NotNull Runnable[] callbacksArray) {
        Intrinsics.checkNotNullParameter((Object)callbacksArray, (String)"callbacksArray");
        if (!this.builderFinished) {
            this.sessionCallbacks = callbacksArray;
        }
    }

    public final boolean getSessionContext() {
        return this.sessionContext;
    }

    public final synchronized void setSessionContext(boolean sessionContext) {
        this.sessionContext = sessionContext;
        if (this.session != null && !sessionContext) {
            this.pauseSessionChecking();
            this.session = null;
        } else if (this.session == null && sessionContext) {
            Runnable[] runnableArray = new Runnable[]{null, null, null, null};
            Runnable[] callbacks = runnableArray;
            if (this.sessionCallbacks.length == 4) {
                callbacks = this.sessionCallbacks;
            }
            this.session = Session.Companion.getInstance(this.context, this.foregroundTimeout, this.backgroundTimeout, this.timeUnit, this.namespace, callbacks);
        }
    }

    public final boolean getGeoLocationContext() {
        return this.geoLocationContext;
    }

    public final void setGeoLocationContext(boolean geolocation) {
        if (!this.builderFinished) {
            this.geoLocationContext = geolocation;
        }
    }

    public final boolean getPlatformContextEnabled() {
        return this.platformContextEnabled;
    }

    public final void setPlatformContextEnabled(boolean mobile) {
        if (!this.builderFinished) {
            this.platformContextEnabled = mobile;
        }
    }

    public final boolean getApplicationContext() {
        return this.applicationContext;
    }

    public final void setApplicationContext(boolean application) {
        if (!this.builderFinished) {
            this.applicationContext = application;
        }
    }

    public final boolean getDeepLinkContext() {
        return this.deepLinkContext;
    }

    public final void setDeepLinkContext(boolean deepLinkContext) {
        this.deepLinkContext = deepLinkContext;
        if (deepLinkContext) {
            this.addOrReplaceStateMachine(new DeepLinkStateMachine());
        } else {
            this.removeStateMachine(DeepLinkStateMachine.Companion.getID());
        }
    }

    public final boolean getScreenContext() {
        return this.screenContext;
    }

    public final void setScreenContext(boolean screenContext) {
        this.screenContext = screenContext;
        if (screenContext) {
            this.addOrReplaceStateMachine(new ScreenStateMachine());
        } else {
            this.removeStateMachine(ScreenStateMachine.Companion.getID());
        }
    }

    @Nullable
    public final Gdpr getGdprContext() {
        return this.gdprContext;
    }

    public final void setGdprContext(@Nullable Gdpr gdpr) {
        this.gdprContext = gdpr;
    }

    @Nullable
    public final LoggerDelegate getLoggerDelegate() {
        return this.loggerDelegate;
    }

    public final void setLoggerDelegate(@Nullable LoggerDelegate delegate) {
        if (!this.builderFinished) {
            this.loggerDelegate = delegate;
            Logger.INSTANCE.setDelegate(delegate);
        }
    }

    private final void registerNotificationHandlers() {
        NotificationCenter.addObserver("SnowplowTrackerDiagnostic", this.receiveDiagnosticNotification);
        NotificationCenter.addObserver("SnowplowScreenView", this.receiveScreenViewNotification);
        NotificationCenter.addObserver("SnowplowLifecycleTracking", this.receiveLifecycleNotification);
        NotificationCenter.addObserver("SnowplowInstallTracking", this.receiveInstallNotification);
        NotificationCenter.addObserver("SnowplowCrashReporting", this.receiveCrashReportingNotification);
    }

    private final void unregisterNotificationHandlers() {
        NotificationCenter.removeObserver(this.receiveDiagnosticNotification);
        NotificationCenter.removeObserver(this.receiveScreenViewNotification);
        NotificationCenter.removeObserver(this.receiveLifecycleNotification);
        NotificationCenter.removeObserver(this.receiveInstallNotification);
        NotificationCenter.removeObserver(this.receiveCrashReportingNotification);
    }

    private final void initializeInstallTracking() {
        if (this.installAutotracking) {
            ApplicationInstallEvent.Companion.trackIfFirstLaunch(this.context);
        }
    }

    private final void initializeScreenviewTracking() {
        if (this.screenViewAutotracking) {
            ActivityLifecycleHandler.Companion.getInstance(this.context);
        }
    }

    private final void initializeLifecycleTracking() {
        if (this.lifecycleAutotracking) {
            ProcessObserver.Companion.initialize(this.context);
            this.addOrReplaceStateMachine(new LifecycleStateMachine());
        }
    }

    private final void initializeCrashReporting() {
        if (this.exceptionAutotracking && !(Thread.getDefaultUncaughtExceptionHandler() instanceof ExceptionHandler)) {
            Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
        }
    }

    public final void close() {
        this.unregisterNotificationHandlers();
        this.pauseSessionChecking();
        this.emitter.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final UUID track(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.getDataCollection()) {
            return null;
        }
        event.beginProcessing(this);
        TrackerStateSnapshot stateSnapshot = null;
        Ref.ObjectRef trackerEvent = new Ref.ObjectRef();
        Tracker tracker = this;
        synchronized (tracker) {
            boolean bl = false;
            stateSnapshot = this.stateManager.trackerStateForProcessedEvent(event);
            trackerEvent.element = new TrackerEvent(event, stateSnapshot);
            this.workaroundForIncoherentSessionContext((TrackerEvent)trackerEvent.element);
            Unit unit = Unit.INSTANCE;
        }
        boolean reportsOnDiagnostic = !(event instanceof TrackerError);
        Executor.execute(reportsOnDiagnostic, TAG, () -> Tracker.track$lambda$5(this, trackerEvent, event));
        return ((TrackerEvent)trackerEvent.element).getEventId();
    }

    private final Payload payloadWithEvent(TrackerEvent event) {
        TrackerPayload payload = new TrackerPayload();
        this.setApplicationInstallEventTimestamp(event);
        this.addBasicPropertiesToPayload(payload, event);
        this.addStateMachinePayloadValues(event);
        this.addBasicContexts(event);
        this.addStateMachineEntities(event);
        event.wrapPropertiesToPayload(payload, this.base64Encoded);
        event.wrapEntitiesToPayload(payload, this.base64Encoded);
        if (!this.stateManager.filter(event)) {
            return null;
        }
        if (!event.isPrimitive()) {
            this.workaroundForCampaignAttributionEnrichment(payload, event);
        }
        return payload;
    }

    private final void setApplicationInstallEventTimestamp(TrackerEvent event) {
        if (event.getSchema() != null && Intrinsics.areEqual((Object)event.getSchema(), (Object)"iglu:com.snowplowanalytics.mobile/application_install/jsonschema/1-0-0")) {
            Long l = event.getTrueTimestamp();
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                event.setTimestamp(it);
            }
            event.setTrueTimestamp(null);
        }
    }

    private final void addStateMachinePayloadValues(TrackerEvent event) {
        this.stateManager.addPayloadValuesToEvent(event);
    }

    private final void addBasicPropertiesToPayload(Payload payload, TrackerEvent event) {
        payload.add("eid", event.getEventId().toString());
        payload.add("dtm", String.valueOf(event.getTimestamp()));
        Long l = event.getTrueTimestamp();
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            payload.add("ttm", String.valueOf(it));
        }
        payload.add("aid", this.appId);
        payload.add("tna", this.namespace);
        payload.add("tv", this.trackerVersion);
        Subject subject = this.subject;
        if (subject != null) {
            Subject it = subject;
            boolean bl = false;
            payload.addMap((Map<String, ? extends Object>)new HashMap<String, String>(it.getSubject(this.userAnonymisation)));
        }
        payload.add("p", this.platform.getValue());
        if (event.isPrimitive()) {
            payload.add("e", event.getName());
        } else {
            payload.add("e", "ue");
        }
    }

    private final void workaroundForCampaignAttributionEnrichment(Payload payload, TrackerEvent event) {
        String url = null;
        String referrer = null;
        if (Intrinsics.areEqual((Object)event.getSchema(), (Object)"iglu:com.snowplowanalytics.mobile/deep_link_received/jsonschema/1-0-0")) {
            Object object = event.getPayload().get("url");
            url = object instanceof String ? (String)object : null;
            object = event.getPayload().get("referrer");
            referrer = object instanceof String ? (String)object : null;
        } else if (Intrinsics.areEqual((Object)event.getSchema(), (Object)"iglu:com.snowplowanalytics.mobile/screen_view/jsonschema/1-0-0")) {
            for (SelfDescribingJson entity : event.getEntities()) {
                if (!(entity instanceof DeepLink)) continue;
                url = ((DeepLink)entity).getUrl();
                referrer = ((DeepLink)entity).getReferrer();
                break;
            }
        }
        if (url != null) {
            payload.add("url", Util.INSTANCE.truncateUrlScheme(url));
        }
        if (referrer != null) {
            payload.add("refr", Util.INSTANCE.truncateUrlScheme(referrer));
        }
    }

    private final void workaroundForIncoherentSessionContext(TrackerEvent event) {
        block2: {
            SelfDescribingJson sessionContextJson;
            if (event.isService() || !this.sessionContext) break block2;
            String string = event.getEventId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.eventId.toString()");
            String eventId = string;
            long eventTimestamp = event.getTimestamp();
            Session sessionManager = this.session;
            if (sessionManager == null) {
                String string2 = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
                Object[] objectArray = new Object[]{eventId};
                Logger.track(string2, "Session not ready or method getHasLoadedFromFile returned false with eventId: %s", objectArray);
                return;
            }
            SelfDescribingJson selfDescribingJson = sessionContextJson = sessionManager.getSessionContext(eventId, eventTimestamp, this.userAnonymisation);
            if (selfDescribingJson != null) {
                SelfDescribingJson it = selfDescribingJson;
                boolean bl = false;
                event.getEntities().add(it);
            }
        }
    }

    private final void addBasicContexts(TrackerEvent event) {
        block7: {
            Object it;
            if (this.applicationContext) {
                SelfDescribingJson selfDescribingJson = Util.getApplicationContext(this.context);
                if (selfDescribingJson != null) {
                    it = selfDescribingJson;
                    boolean bl = false;
                    event.addContextEntity((SelfDescribingJson)it);
                }
            }
            if (this.platformContextEnabled) {
                SelfDescribingJson selfDescribingJson = this.platformContextManager.getMobileContext(this.userAnonymisation);
                if (selfDescribingJson != null) {
                    it = selfDescribingJson;
                    boolean bl = false;
                    event.addContextEntity((SelfDescribingJson)it);
                }
            }
            if (event.isService()) {
                return;
            }
            if (this.geoLocationContext) {
                SelfDescribingJson selfDescribingJson = Util.getGeoLocationContext(this.context);
                if (selfDescribingJson != null) {
                    it = selfDescribingJson;
                    boolean bl = false;
                    event.addContextEntity((SelfDescribingJson)it);
                }
            }
            Gdpr gdpr = this.gdprContext;
            if (gdpr == null) break block7;
            it = gdpr;
            boolean bl = false;
            event.addContextEntity(((Gdpr)it).getContext());
        }
    }

    private final void addStateMachineEntities(TrackerEvent event) {
        List<SelfDescribingJson> stateManagerEntities = this.stateManager.entitiesForProcessedEvent(event);
        for (SelfDescribingJson entity : stateManagerEntities) {
            event.addContextEntity(entity);
        }
    }

    public final void resumeEventTracking() {
        if (this._dataCollection.compareAndSet(false, true)) {
            this.resumeSessionChecking();
            this.emitter.flush();
        }
    }

    public final void pauseEventTracking() {
        if (this._dataCollection.compareAndSet(true, false)) {
            this.pauseSessionChecking();
            this.emitter.shutdown();
        }
    }

    public final void resumeSessionChecking() {
        Session trackerSession = this.session;
        if (trackerSession != null) {
            trackerSession.setIsSuspended(false);
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.d(string, "Session checking has been resumed.", new Object[0]);
        }
    }

    public final void pauseSessionChecking() {
        Session trackerSession = this.session;
        if (trackerSession != null) {
            trackerSession.setIsSuspended(true);
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.d(string, "Session checking has been paused.", new Object[0]);
        }
    }

    public final void startNewSession() {
        block0: {
            Session session = this.session;
            if (session == null) break block0;
            session.startNewSession();
        }
    }

    public final void enableGdprContext(@NotNull Basis basisForProcessing, @Nullable String documentId, @Nullable String documentVersion, @Nullable String documentDescription) {
        Intrinsics.checkNotNullParameter((Object)((Object)basisForProcessing), (String)"basisForProcessing");
        this.gdprContext = new Gdpr(basisForProcessing, documentId, documentVersion, documentDescription);
    }

    public final synchronized void disableGdprContext() {
        this.gdprContext = null;
    }

    public final void addOrReplaceStateMachine(@NotNull StateMachineInterface stateMachine) {
        Intrinsics.checkNotNullParameter((Object)stateMachine, (String)"stateMachine");
        this.stateManager.addOrReplaceStateMachine(stateMachine);
    }

    public final void removeStateMachine(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        this.stateManager.removeStateMachine(identifier);
    }

    private static final void track$lambda$5(Tracker this$0, Ref.ObjectRef $trackerEvent, Event $event) {
        block2: {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$trackerEvent, (String)"$trackerEvent");
            Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
            Payload payload = this$0.payloadWithEvent((TrackerEvent)$trackerEvent.element);
            if (payload != null) {
                Payload payload2 = payload;
                boolean bl = false;
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Object[] objectArray = new Object[]{payload2};
                Logger.v(string, "Adding new payload to event storage: %s", objectArray);
                this$0.emitter.add(payload2);
                $event.endProcessing(this$0);
                this$0.stateManager.afterTrack((StateMachineEvent)$trackerEvent.element);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block2;
            Tracker $this$track_u24lambda_u245_u24lambda_u244 = this$0;
            boolean bl = false;
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Object[] objectArray = new Object[]{((TrackerEvent)$trackerEvent.element).getEventId()};
            Logger.d(string, "Event not tracked due to filtering: %s", objectArray);
            $event.endProcessing($this$track_u24lambda_u245_u24lambda_u244);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/snowplowanalytics/core/tracker/Tracker$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "snowplow-android-tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

