/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.tracker;

import android.content.Context;
import androidx.annotation.RestrictTo;
import androidx.core.util.Consumer;
import com.snowplowanalytics.core.ecommerce.EcommerceControllerImpl;
import com.snowplowanalytics.core.emitter.Emitter;
import com.snowplowanalytics.core.emitter.EmitterControllerImpl;
import com.snowplowanalytics.core.emitter.NetworkControllerImpl;
import com.snowplowanalytics.core.gdpr.Gdpr;
import com.snowplowanalytics.core.gdpr.GdprControllerImpl;
import com.snowplowanalytics.core.globalcontexts.GlobalContextPluginConfiguration;
import com.snowplowanalytics.core.globalcontexts.GlobalContextsControllerImpl;
import com.snowplowanalytics.core.media.controller.MediaControllerImpl;
import com.snowplowanalytics.core.session.Session;
import com.snowplowanalytics.core.session.SessionControllerImpl;
import com.snowplowanalytics.core.tracker.PluginsControllerImpl;
import com.snowplowanalytics.core.tracker.ServiceProviderInterface;
import com.snowplowanalytics.core.tracker.Subject;
import com.snowplowanalytics.core.tracker.SubjectControllerImpl;
import com.snowplowanalytics.core.tracker.Tracker;
import com.snowplowanalytics.core.tracker.TrackerControllerImpl;
import com.snowplowanalytics.snowplow.configuration.Configuration;
import com.snowplowanalytics.snowplow.configuration.EmitterConfiguration;
import com.snowplowanalytics.snowplow.configuration.GdprConfiguration;
import com.snowplowanalytics.snowplow.configuration.GlobalContextsConfiguration;
import com.snowplowanalytics.snowplow.configuration.NetworkConfiguration;
import com.snowplowanalytics.snowplow.configuration.PluginConfigurationKt;
import com.snowplowanalytics.snowplow.configuration.PluginIdentifiable;
import com.snowplowanalytics.snowplow.configuration.SessionConfiguration;
import com.snowplowanalytics.snowplow.configuration.SubjectConfiguration;
import com.snowplowanalytics.snowplow.configuration.TrackerConfiguration;
import com.snowplowanalytics.snowplow.media.controller.MediaController;
import com.snowplowanalytics.snowplow.network.Protocol;
import com.snowplowanalytics.snowplow.tracker.SessionState;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001a\b\u0007\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u000206H\u0016J\b\u0010^\u001a\u00020\u0013H\u0016J\b\u0010_\u001a\u00020\u001bH\u0016J\b\u0010`\u001a\u00020#H\u0016J\b\u0010a\u001a\u00020bH\u0016J\b\u0010c\u001a\u000203H\u0016J\b\u0010d\u001a\u00020FH\u0016J\b\u0010e\u001a\u00020HH\u0016J\b\u0010f\u001a\u00020PH\u0016J\b\u0010g\u001a\u00020RH\u0016J\b\u0010h\u001a\u00020ZH\u0016J\b\u0010i\u001a\u00020\\H\u0002J\b\u0010j\u001a\u00020\u0013H\u0002J\b\u0010k\u001a\u00020\u001bH\u0002J\b\u0010l\u001a\u00020#H\u0002J\b\u0010m\u001a\u000203H\u0002J\b\u0010n\u001a\u00020FH\u0002J\b\u0010o\u001a\u00020HH\u0002J\b\u0010p\u001a\u00020PH\u0002J\b\u0010q\u001a\u00020RH\u0002J\b\u0010r\u001a\u00020ZH\u0002J\u0016\u0010s\u001a\u00020\\2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0010\u0010t\u001a\u00020\\2\u0006\u0010u\u001a\u00020\u0005H\u0016J\u0014\u0010v\u001a\u00020\\2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\b\u0010w\u001a\u00020\\H\u0002J\b\u0010x\u001a\u00020\\H\u0002J\b\u0010y\u001a\u00020\\H\u0002J\u0006\u0010z\u001a\u00020\\J\b\u0010{\u001a\u00020\\H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u001dX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010&R\u001b\u0010'\u001a\u00020(8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010\u0011\u001a\u0004\b)\u0010*R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u00107\u001a\b\u0012\u0004\u0012\u000206052\f\u00104\u001a\b\u0012\u0004\u0012\u00020605@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u001b\u0010:\u001a\u00020;8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b>\u0010\u0011\u001a\u0004\b<\u0010=R\u001a\u0010?\u001a\u00020@X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u0010\u0010E\u001a\u0004\u0018\u00010FX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010G\u001a\u0004\u0018\u00010HX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010I\u001a\u00020JX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u0010\u0010O\u001a\u0004\u0018\u00010PX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010Q\u001a\u0004\u0018\u00010RX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010S\u001a\u00020TX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bU\u0010V\"\u0004\bW\u0010XR\u0010\u0010Y\u001a\u0004\u0018\u00010ZX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006|"}, d2={"Lcom/snowplowanalytics/core/tracker/ServiceProvider;", "Lcom/snowplowanalytics/core/tracker/ServiceProviderInterface;", "context", "Landroid/content/Context;", "namespace", "", "networkConfiguration", "Lcom/snowplowanalytics/snowplow/configuration/NetworkConfiguration;", "configurations", "", "Lcom/snowplowanalytics/snowplow/configuration/Configuration;", "(Landroid/content/Context;Ljava/lang/String;Lcom/snowplowanalytics/snowplow/configuration/NetworkConfiguration;Ljava/util/List;)V", "ecommerceController", "Lcom/snowplowanalytics/core/ecommerce/EcommerceControllerImpl;", "getEcommerceController", "()Lcom/snowplowanalytics/core/ecommerce/EcommerceControllerImpl;", "ecommerceController$delegate", "Lkotlin/Lazy;", "emitter", "Lcom/snowplowanalytics/core/emitter/Emitter;", "emitterConfiguration", "Lcom/snowplowanalytics/snowplow/configuration/EmitterConfiguration;", "getEmitterConfiguration", "()Lcom/snowplowanalytics/snowplow/configuration/EmitterConfiguration;", "setEmitterConfiguration", "(Lcom/snowplowanalytics/snowplow/configuration/EmitterConfiguration;)V", "emitterController", "Lcom/snowplowanalytics/core/emitter/EmitterControllerImpl;", "gdprConfiguration", "Lcom/snowplowanalytics/snowplow/configuration/GdprConfiguration;", "getGdprConfiguration", "()Lcom/snowplowanalytics/snowplow/configuration/GdprConfiguration;", "setGdprConfiguration", "(Lcom/snowplowanalytics/snowplow/configuration/GdprConfiguration;)V", "gdprController", "Lcom/snowplowanalytics/core/gdpr/GdprControllerImpl;", "isTrackerInitialized", "", "()Z", "mediaController", "Lcom/snowplowanalytics/snowplow/media/controller/MediaController;", "getMediaController", "()Lcom/snowplowanalytics/snowplow/media/controller/MediaController;", "mediaController$delegate", "getNamespace", "()Ljava/lang/String;", "getNetworkConfiguration", "()Lcom/snowplowanalytics/snowplow/configuration/NetworkConfiguration;", "setNetworkConfiguration", "(Lcom/snowplowanalytics/snowplow/configuration/NetworkConfiguration;)V", "networkController", "Lcom/snowplowanalytics/core/emitter/NetworkControllerImpl;", "<set-?>", "", "Lcom/snowplowanalytics/snowplow/configuration/PluginIdentifiable;", "pluginConfigurations", "getPluginConfigurations", "()Ljava/util/List;", "pluginsController", "Lcom/snowplowanalytics/core/tracker/PluginsControllerImpl;", "getPluginsController", "()Lcom/snowplowanalytics/core/tracker/PluginsControllerImpl;", "pluginsController$delegate", "sessionConfiguration", "Lcom/snowplowanalytics/snowplow/configuration/SessionConfiguration;", "getSessionConfiguration", "()Lcom/snowplowanalytics/snowplow/configuration/SessionConfiguration;", "setSessionConfiguration", "(Lcom/snowplowanalytics/snowplow/configuration/SessionConfiguration;)V", "sessionController", "Lcom/snowplowanalytics/core/session/SessionControllerImpl;", "subject", "Lcom/snowplowanalytics/core/tracker/Subject;", "subjectConfiguration", "Lcom/snowplowanalytics/snowplow/configuration/SubjectConfiguration;", "getSubjectConfiguration", "()Lcom/snowplowanalytics/snowplow/configuration/SubjectConfiguration;", "setSubjectConfiguration", "(Lcom/snowplowanalytics/snowplow/configuration/SubjectConfiguration;)V", "subjectController", "Lcom/snowplowanalytics/core/tracker/SubjectControllerImpl;", "tracker", "Lcom/snowplowanalytics/core/tracker/Tracker;", "trackerConfiguration", "Lcom/snowplowanalytics/snowplow/configuration/TrackerConfiguration;", "getTrackerConfiguration", "()Lcom/snowplowanalytics/snowplow/configuration/TrackerConfiguration;", "setTrackerConfiguration", "(Lcom/snowplowanalytics/snowplow/configuration/TrackerConfiguration;)V", "trackerController", "Lcom/snowplowanalytics/core/tracker/TrackerControllerImpl;", "addPlugin", "", "plugin", "getOrMakeEmitter", "getOrMakeEmitterController", "getOrMakeGdprController", "getOrMakeGlobalContextsController", "Lcom/snowplowanalytics/core/globalcontexts/GlobalContextsControllerImpl;", "getOrMakeNetworkController", "getOrMakeSessionController", "getOrMakeSubject", "getOrMakeSubjectController", "getOrMakeTracker", "getOrMakeTrackerController", "initializeConfigurationUpdates", "makeEmitter", "makeEmitterController", "makeGdprController", "makeNetworkController", "makeSessionController", "makeSubject", "makeSubjectController", "makeTracker", "makeTrackerController", "processConfigurations", "removePlugin", "identifier", "reset", "resetConfigurationUpdates", "resetControllers", "resetServices", "shutdown", "stopServices", "snowplow-android-tracker_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@SourceDebugExtension(value={"SMAP\nServiceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceProvider.kt\ncom/snowplowanalytics/core/tracker/ServiceProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,370:1\n1#2:371\n*E\n"})
public final class ServiceProvider
implements ServiceProviderInterface {
    @NotNull
    private final String namespace;
    @NotNull
    private final Context context;
    @Nullable
    private Tracker tracker;
    @Nullable
    private Emitter emitter;
    @Nullable
    private Subject subject;
    @Nullable
    private TrackerControllerImpl trackerController;
    @Nullable
    private EmitterControllerImpl emitterController;
    @Nullable
    private NetworkControllerImpl networkController;
    @Nullable
    private SubjectControllerImpl subjectController;
    @Nullable
    private SessionControllerImpl sessionController;
    @Nullable
    private GdprControllerImpl gdprController;
    @NotNull
    private final Lazy ecommerceController$delegate;
    @NotNull
    private final Lazy pluginsController$delegate;
    @NotNull
    private final Lazy mediaController$delegate;
    public TrackerConfiguration trackerConfiguration;
    public NetworkConfiguration networkConfiguration;
    public SubjectConfiguration subjectConfiguration;
    public EmitterConfiguration emitterConfiguration;
    public SessionConfiguration sessionConfiguration;
    public GdprConfiguration gdprConfiguration;
    @NotNull
    private List<PluginIdentifiable> pluginConfigurations;

    public ServiceProvider(@NotNull Context context, @NotNull String namespace, @NotNull NetworkConfiguration networkConfiguration, @NotNull List<? extends Configuration> configurations) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)networkConfiguration, (String)"networkConfiguration");
        Intrinsics.checkNotNullParameter(configurations, (String)"configurations");
        this.namespace = namespace;
        this.ecommerceController$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EcommerceControllerImpl>(this){
            final /* synthetic */ ServiceProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EcommerceControllerImpl invoke() {
                return new EcommerceControllerImpl(this.this$0);
            }
        }));
        this.pluginsController$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PluginsControllerImpl>(this){
            final /* synthetic */ ServiceProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PluginsControllerImpl invoke() {
                return new PluginsControllerImpl(this.this$0);
            }
        }));
        this.mediaController$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MediaControllerImpl>(this){
            final /* synthetic */ ServiceProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MediaControllerImpl invoke() {
                return new MediaControllerImpl(this.this$0);
            }
        }));
        this.pluginConfigurations = new ArrayList();
        this.context = context;
        this.setTrackerConfiguration(new TrackerConfiguration());
        this.setNetworkConfiguration(new NetworkConfiguration());
        this.setSubjectConfiguration(new SubjectConfiguration());
        this.setEmitterConfiguration(new EmitterConfiguration());
        this.setSessionConfiguration(new SessionConfiguration(null, null, 3, null));
        this.setGdprConfiguration(new GdprConfiguration());
        this.getNetworkConfiguration().setSourceConfig$snowplow_android_tracker_release(networkConfiguration);
        this.processConfigurations(configurations);
        this.getOrMakeTracker();
    }

    @Override
    @NotNull
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean isTrackerInitialized() {
        return this.tracker != null;
    }

    @Override
    @NotNull
    public EcommerceControllerImpl getEcommerceController() {
        Lazy lazy = this.ecommerceController$delegate;
        return (EcommerceControllerImpl)lazy.getValue();
    }

    @Override
    @NotNull
    public PluginsControllerImpl getPluginsController() {
        Lazy lazy = this.pluginsController$delegate;
        return (PluginsControllerImpl)lazy.getValue();
    }

    @Override
    @NotNull
    public MediaController getMediaController() {
        Lazy lazy = this.mediaController$delegate;
        return (MediaController)lazy.getValue();
    }

    @Override
    @NotNull
    public TrackerConfiguration getTrackerConfiguration() {
        TrackerConfiguration trackerConfiguration = this.trackerConfiguration;
        if (trackerConfiguration != null) {
            return trackerConfiguration;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"trackerConfiguration");
        return null;
    }

    public void setTrackerConfiguration(@NotNull TrackerConfiguration trackerConfiguration) {
        Intrinsics.checkNotNullParameter((Object)trackerConfiguration, (String)"<set-?>");
        this.trackerConfiguration = trackerConfiguration;
    }

    @Override
    @NotNull
    public NetworkConfiguration getNetworkConfiguration() {
        NetworkConfiguration networkConfiguration = this.networkConfiguration;
        if (networkConfiguration != null) {
            return networkConfiguration;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"networkConfiguration");
        return null;
    }

    public void setNetworkConfiguration(@NotNull NetworkConfiguration networkConfiguration) {
        Intrinsics.checkNotNullParameter((Object)networkConfiguration, (String)"<set-?>");
        this.networkConfiguration = networkConfiguration;
    }

    @Override
    @NotNull
    public SubjectConfiguration getSubjectConfiguration() {
        SubjectConfiguration subjectConfiguration = this.subjectConfiguration;
        if (subjectConfiguration != null) {
            return subjectConfiguration;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"subjectConfiguration");
        return null;
    }

    public void setSubjectConfiguration(@NotNull SubjectConfiguration subjectConfiguration) {
        Intrinsics.checkNotNullParameter((Object)subjectConfiguration, (String)"<set-?>");
        this.subjectConfiguration = subjectConfiguration;
    }

    @Override
    @NotNull
    public EmitterConfiguration getEmitterConfiguration() {
        EmitterConfiguration emitterConfiguration = this.emitterConfiguration;
        if (emitterConfiguration != null) {
            return emitterConfiguration;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"emitterConfiguration");
        return null;
    }

    public void setEmitterConfiguration(@NotNull EmitterConfiguration emitterConfiguration) {
        Intrinsics.checkNotNullParameter((Object)emitterConfiguration, (String)"<set-?>");
        this.emitterConfiguration = emitterConfiguration;
    }

    @Override
    @NotNull
    public SessionConfiguration getSessionConfiguration() {
        SessionConfiguration sessionConfiguration = this.sessionConfiguration;
        if (sessionConfiguration != null) {
            return sessionConfiguration;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"sessionConfiguration");
        return null;
    }

    public void setSessionConfiguration(@NotNull SessionConfiguration sessionConfiguration) {
        Intrinsics.checkNotNullParameter((Object)sessionConfiguration, (String)"<set-?>");
        this.sessionConfiguration = sessionConfiguration;
    }

    @Override
    @NotNull
    public GdprConfiguration getGdprConfiguration() {
        GdprConfiguration gdprConfiguration = this.gdprConfiguration;
        if (gdprConfiguration != null) {
            return gdprConfiguration;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"gdprConfiguration");
        return null;
    }

    public void setGdprConfiguration(@NotNull GdprConfiguration gdprConfiguration) {
        Intrinsics.checkNotNullParameter((Object)gdprConfiguration, (String)"<set-?>");
        this.gdprConfiguration = gdprConfiguration;
    }

    @Override
    @NotNull
    public List<PluginIdentifiable> getPluginConfigurations() {
        return this.pluginConfigurations;
    }

    public final void reset(@NotNull List<? extends Configuration> configurations) {
        Intrinsics.checkNotNullParameter(configurations, (String)"configurations");
        this.stopServices();
        this.resetConfigurationUpdates();
        this.processConfigurations(configurations);
        this.resetServices();
        this.getOrMakeTracker();
    }

    public final void shutdown() {
        Tracker tracker = this.tracker;
        if (tracker != null) {
            tracker.pauseEventTracking();
        }
        this.stopServices();
        this.resetServices();
        this.resetControllers();
        this.initializeConfigurationUpdates();
    }

    private final void processConfigurations(List<? extends Configuration> configurations) {
        for (Configuration configuration : configurations) {
            Configuration configuration2 = configuration;
            if (configuration2 instanceof NetworkConfiguration) {
                this.getNetworkConfiguration().setSourceConfig$snowplow_android_tracker_release((NetworkConfiguration)configuration);
                continue;
            }
            if (configuration2 instanceof TrackerConfiguration) {
                this.getTrackerConfiguration().setSourceConfig((TrackerConfiguration)configuration);
                continue;
            }
            if (configuration2 instanceof SubjectConfiguration) {
                this.getSubjectConfiguration().setSourceConfig$snowplow_android_tracker_release((SubjectConfiguration)configuration);
                continue;
            }
            if (configuration2 instanceof SessionConfiguration) {
                this.getSessionConfiguration().setSourceConfig$snowplow_android_tracker_release((SessionConfiguration)configuration);
                continue;
            }
            if (configuration2 instanceof EmitterConfiguration) {
                this.getEmitterConfiguration().setSourceConfig$snowplow_android_tracker_release((EmitterConfiguration)configuration);
                continue;
            }
            if (configuration2 instanceof GdprConfiguration) {
                this.getGdprConfiguration().setSourceConfig$snowplow_android_tracker_release((GdprConfiguration)configuration);
                continue;
            }
            if (configuration2 instanceof GlobalContextsConfiguration) {
                for (GlobalContextPluginConfiguration plugin : ((GlobalContextsConfiguration)configuration).toPluginConfigurations$snowplow_android_tracker_release()) {
                    this.getPluginConfigurations().add(plugin);
                }
                continue;
            }
            if (!(configuration2 instanceof PluginIdentifiable)) continue;
            this.getPluginConfigurations().add((PluginIdentifiable)((Object)configuration));
        }
    }

    private final void stopServices() {
        block1: {
            Tracker tracker = this.tracker;
            if (tracker != null) {
                tracker.close();
            }
            Emitter emitter = this.emitter;
            if (emitter == null) break block1;
            emitter.shutdown();
        }
    }

    private final void resetServices() {
        this.emitter = null;
        this.subject = null;
        this.tracker = null;
    }

    private final void resetControllers() {
        this.trackerController = null;
        this.sessionController = null;
        this.emitterController = null;
        this.gdprController = null;
        this.subjectController = null;
        this.networkController = null;
    }

    private final void resetConfigurationUpdates() {
        this.getTrackerConfiguration().setSourceConfig(null);
        this.getSubjectConfiguration().setSourceConfig$snowplow_android_tracker_release(null);
        this.getEmitterConfiguration().setSourceConfig$snowplow_android_tracker_release(null);
        this.getSessionConfiguration().setSourceConfig$snowplow_android_tracker_release(null);
        this.getGdprConfiguration().setSourceConfig$snowplow_android_tracker_release(null);
    }

    private final void initializeConfigurationUpdates() {
        this.setNetworkConfiguration(new NetworkConfiguration());
        this.setTrackerConfiguration(new TrackerConfiguration());
        this.setEmitterConfiguration(new EmitterConfiguration());
        this.setSubjectConfiguration(new SubjectConfiguration());
        this.setSessionConfiguration(new SessionConfiguration(null, null, 3, null));
        this.setGdprConfiguration(new GdprConfiguration());
    }

    @Override
    @NotNull
    public Subject getOrMakeSubject() {
        Subject subject = this.subject;
        if (subject == null) {
            Subject subject2;
            Subject it = subject2 = this.makeSubject();
            boolean bl = false;
            this.subject = it;
            subject = subject2;
        }
        return subject;
    }

    @Override
    @NotNull
    public Emitter getOrMakeEmitter() {
        Emitter emitter = this.emitter;
        if (emitter == null) {
            Emitter emitter2;
            Emitter it = emitter2 = this.makeEmitter();
            boolean bl = false;
            this.emitter = it;
            emitter = emitter2;
        }
        return emitter;
    }

    @Override
    @NotNull
    public Tracker getOrMakeTracker() {
        Tracker tracker = this.tracker;
        if (tracker == null) {
            Tracker tracker2;
            Tracker it = tracker2 = this.makeTracker();
            boolean bl = false;
            this.tracker = it;
            tracker = tracker2;
        }
        return tracker;
    }

    @Override
    @NotNull
    public TrackerControllerImpl getOrMakeTrackerController() {
        TrackerControllerImpl trackerControllerImpl = this.trackerController;
        if (trackerControllerImpl == null) {
            TrackerControllerImpl trackerControllerImpl2;
            TrackerControllerImpl it = trackerControllerImpl2 = this.makeTrackerController();
            boolean bl = false;
            this.trackerController = it;
            trackerControllerImpl = trackerControllerImpl2;
        }
        return trackerControllerImpl;
    }

    @Override
    @NotNull
    public SessionControllerImpl getOrMakeSessionController() {
        SessionControllerImpl sessionControllerImpl = this.sessionController;
        if (sessionControllerImpl == null) {
            SessionControllerImpl sessionControllerImpl2;
            SessionControllerImpl it = sessionControllerImpl2 = this.makeSessionController();
            boolean bl = false;
            this.sessionController = it;
            sessionControllerImpl = sessionControllerImpl2;
        }
        return sessionControllerImpl;
    }

    @Override
    @NotNull
    public EmitterControllerImpl getOrMakeEmitterController() {
        EmitterControllerImpl emitterControllerImpl = this.emitterController;
        if (emitterControllerImpl == null) {
            EmitterControllerImpl emitterControllerImpl2;
            EmitterControllerImpl it = emitterControllerImpl2 = this.makeEmitterController();
            boolean bl = false;
            this.emitterController = it;
            emitterControllerImpl = emitterControllerImpl2;
        }
        return emitterControllerImpl;
    }

    @Override
    @NotNull
    public GdprControllerImpl getOrMakeGdprController() {
        GdprControllerImpl gdprControllerImpl = this.gdprController;
        if (gdprControllerImpl == null) {
            GdprControllerImpl gdprControllerImpl2;
            GdprControllerImpl it = gdprControllerImpl2 = this.makeGdprController();
            boolean bl = false;
            this.gdprController = it;
            gdprControllerImpl = gdprControllerImpl2;
        }
        return gdprControllerImpl;
    }

    @Override
    @NotNull
    public GlobalContextsControllerImpl getOrMakeGlobalContextsController() {
        return new GlobalContextsControllerImpl(this);
    }

    @Override
    @NotNull
    public SubjectControllerImpl getOrMakeSubjectController() {
        SubjectControllerImpl subjectControllerImpl = this.subjectController;
        if (subjectControllerImpl == null) {
            SubjectControllerImpl subjectControllerImpl2;
            SubjectControllerImpl it = subjectControllerImpl2 = this.makeSubjectController();
            boolean bl = false;
            this.subjectController = it;
            subjectControllerImpl = subjectControllerImpl2;
        }
        return subjectControllerImpl;
    }

    @Override
    @NotNull
    public NetworkControllerImpl getOrMakeNetworkController() {
        NetworkControllerImpl networkControllerImpl = this.networkController;
        if (networkControllerImpl == null) {
            NetworkControllerImpl networkControllerImpl2;
            NetworkControllerImpl it = networkControllerImpl2 = this.makeNetworkController();
            boolean bl = false;
            this.networkController = it;
            networkControllerImpl = networkControllerImpl2;
        }
        return networkControllerImpl;
    }

    private final Subject makeSubject() {
        return new Subject(this.context, this.getSubjectConfiguration());
    }

    private final Emitter makeEmitter() {
        String string = this.getNetworkConfiguration().getEndpoint();
        if (string == null) {
            string = "";
        }
        String endpoint = string;
        Function1 builder2 = (Function1)new Function1<Emitter, Unit>(this){
            final /* synthetic */ ServiceProvider this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Emitter emitter) {
                Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
                emitter.setHttpMethod(this.this$0.getNetworkConfiguration().getMethod());
                Protocol protocol = this.this$0.getNetworkConfiguration().getProtocol();
                if (protocol != null) {
                    Protocol it = protocol;
                    boolean bl = false;
                    emitter.setRequestSecurity(it);
                }
                emitter.setNetworkConnection(this.this$0.getNetworkConfiguration().getNetworkConnection());
                emitter.setCustomPostPath(this.this$0.getNetworkConfiguration().getCustomPostPath());
                emitter.setClient(this.this$0.getNetworkConfiguration().getOkHttpClient());
                emitter.setCookieJar(this.this$0.getNetworkConfiguration().getOkHttpCookieJar());
                emitter.setEmitTimeout(this.this$0.getNetworkConfiguration().getTimeout());
                emitter.setSendLimit(this.this$0.getEmitterConfiguration().getEmitRange());
                emitter.setBufferOption(this.this$0.getEmitterConfiguration().getBufferOption());
                emitter.setEventStore(this.this$0.getEmitterConfiguration().getEventStore());
                emitter.setByteLimitPost(this.this$0.getEmitterConfiguration().getByteLimitPost());
                emitter.setByteLimitGet(this.this$0.getEmitterConfiguration().getByteLimitGet());
                emitter.setThreadPoolSize(this.this$0.getEmitterConfiguration().getThreadPoolSize());
                emitter.setRequestCallback(this.this$0.getEmitterConfiguration().getRequestCallback());
                emitter.setCustomRetryForStatusCodes(this.this$0.getEmitterConfiguration().getCustomRetryForStatusCodes());
                emitter.setServerAnonymisation(this.this$0.getEmitterConfiguration().getServerAnonymisation());
                emitter.setRequestHeaders(this.this$0.getNetworkConfiguration().getRequestHeaders());
                emitter.setRetryFailedRequests(this.this$0.getEmitterConfiguration().getRetryFailedRequests());
            }
        };
        Emitter emitter = new Emitter(this.context, endpoint, (Function1<? super Emitter, Unit>)builder2);
        if (this.getEmitterConfiguration().isPaused$snowplow_android_tracker_release()) {
            emitter.pauseEmit();
        }
        return emitter;
    }

    private final Tracker makeTracker() {
        Consumer<SessionState> onSessionUpdate;
        Session session;
        Emitter emitter = this.getOrMakeEmitter();
        Subject subject = this.getOrMakeSubject();
        Function1 builder2 = (Function1)new Function1<Tracker, Unit>(subject, this){
            final /* synthetic */ Subject $subject;
            final /* synthetic */ ServiceProvider this$0;
            {
                this.$subject = $subject;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Tracker tracker) {
                Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
                tracker.setSubject(this.$subject);
                tracker.setTrackerVersionSuffix(this.this$0.getTrackerConfiguration().getTrackerVersionSuffix());
                tracker.setBase64Encoded(this.this$0.getTrackerConfiguration().getBase64encoding());
                tracker.setPlatform(this.this$0.getTrackerConfiguration().getDevicePlatform());
                tracker.setLogLevel(this.this$0.getTrackerConfiguration().getLogLevel());
                tracker.setLoggerDelegate(this.this$0.getTrackerConfiguration().getLoggerDelegate());
                tracker.setSessionContext(this.this$0.getTrackerConfiguration().getSessionContext());
                tracker.setApplicationContext(this.this$0.getTrackerConfiguration().getApplicationContext());
                tracker.setPlatformContextEnabled(this.this$0.getTrackerConfiguration().getPlatformContext());
                tracker.setGeoLocationContext(this.this$0.getTrackerConfiguration().getGeoLocationContext());
                tracker.setDeepLinkContext(this.this$0.getTrackerConfiguration().getDeepLinkContext());
                tracker.setScreenContext(this.this$0.getTrackerConfiguration().getScreenContext());
                tracker.setScreenViewAutotracking(this.this$0.getTrackerConfiguration().getScreenViewAutotracking());
                tracker.setLifecycleAutotracking(this.this$0.getTrackerConfiguration().getLifecycleAutotracking());
                tracker.setInstallAutotracking(this.this$0.getTrackerConfiguration().getInstallAutotracking());
                tracker.setExceptionAutotracking(this.this$0.getTrackerConfiguration().getExceptionAutotracking());
                tracker.setDiagnosticAutotracking(this.this$0.getTrackerConfiguration().getDiagnosticAutotracking());
                tracker.setUserAnonymisation(this.this$0.getTrackerConfiguration().getUserAnonymisation());
                tracker.setTrackerVersionSuffix(this.this$0.getTrackerConfiguration().getTrackerVersionSuffix());
                GdprConfiguration gdprConfiguration = this.this$0.getGdprConfiguration().getSourceConfig$snowplow_android_tracker_release();
                if (gdprConfiguration != null) {
                    GdprConfiguration it = gdprConfiguration;
                    boolean bl = false;
                    tracker.setGdprContext(new Gdpr(it.getBasisForProcessing(), it.getDocumentId(), it.getDocumentVersion(), it.getDocumentDescription()));
                }
                tracker.setBackgroundTimeout(this.this$0.getSessionConfiguration().getBackgroundTimeout().convert(TimeUnit.SECONDS));
                tracker.setForegroundTimeout(this.this$0.getSessionConfiguration().getForegroundTimeout().convert(TimeUnit.SECONDS));
                for (PluginIdentifiable plugin : this.this$0.getPluginConfigurations()) {
                    tracker.addOrReplaceStateMachine(PluginConfigurationKt.toStateMachine(plugin));
                }
            }
        };
        Tracker tracker = new Tracker(emitter, this.getNamespace(), this.getTrackerConfiguration().getAppId(), this.getTrackerConfiguration().getPlatformContextProperties(), this.context, (Function1<? super Tracker, Unit>)builder2);
        if (this.getTrackerConfiguration().isPaused$snowplow_android_tracker_release()) {
            tracker.pauseEventTracking();
        }
        if (this.getSessionConfiguration().isPaused$snowplow_android_tracker_release()) {
            tracker.pauseSessionChecking();
        }
        if ((session = tracker.getSession()) != null && (onSessionUpdate = this.getSessionConfiguration().getOnSessionUpdate()) != null) {
            session.setOnSessionUpdate(onSessionUpdate);
        }
        return tracker;
    }

    private final TrackerControllerImpl makeTrackerController() {
        return new TrackerControllerImpl(this);
    }

    private final SessionControllerImpl makeSessionController() {
        return new SessionControllerImpl(this);
    }

    private final EmitterControllerImpl makeEmitterController() {
        return new EmitterControllerImpl(this);
    }

    private final GdprControllerImpl makeGdprController() {
        GdprControllerImpl controller;
        block0: {
            Gdpr gdpr;
            controller = new GdprControllerImpl(this);
            Gdpr gdpr2 = gdpr = this.getOrMakeTracker().getGdprContext();
            if (gdpr2 == null) break block0;
            Gdpr it = gdpr2;
            boolean bl = false;
            controller.reset(it.getBasisForProcessing(), it.getDocumentId(), it.getDocumentVersion(), it.getDocumentDescription());
        }
        return controller;
    }

    private final SubjectControllerImpl makeSubjectController() {
        return new SubjectControllerImpl(this);
    }

    private final NetworkControllerImpl makeNetworkController() {
        return new NetworkControllerImpl(this);
    }

    @Override
    public void addPlugin(@NotNull PluginIdentifiable plugin) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            this.removePlugin(plugin.getIdentifier());
            this.getPluginConfigurations().add(plugin);
            Tracker tracker = this.tracker;
            if (tracker == null) break block0;
            tracker.addOrReplaceStateMachine(PluginConfigurationKt.toStateMachine(plugin));
        }
    }

    @Override
    public void removePlugin(@NotNull String identifier) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            CollectionsKt.removeAll(this.getPluginConfigurations(), (Function1)((Function1)new Function1<PluginIdentifiable, Boolean>(identifier){
                final /* synthetic */ String $identifier;
                {
                    this.$identifier = $identifier;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull PluginIdentifiable it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getIdentifier(), (Object)this.$identifier);
                }
            }));
            Tracker tracker = this.tracker;
            if (tracker == null) break block0;
            tracker.removeStateMachine(identifier);
        }
    }
}

