/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.tracker;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.NetworkInfo;
import android.util.Pair;
import com.snowplowanalytics.core.emitter.Executor;
import com.snowplowanalytics.core.utils.DeviceInfoMonitor;
import com.snowplowanalytics.core.utils.Util;
import com.snowplowanalytics.snowplow.configuration.PlatformContextProperty;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001f\b\u0016\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B5\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0002J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\b\u0010\u001e\u001a\u00020\u0018H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/snowplowanalytics/core/tracker/PlatformContext;", "", "platformContextProperties", "", "Lcom/snowplowanalytics/snowplow/configuration/PlatformContextProperty;", "context", "Landroid/content/Context;", "(Ljava/util/List;Landroid/content/Context;)V", "platformDictUpdateFrequency", "", "networkDictUpdateFrequency", "deviceInfoMonitor", "Lcom/snowplowanalytics/core/utils/DeviceInfoMonitor;", "(JJLcom/snowplowanalytics/core/utils/DeviceInfoMonitor;Ljava/util/List;Landroid/content/Context;)V", "lastUpdatedEphemeralNetworkDict", "lastUpdatedEphemeralPlatformDict", "pairs", "", "", "getMobileContext", "Lcom/snowplowanalytics/snowplow/payload/SelfDescribingJson;", "userAnonymisation", "", "setAppSetId", "", "setEphemeralNetworkDict", "setEphemeralPlatformDict", "setPlatformDict", "shouldTrack", "property", "updateEphemeralDictsIfNecessary", "Companion", "snowplow-android-tracker_release"})
public final class PlatformContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long platformDictUpdateFrequency;
    private final long networkDictUpdateFrequency;
    @NotNull
    private final DeviceInfoMonitor deviceInfoMonitor;
    @Nullable
    private final List<PlatformContextProperty> platformContextProperties;
    @NotNull
    private final Context context;
    @NotNull
    private final Map<String, Object> pairs;
    private long lastUpdatedEphemeralPlatformDict;
    private long lastUpdatedEphemeralNetworkDict;
    private static final String TAG = PlatformContext.class.getSimpleName();

    public PlatformContext(long platformDictUpdateFrequency, long networkDictUpdateFrequency, @NotNull DeviceInfoMonitor deviceInfoMonitor, @Nullable List<? extends PlatformContextProperty> platformContextProperties, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)deviceInfoMonitor, (String)"deviceInfoMonitor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.platformDictUpdateFrequency = platformDictUpdateFrequency;
        this.networkDictUpdateFrequency = networkDictUpdateFrequency;
        this.deviceInfoMonitor = deviceInfoMonitor;
        this.platformContextProperties = platformContextProperties;
        this.context = context;
        this.pairs = new HashMap();
        this.setPlatformDict();
    }

    public PlatformContext(@Nullable List<? extends PlatformContextProperty> platformContextProperties, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(1000L, 10000L, new DeviceInfoMonitor(), platformContextProperties, context);
    }

    @Nullable
    public final SelfDescribingJson getMobileContext(boolean userAnonymisation) {
        this.updateEphemeralDictsIfNecessary();
        String[] stringArray = new String[]{"osType", "osVersion", "deviceManufacturer", "deviceModel"};
        if (!Util.mapHasKeys(this.pairs, stringArray)) {
            return null;
        }
        if (userAnonymisation && this.pairs.containsKey("androidIdfa")) {
            Map copy = new HashMap<String, Object>(this.pairs);
            copy.remove("androidIdfa");
            return new SelfDescribingJson("iglu:com.snowplowanalytics.snowplow/mobile_context/jsonschema/1-0-3", copy);
        }
        return new SelfDescribingJson("iglu:com.snowplowanalytics.snowplow/mobile_context/jsonschema/1-0-3", this.pairs);
    }

    private final synchronized void updateEphemeralDictsIfNecessary() {
        long now = System.currentTimeMillis();
        if (now - this.lastUpdatedEphemeralPlatformDict >= this.platformDictUpdateFrequency) {
            this.setEphemeralPlatformDict();
        }
        if (now - this.lastUpdatedEphemeralNetworkDict >= this.networkDictUpdateFrequency) {
            this.setEphemeralNetworkDict();
        }
    }

    private final void setPlatformDict() {
        Util.addToMap("osType", this.deviceInfoMonitor.getOsType(), this.pairs);
        Util.addToMap("osVersion", this.deviceInfoMonitor.getOsVersion(), this.pairs);
        Util.addToMap("deviceModel", this.deviceInfoMonitor.getDeviceModel(), this.pairs);
        Util.addToMap("deviceManufacturer", this.deviceInfoMonitor.getDeviceVendor(), this.pairs);
        if (this.shouldTrack(PlatformContextProperty.CARRIER)) {
            Util.addToMap("carrier", this.deviceInfoMonitor.getCarrier(this.context), this.pairs);
        }
        if (this.shouldTrack(PlatformContextProperty.PHYSICAL_MEMORY)) {
            Util.addToMap("physicalMemory", this.deviceInfoMonitor.getPhysicalMemory(this.context), this.pairs);
        }
        if (this.shouldTrack(PlatformContextProperty.TOTAL_STORAGE)) {
            Util.addToMap("totalStorage", this.deviceInfoMonitor.getTotalStorage(), this.pairs);
        }
        if (this.shouldTrack(PlatformContextProperty.RESOLUTION)) {
            Util.addToMap("resolution", this.deviceInfoMonitor.getResolution(this.context), this.pairs);
        }
        if (this.shouldTrack(PlatformContextProperty.SCALE)) {
            Util.addToMap("scale", this.deviceInfoMonitor.getScale(this.context), this.pairs);
        }
        if (this.shouldTrack(PlatformContextProperty.LANGUAGE)) {
            String string = this.deviceInfoMonitor.getLanguage();
            Util.addToMap("language", string != null ? StringsKt.take((String)string, (int)8) : null, this.pairs);
        }
        this.setEphemeralPlatformDict();
        this.setEphemeralNetworkDict();
        this.setAppSetId();
    }

    private final void setEphemeralPlatformDict() {
        Pair<String, Integer> batteryInfo;
        Object currentIdfa;
        this.lastUpdatedEphemeralPlatformDict = System.currentTimeMillis();
        if (this.shouldTrack(PlatformContextProperty.ANDROID_IDFA) && ((currentIdfa = this.pairs.get("androidIdfa")) == null || ((CharSequence)currentIdfa.toString()).length() == 0)) {
            Util.addToMap("androidIdfa", this.deviceInfoMonitor.getAndroidIdfa(this.context), this.pairs);
        }
        boolean trackBatState = this.shouldTrack(PlatformContextProperty.BATTERY_STATE);
        boolean trackBatLevel = this.shouldTrack(PlatformContextProperty.BATTERY_LEVEL);
        if ((trackBatState || trackBatLevel) && (batteryInfo = this.deviceInfoMonitor.getBatteryStateAndLevel(this.context)) != null) {
            if (trackBatState) {
                Util.addToMap("batteryState", batteryInfo.first, this.pairs);
            }
            if (trackBatLevel) {
                Util.addToMap("batteryLevel", batteryInfo.second, this.pairs);
            }
        }
        if (this.shouldTrack(PlatformContextProperty.SYSTEM_AVAILABLE_MEMORY)) {
            Util.addToMap("systemAvailableMemory", this.deviceInfoMonitor.getSystemAvailableMemory(this.context), this.pairs);
        }
        if (this.shouldTrack(PlatformContextProperty.AVAILABLE_STORAGE)) {
            Util.addToMap("availableStorage", this.deviceInfoMonitor.getAvailableStorage(), this.pairs);
        }
        if (this.shouldTrack(PlatformContextProperty.IS_PORTRAIT)) {
            Util.addToMap("isPortrait", this.deviceInfoMonitor.getIsPortrait(this.context), this.pairs);
        }
    }

    private final void setEphemeralNetworkDict() {
        this.lastUpdatedEphemeralNetworkDict = System.currentTimeMillis();
        boolean trackType = this.shouldTrack(PlatformContextProperty.NETWORK_TYPE);
        boolean trackTech = this.shouldTrack(PlatformContextProperty.NETWORK_TECHNOLOGY);
        if (!trackType && !trackTech) {
            return;
        }
        NetworkInfo networkInfo = this.deviceInfoMonitor.getNetworkInfo(this.context);
        if (trackType) {
            Util.addToMap("networkType", this.deviceInfoMonitor.getNetworkType(networkInfo), this.pairs);
        }
        if (trackTech) {
            Util.addToMap("networkTechnology", this.deviceInfoMonitor.getNetworkTechnology(networkInfo), this.pairs);
        }
    }

    private final void setAppSetId() {
        boolean trackId = this.shouldTrack(PlatformContextProperty.APP_SET_ID);
        boolean trackScope = this.shouldTrack(PlatformContextProperty.APP_SET_ID_SCOPE);
        if (!trackId && !trackScope) {
            return;
        }
        SharedPreferences generalPref = this.context.getSharedPreferences("snowplow_general_vars", 0);
        String appSetId = generalPref.getString("appSetId", null);
        String appSetIdScope = generalPref.getString("appSetIdScope", null);
        if (appSetId != null && appSetIdScope != null) {
            if (trackId) {
                Util.addToMap("appSetId", appSetId, this.pairs);
            }
            if (trackScope) {
                Util.addToMap("appSetIdScope", appSetIdScope, this.pairs);
            }
        } else {
            Executor.execute(TAG, () -> PlatformContext.setAppSetId$lambda$1(this, trackId, trackScope, generalPref));
        }
    }

    private final boolean shouldTrack(PlatformContextProperty property) {
        List<PlatformContextProperty> list = this.platformContextProperties;
        return list != null ? list.contains((Object)property) : true;
    }

    private static final void setAppSetId$lambda$1(PlatformContext this$0, boolean $trackId, boolean $trackScope, SharedPreferences $generalPref) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Pair<String, String> pair = this$0.deviceInfoMonitor.getAppSetIdAndScope(this$0.context);
            if (pair == null) break block2;
            Pair<String, String> it = pair;
            boolean bl = false;
            if ($trackId) {
                Util.addToMap("appSetId", it.first, this$0.pairs);
            }
            if ($trackScope) {
                Util.addToMap("appSetIdScope", it.second, this$0.pairs);
            }
            $generalPref.edit().putString("appSetId", (String)it.first).putString("appSetIdScope", (String)it.second).apply();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/snowplowanalytics/core/tracker/PlatformContext$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "snowplow-android-tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

