/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.tracker;

import android.content.Context;
import android.os.RemoteException;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.snowplowanalytics.core.tracker.Logger;
import com.snowplowanalytics.core.utils.Util;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0001\nB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\u000b"}, d2={"Lcom/snowplowanalytics/core/tracker/InstallReferrerDetails;", "Lcom/snowplowanalytics/snowplow/payload/SelfDescribingJson;", "installReferrer", "", "referrerClickTimestamp", "", "installBeginTimestamp", "googlePlayInstantParam", "", "(Ljava/lang/String;JJZ)V", "Companion", "snowplow-android-tracker_release"})
public final class InstallReferrerDetails
extends SelfDescribingJson {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final String TAG = InstallReferrerDetails.class.getSimpleName();

    public InstallReferrerDetails(@NotNull String installReferrer, long referrerClickTimestamp, long installBeginTimestamp, boolean googlePlayInstantParam) {
        Intrinsics.checkNotNullParameter((Object)installReferrer, (String)"installReferrer");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"installReferrer", (Object)installReferrer), TuplesKt.to((Object)"referrerClickTimestamp", (Object)(referrerClickTimestamp > 0L ? Util.getDateTimeFromTimestamp(referrerClickTimestamp) : null)), TuplesKt.to((Object)"installBeginTimestamp", (Object)(installBeginTimestamp > 0L ? Util.getDateTimeFromTimestamp(installBeginTimestamp) : null)), TuplesKt.to((Object)"googlePlayInstantParam", (Object)googlePlayInstantParam)};
        super("iglu:com.android.installreferrer.api/referrer_details/jsonschema/1-0-0", MapsKt.mapOf((Pair[])pairArray));
    }

    public static final /* synthetic */ String access$getTAG$cp() {
        return TAG;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2#\u0010\n\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00070\u000bJ\u0006\u0010\u0010\u001a\u00020\u0011R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/snowplowanalytics/core/tracker/InstallReferrerDetails$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "fetch", "", "context", "Landroid/content/Context;", "callback", "Lkotlin/Function1;", "Lcom/snowplowanalytics/core/tracker/InstallReferrerDetails;", "Lkotlin/ParameterName;", "name", "installReferrer", "isInstallReferrerPackageAvailable", "", "snowplow-android-tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void fetch(@NotNull Context context, @NotNull Function1<? super InstallReferrerDetails, Unit> callback) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            if (!this.isInstallReferrerPackageAvailable()) {
                callback.invoke(null);
                return;
            }
            InstallReferrerClient referrerClient = InstallReferrerClient.newBuilder((Context)context).build();
            referrerClient.startConnection(new InstallReferrerStateListener(referrerClient, callback){
                final /* synthetic */ InstallReferrerClient $referrerClient;
                final /* synthetic */ Function1<InstallReferrerDetails, Unit> $callback;
                {
                    this.$referrerClient = $referrerClient;
                    this.$callback = $callback;
                }

                public void onInstallReferrerSetupFinished(int responseCode) {
                    switch (responseCode) {
                        case 0: {
                            try {
                                ReferrerDetails referrerDetails = this.$referrerClient.getInstallReferrer();
                                Intrinsics.checkNotNullExpressionValue((Object)referrerDetails, (String)"referrerClient.installReferrer");
                                ReferrerDetails response = referrerDetails;
                                String string = response.getInstallReferrer();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.installReferrer");
                                InstallReferrerDetails referrer = new InstallReferrerDetails(string, response.getReferrerClickTimestampSeconds(), response.getInstallBeginTimestampSeconds(), response.getGooglePlayInstantParam());
                                this.$callback.invoke((Object)referrer);
                            }
                            catch (RemoteException _) {
                                String string = InstallReferrerDetails.access$getTAG$cp();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                                Logger.d(string, "Install referrer API remote exception.", new Object[0]);
                                this.$callback.invoke(null);
                            }
                            break;
                        }
                        case 2: {
                            String string = InstallReferrerDetails.access$getTAG$cp();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                            Logger.d(string, "Install referrer API not available on the current Play Store app.", new Object[0]);
                            this.$callback.invoke(null);
                            break;
                        }
                        case 1: {
                            String string = InstallReferrerDetails.access$getTAG$cp();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                            Logger.d(string, "Install referrer API connection couldn't be established.", new Object[0]);
                            this.$callback.invoke(null);
                        }
                    }
                }

                public void onInstallReferrerServiceDisconnected() {
                }
            });
        }

        public final boolean isInstallReferrerPackageAvailable() {
            try {
                Class.forName("com.android.installreferrer.api.InstallReferrerStateListener");
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

