/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.tracker;

import androidx.annotation.RestrictTo;
import com.snowplowanalytics.core.tracker.Logger;
import com.snowplowanalytics.core.utils.NotificationCenter;
import com.snowplowanalytics.core.utils.Util;
import com.snowplowanalytics.snowplow.event.SelfDescribing;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/snowplowanalytics/core/tracker/ExceptionHandler;", "Ljava/lang/Thread$UncaughtExceptionHandler;", "()V", "defaultHandler", "truncateString", "", "str", "maxLength", "", "uncaughtException", "", "t", "Ljava/lang/Thread;", "e", "", "Companion", "snowplow-android-tracker_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Thread.UncaughtExceptionHandler defaultHandler = Thread.getDefaultUncaughtExceptionHandler();
    private static final String TAG = ExceptionHandler.class.getSimpleName();
    private static final int MAX_MESSAGE_LENGTH = 2048;
    private static final int MAX_STACK_LENGTH = 8096;
    private static final int MAX_THREAD_NAME_LENGTH = 1024;
    private static final int MAX_CLASS_NAME_LENGTH = 1024;
    private static final int MAX_EXCEPTION_NAME_LENGTH = 1024;

    @Override
    public void uncaughtException(@NotNull Thread t, @NotNull Throwable e) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.d(string, "Uncaught exception being tracked...", new Object[0]);
            String message = this.truncateString(e.getMessage(), 2048);
            if (message == null || ((CharSequence)message).length() == 0) {
                message = "Android Exception. Null or empty message found";
            }
            String stack = this.truncateString(Util.stackTraceToString(e), 8096);
            String threadName = this.truncateString(t.getName(), 1024);
            Integer lineNumber = null;
            String className = null;
            StackTraceElement[] stackTraceElementArray = e.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"e.stackTrace");
            if (!(((Object[])stackTraceElementArray).length == 0)) {
                StackTraceElement stackElement = e.getStackTrace()[0];
                lineNumber = stackElement.getLineNumber();
                if (lineNumber < 0) {
                    lineNumber = null;
                }
                className = this.truncateString(stackElement.getClassName(), 1024);
            }
            String exceptionName = this.truncateString(e.getClass().getName(), 1024);
            Map data = new HashMap();
            Util.addToMap("message", message, data);
            Util.addToMap("stackTrace", stack, data);
            Util.addToMap("threadName", threadName, data);
            Util.addToMap("threadId", t.getId(), data);
            Util.addToMap("programmingLanguage", "JAVA", data);
            Util.addToMap("lineNumber", lineNumber, data);
            Util.addToMap("className", className, data);
            Util.addToMap("exceptionName", exceptionName, data);
            Util.addToMap("isFatal", true, data);
            SelfDescribing event = new SelfDescribing(new SelfDescribingJson("iglu:com.snowplowanalytics.snowplow/application_error/jsonschema/1-0-0", data));
            Map notificationData = new HashMap();
            notificationData.put("event", event);
            NotificationCenter.postNotification("SnowplowCrashReporting", notificationData);
            Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.defaultHandler;
            if (uncaughtExceptionHandler == null) break block3;
            uncaughtExceptionHandler.uncaughtException(t, e);
        }
    }

    private final String truncateString(String str, int maxLength) {
        String string;
        String string2 = str;
        if (string2 != null) {
            String string3 = string2.substring(0, RangesKt.coerceAtMost((int)str.length(), (int)maxLength));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = null;
        }
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/snowplowanalytics/core/tracker/ExceptionHandler$Companion;", "", "()V", "MAX_CLASS_NAME_LENGTH", "", "MAX_EXCEPTION_NAME_LENGTH", "MAX_MESSAGE_LENGTH", "MAX_STACK_LENGTH", "MAX_THREAD_NAME_LENGTH", "TAG", "", "kotlin.jvm.PlatformType", "snowplow-android-tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

