/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.statemachine;

import com.snowplowanalytics.core.emitter.Executor;
import com.snowplowanalytics.core.statemachine.State;
import com.snowplowanalytics.core.statemachine.StateFuture;
import com.snowplowanalytics.core.statemachine.StateMachineEvent;
import com.snowplowanalytics.core.statemachine.StateMachineInterface;
import com.snowplowanalytics.core.statemachine.TrackerState;
import com.snowplowanalytics.core.statemachine.TrackerStateSnapshot;
import com.snowplowanalytics.snowplow.event.AbstractSelfDescribing;
import com.snowplowanalytics.snowplow.event.Event;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J8\u0010\u0019\u001a\u00020\u00132\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001d2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010!\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J8\u0010\"\u001a\u00020\u00132\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060#2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u000e\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u0005J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020(R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006*"}, d2={"Lcom/snowplowanalytics/core/statemachine/StateManager;", "", "()V", "eventSchemaToAfterTrackCallback", "Ljava/util/HashMap;", "", "", "Lcom/snowplowanalytics/core/statemachine/StateMachineInterface;", "eventSchemaToEntitiesGenerator", "eventSchemaToFilter", "eventSchemaToPayloadUpdater", "eventSchemaToStateMachine", "identifierToStateMachine", "stateMachineToIdentifier", "trackerState", "Lcom/snowplowanalytics/core/statemachine/TrackerState;", "getTrackerState", "()Lcom/snowplowanalytics/core/statemachine/TrackerState;", "addOrReplaceStateMachine", "", "stateMachine", "addPayloadValuesToEvent", "", "event", "Lcom/snowplowanalytics/core/statemachine/StateMachineEvent;", "addToSchemaRegistry", "schemaRegistry", "", "schemas", "", "afterTrack", "entitiesForProcessedEvent", "Lcom/snowplowanalytics/snowplow/payload/SelfDescribingJson;", "filter", "removeFromSchemaRegistry", "", "removeStateMachine", "identifier", "trackerStateForProcessedEvent", "Lcom/snowplowanalytics/core/statemachine/TrackerStateSnapshot;", "Lcom/snowplowanalytics/snowplow/event/Event;", "Companion", "snowplow-android-tracker_release"})
@SourceDebugExtension(value={"SMAP\nStateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateManager.kt\ncom/snowplowanalytics/core/statemachine/StateManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,246:1\n1#2:247\n*E\n"})
public final class StateManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<String, StateMachineInterface> identifierToStateMachine = new HashMap();
    @NotNull
    private final HashMap<StateMachineInterface, String> stateMachineToIdentifier = new HashMap();
    @NotNull
    private final HashMap<String, List<StateMachineInterface>> eventSchemaToStateMachine = new HashMap();
    @NotNull
    private final HashMap<String, List<StateMachineInterface>> eventSchemaToEntitiesGenerator = new HashMap();
    @NotNull
    private final HashMap<String, List<StateMachineInterface>> eventSchemaToPayloadUpdater = new HashMap();
    @NotNull
    private final HashMap<String, List<StateMachineInterface>> eventSchemaToAfterTrackCallback = new HashMap();
    @NotNull
    private final HashMap<String, List<StateMachineInterface>> eventSchemaToFilter = new HashMap();
    @NotNull
    private final TrackerState trackerState = new TrackerState();
    private static final String TAG = StateManager.class.getSimpleName();

    @NotNull
    public final TrackerState getTrackerState() {
        return this.trackerState;
    }

    public final synchronized void addOrReplaceStateMachine(@NotNull StateMachineInterface stateMachine) {
        Intrinsics.checkNotNullParameter((Object)stateMachine, (String)"stateMachine");
        StateMachineInterface previousStateMachine = this.identifierToStateMachine.get(stateMachine.getIdentifier());
        if (previousStateMachine != null) {
            if (Intrinsics.areEqual(stateMachine.getClass(), previousStateMachine.getClass())) {
                return;
            }
            this.removeStateMachine(stateMachine.getIdentifier());
        }
        ((Map)this.identifierToStateMachine).put(stateMachine.getIdentifier(), stateMachine);
        ((Map)this.stateMachineToIdentifier).put(stateMachine, stateMachine.getIdentifier());
        this.addToSchemaRegistry((Map<String, List<StateMachineInterface>>)this.eventSchemaToStateMachine, stateMachine.getSubscribedEventSchemasForTransitions(), stateMachine);
        this.addToSchemaRegistry((Map<String, List<StateMachineInterface>>)this.eventSchemaToEntitiesGenerator, stateMachine.getSubscribedEventSchemasForEntitiesGeneration(), stateMachine);
        this.addToSchemaRegistry((Map<String, List<StateMachineInterface>>)this.eventSchemaToPayloadUpdater, stateMachine.getSubscribedEventSchemasForPayloadUpdating(), stateMachine);
        this.addToSchemaRegistry((Map<String, List<StateMachineInterface>>)this.eventSchemaToAfterTrackCallback, stateMachine.getSubscribedEventSchemasForAfterTrackCallback(), stateMachine);
        this.addToSchemaRegistry((Map<String, List<StateMachineInterface>>)this.eventSchemaToFilter, stateMachine.getSubscribedEventSchemasForFiltering(), stateMachine);
    }

    public final synchronized boolean removeStateMachine(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        StateMachineInterface stateMachineInterface = this.identifierToStateMachine.remove(identifier);
        if (stateMachineInterface == null) {
            return false;
        }
        StateMachineInterface stateMachine = stateMachineInterface;
        this.stateMachineToIdentifier.remove(stateMachine);
        this.trackerState.removeState(identifier);
        this.removeFromSchemaRegistry((Map<String, ? extends List<StateMachineInterface>>)this.eventSchemaToStateMachine, stateMachine.getSubscribedEventSchemasForTransitions(), stateMachine);
        this.removeFromSchemaRegistry((Map<String, ? extends List<StateMachineInterface>>)this.eventSchemaToEntitiesGenerator, stateMachine.getSubscribedEventSchemasForEntitiesGeneration(), stateMachine);
        this.removeFromSchemaRegistry((Map<String, ? extends List<StateMachineInterface>>)this.eventSchemaToPayloadUpdater, stateMachine.getSubscribedEventSchemasForPayloadUpdating(), stateMachine);
        this.removeFromSchemaRegistry((Map<String, ? extends List<StateMachineInterface>>)this.eventSchemaToAfterTrackCallback, stateMachine.getSubscribedEventSchemasForAfterTrackCallback(), stateMachine);
        this.removeFromSchemaRegistry((Map<String, ? extends List<StateMachineInterface>>)this.eventSchemaToFilter, stateMachine.getSubscribedEventSchemasForFiltering(), stateMachine);
        return true;
    }

    @NotNull
    public final synchronized TrackerStateSnapshot trackerStateForProcessedEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof AbstractSelfDescribing) {
            List<StateMachineInterface> it;
            List stateMachines = new LinkedList();
            List<StateMachineInterface> list = this.eventSchemaToStateMachine.get(((AbstractSelfDescribing)event).getSchema());
            if (list != null) {
                it = list;
                boolean bl = false;
                stateMachines.addAll((Collection)it);
            }
            List<StateMachineInterface> list2 = this.eventSchemaToStateMachine.get("*");
            if (list2 != null) {
                it = list2;
                boolean bl = false;
                stateMachines.addAll((Collection)it);
            }
            for (StateMachineInterface stateMachine : stateMachines) {
                StateFuture stateFuture;
                String stateIdentifier = this.stateMachineToIdentifier.get(stateMachine);
                if (stateIdentifier != null) {
                    String it2;
                    boolean bl = false;
                    stateFuture = this.trackerState.getStateFuture(it2);
                } else {
                    stateFuture = null;
                }
                StateFuture previousStateFuture = stateFuture;
                StateFuture currentStateFuture = new StateFuture(event, previousStateFuture, stateMachine);
                if (stateIdentifier != null) {
                    String it3;
                    boolean bl = false;
                    this.trackerState.put(it3, currentStateFuture);
                }
                currentStateFuture.state();
            }
        }
        return this.trackerState.getSnapshot();
    }

    @NotNull
    public final synchronized List<SelfDescribingJson> entitiesForProcessedEvent(@NotNull StateMachineEvent event) {
        List<StateMachineInterface> it;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = event.getSchema();
        if (string == null) {
            string = event.getName();
        }
        String schema = string;
        List result = new LinkedList();
        List stateMachines = new LinkedList();
        List<StateMachineInterface> list = (List<StateMachineInterface>)((Map)this.eventSchemaToEntitiesGenerator).get(schema);
        if (list != null) {
            it = list;
            boolean bl = false;
            stateMachines.addAll((Collection)it);
        }
        List<StateMachineInterface> list2 = this.eventSchemaToEntitiesGenerator.get("*");
        if (list2 != null) {
            it = list2;
            boolean bl = false;
            stateMachines.addAll((Collection)it);
        }
        for (StateMachineInterface stateMachine : stateMachines) {
            List<SelfDescribingJson> entities;
            String stateIdentifier;
            if (this.stateMachineToIdentifier.get(stateMachine) == null) continue;
            boolean bl = false;
            State state = event.getState().getState(stateIdentifier);
            if (stateMachine.entities(event, state) == null) continue;
            boolean bl2 = false;
            result.addAll((Collection)entities);
        }
        return result;
    }

    public final synchronized boolean addPayloadValuesToEvent(@NotNull StateMachineEvent event) {
        List<StateMachineInterface> it;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        int failures = 0;
        List stateMachines = new LinkedList();
        List<StateMachineInterface> list = (List<StateMachineInterface>)((Map)this.eventSchemaToPayloadUpdater).get(event.getSchema());
        if (list != null) {
            it = list;
            boolean bl = false;
            stateMachines.addAll((Collection)it);
        }
        List<StateMachineInterface> list2 = this.eventSchemaToPayloadUpdater.get("*");
        if (list2 != null) {
            it = list2;
            boolean bl = false;
            stateMachines.addAll((Collection)it);
        }
        for (StateMachineInterface stateMachine : stateMachines) {
            Map<String, Object> payloadValues;
            String stateIdentifier;
            if (this.stateMachineToIdentifier.get(stateMachine) == null) continue;
            boolean bl = false;
            State state = event.getState().getState(stateIdentifier);
            if (stateMachine.payloadValues(event, state) == null) continue;
            boolean bl2 = false;
            if (event.addPayloadValues(payloadValues)) continue;
            ++failures;
        }
        return failures == 0;
    }

    public final synchronized void afterTrack(@NotNull StateMachineEvent event) {
        List<StateMachineInterface> it;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = event.getSchema();
        if (string == null) {
            string = event.getName();
        }
        String schema = string;
        List stateMachines = new LinkedList();
        List<StateMachineInterface> list = (List<StateMachineInterface>)((Map)this.eventSchemaToAfterTrackCallback).get(schema);
        if (list != null) {
            it = list;
            boolean bl = false;
            stateMachines.addAll((Collection)it);
        }
        List<StateMachineInterface> list2 = this.eventSchemaToAfterTrackCallback.get("*");
        if (list2 != null) {
            it = list2;
            boolean bl = false;
            stateMachines.addAll((Collection)it);
        }
        if (!((Collection)stateMachines).isEmpty()) {
            Executor.execute(TAG, () -> StateManager.afterTrack$lambda$14(stateMachines, event));
        }
    }

    public final synchronized boolean filter(@NotNull StateMachineEvent event) {
        List<StateMachineInterface> it;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = event.getSchema();
        if (string == null) {
            string = event.getName();
        }
        String schema = string;
        List stateMachines = new LinkedList();
        List<StateMachineInterface> list = (List<StateMachineInterface>)((Map)this.eventSchemaToFilter).get(schema);
        if (list != null) {
            it = list;
            boolean bl = false;
            stateMachines.addAll((Collection)it);
        }
        List<StateMachineInterface> list2 = this.eventSchemaToFilter.get("*");
        if (list2 != null) {
            it = list2;
            boolean bl = false;
            stateMachines.addAll((Collection)it);
        }
        for (StateMachineInterface stateMachine : stateMachines) {
            String stateIdentifier;
            if (this.stateMachineToIdentifier.get(stateMachine) == null) continue;
            boolean bl = false;
            State state = event.getState().getState(stateIdentifier);
            if (!Intrinsics.areEqual((Object)stateMachine.filter(event, state), (Object)false)) continue;
            return false;
        }
        return true;
    }

    private final void addToSchemaRegistry(Map<String, List<StateMachineInterface>> schemaRegistry, List<String> schemas, StateMachineInterface stateMachine) {
        for (String eventSchema : schemas) {
            List list = schemaRegistry.get(eventSchema);
            if (list == null) {
                list = new LinkedList();
                schemaRegistry.put(eventSchema, list);
            }
            list.add((StateMachineInterface)stateMachine);
        }
    }

    private final void removeFromSchemaRegistry(Map<String, ? extends List<StateMachineInterface>> schemaRegistry, List<String> schemas, StateMachineInterface stateMachine) {
        for (String eventSchema : schemas) {
            List<StateMachineInterface> list;
            List<StateMachineInterface> list2 = list = schemaRegistry.get(eventSchema);
            if (list2 == null) continue;
            list2.remove(stateMachine);
        }
    }

    private static final void afterTrack$lambda$14(List $stateMachines, StateMachineEvent $event) {
        Intrinsics.checkNotNullParameter((Object)$stateMachines, (String)"$stateMachines");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        for (StateMachineInterface stateMachine : $stateMachines) {
            stateMachine.afterTrack($event);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/snowplowanalytics/core/statemachine/StateManager$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "snowplow-android-tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

