/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.session;

import androidx.annotation.RestrictTo;
import androidx.core.util.Consumer;
import com.snowplowanalytics.core.Controller;
import com.snowplowanalytics.core.session.Session;
import com.snowplowanalytics.core.tracker.Logger;
import com.snowplowanalytics.core.tracker.ServiceProviderInterface;
import com.snowplowanalytics.core.tracker.Tracker;
import com.snowplowanalytics.snowplow.configuration.SessionConfiguration;
import com.snowplowanalytics.snowplow.controller.SessionController;
import com.snowplowanalytics.snowplow.tracker.SessionState;
import com.snowplowanalytics.snowplow.util.TimeMeasure;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u000208H\u0016J\b\u0010:\u001a\u000208H\u0016R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR$\u0010\r\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\fR$\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u0010\"\u0004\b\u001b\u0010\u0012R\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001eR4\u0010 \u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0016\u0010'\u001a\u0004\u0018\u00010(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0016\u0010+\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0016\u0010.\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0014\u00101\u001a\u0002028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0014\u00105\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010-\u00a8\u0006;"}, d2={"Lcom/snowplowanalytics/core/session/SessionControllerImpl;", "Lcom/snowplowanalytics/core/Controller;", "Lcom/snowplowanalytics/snowplow/controller/SessionController;", "serviceProvider", "Lcom/snowplowanalytics/core/tracker/ServiceProviderInterface;", "(Lcom/snowplowanalytics/core/tracker/ServiceProviderInterface;)V", "TAG", "", "kotlin.jvm.PlatformType", "backgroundIndex", "", "getBackgroundIndex", "()I", "backgroundTimeout", "Lcom/snowplowanalytics/snowplow/util/TimeMeasure;", "getBackgroundTimeout", "()Lcom/snowplowanalytics/snowplow/util/TimeMeasure;", "setBackgroundTimeout", "(Lcom/snowplowanalytics/snowplow/util/TimeMeasure;)V", "dirtyConfig", "Lcom/snowplowanalytics/snowplow/configuration/SessionConfiguration;", "getDirtyConfig", "()Lcom/snowplowanalytics/snowplow/configuration/SessionConfiguration;", "foregroundIndex", "getForegroundIndex", "foregroundTimeout", "getForegroundTimeout", "setForegroundTimeout", "isEnabled", "", "()Z", "isInBackground", "onSessionUpdate", "Landroidx/core/util/Consumer;", "Lcom/snowplowanalytics/snowplow/tracker/SessionState;", "getOnSessionUpdate", "()Landroidx/core/util/Consumer;", "setOnSessionUpdate", "(Landroidx/core/util/Consumer;)V", "session", "Lcom/snowplowanalytics/core/session/Session;", "getSession", "()Lcom/snowplowanalytics/core/session/Session;", "sessionId", "getSessionId", "()Ljava/lang/String;", "sessionIndex", "getSessionIndex", "()Ljava/lang/Integer;", "tracker", "Lcom/snowplowanalytics/core/tracker/Tracker;", "getTracker", "()Lcom/snowplowanalytics/core/tracker/Tracker;", "userId", "getUserId", "pause", "", "resume", "startNewSession", "snowplow-android-tracker_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class SessionControllerImpl
extends Controller
implements SessionController {
    private final String TAG;

    public SessionControllerImpl(@NotNull ServiceProviderInterface serviceProvider) {
        Intrinsics.checkNotNullParameter((Object)serviceProvider, (String)"serviceProvider");
        super(serviceProvider);
        this.TAG = SessionControllerImpl.class.getName();
    }

    @Override
    public void pause() {
        this.getDirtyConfig().setPaused$snowplow_android_tracker_release(true);
        this.getTracker().pauseSessionChecking();
    }

    @Override
    public void resume() {
        this.getDirtyConfig().setPaused$snowplow_android_tracker_release(false);
        this.getTracker().resumeSessionChecking();
    }

    @Override
    public void startNewSession() {
        Session session = this.getSession();
        if (session == null) {
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.track(string, "Attempt to access SessionController fields when disabled", new Object[0]);
            return;
        }
        session.startNewSession();
    }

    @Override
    @Nullable
    public Integer getSessionIndex() {
        Session session = this.getSession();
        if (session == null) {
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.track(string, "Attempt to access SessionController fields when disabled", new Object[0]);
            return -1;
        }
        return session.getSessionIndex();
    }

    @Override
    @Nullable
    public String getSessionId() {
        Session session = this.getSession();
        if (session == null) {
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.track(string, "Attempt to access SessionController fields when disabled", new Object[0]);
            return "";
        }
        SessionState sessionState = session.getState();
        return sessionState != null ? sessionState.getSessionId() : null;
    }

    @Override
    @NotNull
    public String getUserId() {
        Session session = this.getSession();
        if (session == null) {
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.track(string, "Attempt to access SessionController fields when disabled", new Object[0]);
            return "";
        }
        return session.getUserId();
    }

    @Override
    public boolean isInBackground() {
        Session session = this.getSession();
        if (session == null) {
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.track(string, "Attempt to access SessionController fields when disabled", new Object[0]);
            return false;
        }
        return session.isBackground();
    }

    @Override
    public int getBackgroundIndex() {
        Session session = this.getSession();
        if (session == null) {
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.track(string, "Attempt to access SessionController fields when disabled", new Object[0]);
            return -1;
        }
        return session.getBackgroundIndex();
    }

    @Override
    public int getForegroundIndex() {
        Session session = this.getSession();
        if (session == null) {
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.track(string, "Attempt to access SessionController fields when disabled", new Object[0]);
            return -1;
        }
        return session.getForegroundIndex();
    }

    @Override
    @NotNull
    public TimeMeasure getForegroundTimeout() {
        Session session = this.getSession();
        if (session == null) {
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.track(string, "Attempt to access SessionController fields when disabled", new Object[0]);
            return new TimeMeasure(0L, TimeUnit.SECONDS);
        }
        return new TimeMeasure(session.getForegroundTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void setForegroundTimeout(@NotNull TimeMeasure foregroundTimeout) {
        Intrinsics.checkNotNullParameter((Object)foregroundTimeout, (String)"foregroundTimeout");
        Session session = this.getSession();
        if (session == null) {
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.track(string, "Attempt to access SessionController fields when disabled", new Object[0]);
            return;
        }
        this.getDirtyConfig().setForegroundTimeout(foregroundTimeout);
        session.setForegroundTimeout(foregroundTimeout.convert(TimeUnit.MILLISECONDS));
    }

    @Override
    @NotNull
    public TimeMeasure getBackgroundTimeout() {
        Session session = this.getSession();
        if (session == null) {
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.track(string, "Attempt to access SessionController fields when disabled", new Object[0]);
            return new TimeMeasure(0L, TimeUnit.SECONDS);
        }
        return new TimeMeasure(session.getBackgroundTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void setBackgroundTimeout(@NotNull TimeMeasure backgroundTimeout) {
        Intrinsics.checkNotNullParameter((Object)backgroundTimeout, (String)"backgroundTimeout");
        Session session = this.getSession();
        if (session == null) {
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.track(string, "Attempt to access SessionController fields when disabled", new Object[0]);
            return;
        }
        this.getDirtyConfig().setBackgroundTimeout(backgroundTimeout);
        session.setBackgroundTimeout(backgroundTimeout.convert(TimeUnit.MILLISECONDS));
    }

    @Override
    @Nullable
    public Consumer<SessionState> getOnSessionUpdate() {
        Session session = this.getSession();
        if (session == null) {
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.track(string, "Attempt to access SessionController fields when disabled", new Object[0]);
            return null;
        }
        return session.getOnSessionUpdate();
    }

    @Override
    public void setOnSessionUpdate(@Nullable Consumer<SessionState> onSessionUpdate) {
        Session session = this.getSession();
        if (session == null) {
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.track(string, "Attempt to access SessionController fields when disabled", new Object[0]);
            return;
        }
        this.getDirtyConfig().setOnSessionUpdate(onSessionUpdate);
        session.setOnSessionUpdate(onSessionUpdate);
    }

    public final boolean isEnabled() {
        return this.getTracker().getSession() != null;
    }

    private final Tracker getTracker() {
        return this.getServiceProvider().getOrMakeTracker();
    }

    private final Session getSession() {
        return this.getServiceProvider().getOrMakeTracker().getSession();
    }

    private final SessionConfiguration getDirtyConfig() {
        return this.getServiceProvider().getSessionConfiguration();
    }
}

