/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.session;

import android.content.Context;
import android.os.Handler;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.snowplowanalytics.core.tracker.Logger;
import com.snowplowanalytics.core.utils.NotificationCenter;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \b2\u00020\u0001:\u0002\b\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/snowplowanalytics/core/session/ProcessObserver;", "Landroidx/lifecycle/DefaultLifecycleObserver;", "()V", "onStart", "", "owner", "Landroidx/lifecycle/LifecycleOwner;", "onStop", "Companion", "InitializationState", "snowplow-android-tracker_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ProcessObserver
implements DefaultLifecycleObserver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final String TAG = ProcessObserver.class.getSimpleName();
    @NotNull
    private static InitializationState initializationState = InitializationState.NONE;

    private ProcessObserver() {
    }

    public void onStart(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super.onStart(owner);
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Logger.d(string, "App enter foreground", new Object[0]);
        try {
            Map notificationData = new HashMap();
            notificationData.put("isForeground", true);
            NotificationCenter.postNotification("SnowplowLifecycleTracking", notificationData);
        }
        catch (Exception e) {
            String string2 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
            Object[] objectArray = new Object[]{e};
            Logger.e(string2, "Method onEnterForeground raised an exception: %s", objectArray);
        }
    }

    public void onStop(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super.onStop(owner);
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Logger.d(string, "App enter background", new Object[0]);
        try {
            Map notificationData = new HashMap();
            notificationData.put("isForeground", false);
            NotificationCenter.postNotification("SnowplowLifecycleTracking", notificationData);
        }
        catch (Exception e) {
            String string2 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
            Object[] objectArray = new Object[]{e};
            Logger.e(string2, "Method onEnterBackground raised an exception: %s", objectArray);
        }
    }

    @JvmStatic
    public static final synchronized void initialize(@NotNull Context context) {
        Companion.initialize(context);
    }

    public /* synthetic */ ProcessObserver(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/snowplowanalytics/core/session/ProcessObserver$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "initializationState", "Lcom/snowplowanalytics/core/session/ProcessObserver$InitializationState;", "initialize", "", "context", "Landroid/content/Context;", "snowplow-android-tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final synchronized void initialize(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (initializationState == InitializationState.NONE) {
                ProcessObserver.initializationState = InitializationState.IN_PROGRESS;
                Handler mainHandler = new Handler(context.getMainLooper());
                mainHandler.post(Companion::initialize$lambda$0);
            }
        }

        private static final void initialize$lambda$0() {
            try {
                ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)new ProcessObserver(null));
                ProcessObserver.initializationState = InitializationState.COMPLETE;
            }
            catch (NoClassDefFoundError e) {
                ProcessObserver.initializationState = InitializationState.NONE;
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Logger.e(string, "Class 'ProcessLifecycleOwner' not found. The tracker can't track lifecycle events.", new Object[0]);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/snowplowanalytics/core/session/ProcessObserver$InitializationState;", "", "(Ljava/lang/String;I)V", "NONE", "IN_PROGRESS", "COMPLETE", "snowplow-android-tracker_release"})
    private static final class InitializationState
    extends Enum<InitializationState> {
        public static final /* enum */ InitializationState NONE = new InitializationState();
        public static final /* enum */ InitializationState IN_PROGRESS = new InitializationState();
        public static final /* enum */ InitializationState COMPLETE = new InitializationState();
        private static final /* synthetic */ InitializationState[] $VALUES;

        public static InitializationState[] values() {
            return (InitializationState[])$VALUES.clone();
        }

        public static InitializationState valueOf(String value) {
            return Enum.valueOf(InitializationState.class, value);
        }

        static {
            $VALUES = initializationStateArray = new InitializationState[]{InitializationState.NONE, InitializationState.IN_PROGRESS, InitializationState.COMPLETE};
        }
    }
}

