/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.emitter.storage;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import androidx.annotation.RestrictTo;
import com.snowplowanalytics.core.tracker.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/snowplowanalytics/core/emitter/storage/EventStoreHelper;", "Landroid/database/sqlite/SQLiteOpenHelper;", "context", "Landroid/content/Context;", "databaseName", "", "(Landroid/content/Context;Ljava/lang/String;)V", "onCreate", "", "database", "Landroid/database/sqlite/SQLiteDatabase;", "onUpgrade", "oldVersion", "", "newVersion", "Companion", "snowplow-android-tracker_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class EventStoreHelper
extends SQLiteOpenHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TABLE_EVENTS = "events";
    @NotNull
    public static final String COLUMN_ID = "id";
    @NotNull
    public static final String COLUMN_EVENT_DATA = "eventData";
    @NotNull
    public static final String COLUMN_DATE_CREATED = "dateCreated";
    @NotNull
    public static final String METADATA_ID = "id";
    @NotNull
    public static final String METADATA_EVENT_DATA = "eventData";
    @NotNull
    public static final String METADATA_DATE_CREATED = "dateCreated";
    @NotNull
    private static final String DATABASE_NAME = "snowplowEvents";
    private static final String TAG = EventStoreHelper.class.getName();
    private static final int DATABASE_VERSION = 1;
    @NotNull
    private static final String queryDropTable = "DROP TABLE IF EXISTS 'events'";
    @NotNull
    private static final String queryCreateTable = "CREATE TABLE IF NOT EXISTS 'events' (id INTEGER PRIMARY KEY, eventData BLOB, dateCreated TIMESTAMP DEFAULT CURRENT_TIMESTAMP)";
    @NotNull
    private static final HashMap<String, EventStoreHelper> instances = new HashMap();

    private EventStoreHelper(Context context, String databaseName) {
        super(context, databaseName, null, 1);
    }

    public void onCreate(@NotNull SQLiteDatabase database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        database.execSQL(queryCreateTable);
    }

    public void onUpgrade(@NotNull SQLiteDatabase database, int oldVersion, int newVersion) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Logger.d(string, "Upgrade not implemented, resetting database...", new Object[0]);
        database.execSQL(queryDropTable);
        this.onCreate(database);
    }

    @JvmStatic
    @NotNull
    public static final synchronized List<String> removeUnsentEventsExceptForNamespaces(@NotNull Context context, @Nullable List<String> allowedNamespaces) {
        return Companion.removeUnsentEventsExceptForNamespaces(context, allowedNamespaces);
    }

    @JvmStatic
    @NotNull
    public static final synchronized EventStoreHelper getInstance(@NotNull Context context, @NotNull String namespace) {
        return Companion.getInstance(context, namespace);
    }

    public /* synthetic */ EventStoreHelper(Context context, String databaseName, DefaultConstructorMarker $constructor_marker) {
        this(context, databaseName);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0019\u001a\u00020\u0004J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001cH\u0007J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u000f*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00120\u0011j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/snowplowanalytics/core/emitter/storage/EventStoreHelper$Companion;", "", "()V", "COLUMN_DATE_CREATED", "", "COLUMN_EVENT_DATA", "COLUMN_ID", "DATABASE_NAME", "DATABASE_VERSION", "", "METADATA_DATE_CREATED", "METADATA_EVENT_DATA", "METADATA_ID", "TABLE_EVENTS", "TAG", "kotlin.jvm.PlatformType", "instances", "Ljava/util/HashMap;", "Lcom/snowplowanalytics/core/emitter/storage/EventStoreHelper;", "Lkotlin/collections/HashMap;", "queryCreateTable", "queryDropTable", "getInstance", "context", "Landroid/content/Context;", "namespace", "removeInstance", "removeUnsentEventsExceptForNamespaces", "", "allowedNamespaces", "renameLegacyDatabase", "", "newDatabaseFilename", "snowplow-android-tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final synchronized List<String> removeUnsentEventsExceptForNamespaces(@NotNull Context context, @Nullable List<String> allowedNamespaces) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            List allowedNamespaces2 = allowedNamespaces;
            if (allowedNamespaces2 == null) {
                allowedNamespaces2 = new ArrayList();
            }
            String[] stringArray = context.databaseList();
            if (stringArray == null) {
                return new ArrayList();
            }
            String[] databaseList = stringArray;
            List allowedDbFiles = new ArrayList(allowedNamespaces2.size());
            for (String namespace : allowedNamespaces2) {
                CharSequence charSequence = namespace;
                Regex regex = new Regex("[^a-zA-Z0-9_]+");
                String string = "-";
                String sqliteSuffix = regex.replace(charSequence, string);
                String dbName = "snowplowEvents-" + sqliteSuffix + ".sqlite";
                allowedDbFiles.add(dbName);
                allowedDbFiles.add(dbName + "-wal");
                allowedDbFiles.add(dbName + "-shm");
            }
            List removedDbFiles = new ArrayList();
            for (String dbName : databaseList) {
                Intrinsics.checkNotNullExpressionValue((Object)dbName, (String)"dbName");
                if (!StringsKt.startsWith$default((String)dbName, (String)EventStoreHelper.DATABASE_NAME, (boolean)false, (int)2, null) || allowedDbFiles.contains(dbName) || !context.deleteDatabase(dbName)) continue;
                removedDbFiles.add(dbName);
            }
            return removedDbFiles;
        }

        @JvmStatic
        @NotNull
        public final synchronized EventStoreHelper getInstance(@NotNull Context context, @NotNull String namespace) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            if (instances.containsKey(namespace)) {
                Object v = instances.get(namespace);
                Intrinsics.checkNotNull(v);
                return (EventStoreHelper)((Object)v);
            }
            CharSequence charSequence = namespace;
            Regex regex = new Regex("[^a-zA-Z0-9_]+");
            String string = "-";
            String sqliteSuffix = regex.replace(charSequence, string);
            String dbName = "snowplowEvents-" + sqliteSuffix + ".sqlite";
            this.renameLegacyDatabase(context, dbName);
            Context context2 = context.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
            EventStoreHelper eventStoreHelper = new EventStoreHelper(context2, dbName, null);
            ((Map)instances).put(namespace, eventStoreHelper);
            return eventStoreHelper;
        }

        @Nullable
        public final synchronized EventStoreHelper removeInstance(@NotNull String namespace) {
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            return (EventStoreHelper)((Object)instances.remove(namespace));
        }

        private final boolean renameLegacyDatabase(Context context, String newDatabaseFilename) {
            File database = context.getDatabasePath("snowplowEvents.sqlite");
            File databaseWal = context.getDatabasePath("snowplowEvents.sqlite-wal");
            File databaseShm = context.getDatabasePath("snowplowEvents.sqlite-shm");
            File parentFile = database.getParentFile();
            File newDatabase = new File(parentFile, newDatabaseFilename);
            File newDatabaseWal = new File(parentFile, newDatabaseFilename + "-wal");
            File newDatabaseShm = new File(parentFile, newDatabaseFilename + "-shm");
            return database.renameTo(newDatabase) && databaseWal.renameTo(newDatabaseWal) && databaseShm.renameTo(newDatabaseShm);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

