/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.emitter;

import androidx.annotation.RestrictTo;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\rH\u0016J(\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0013\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/snowplowanalytics/core/emitter/TLSSocketFactory;", "Ljavax/net/ssl/SSLSocketFactory;", "versions", "", "", "([Ljava/lang/String;)V", "internalSSLSocketFactory", "[Ljava/lang/String;", "createSocket", "Ljava/net/Socket;", "host", "Ljava/net/InetAddress;", "port", "", "address", "localAddress", "localPort", "s", "autoClose", "", "localHost", "enableTLSOnSocket", "socket", "getDefaultCipherSuites", "()[Ljava/lang/String;", "getSupportedCipherSuites", "snowplow-android-tracker_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class TLSSocketFactory
extends SSLSocketFactory {
    @NotNull
    private final String[] versions;
    @NotNull
    private final SSLSocketFactory internalSSLSocketFactory;

    public TLSSocketFactory(@NotNull String[] versions) {
        Intrinsics.checkNotNullParameter((Object)versions, (String)"versions");
        this.versions = versions;
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, null, null);
        SSLSocketFactory sSLSocketFactory = context.getSocketFactory();
        Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"context.socketFactory");
        this.internalSSLSocketFactory = sSLSocketFactory;
    }

    @Override
    @NotNull
    public String[] getDefaultCipherSuites() {
        String[] stringArray = this.internalSSLSocketFactory.getDefaultCipherSuites();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"internalSSLSocketFactory.defaultCipherSuites");
        return stringArray;
    }

    @Override
    @NotNull
    public String[] getSupportedCipherSuites() {
        String[] stringArray = this.internalSSLSocketFactory.getSupportedCipherSuites();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"internalSSLSocketFactory.supportedCipherSuites");
        return stringArray;
    }

    @Override
    @NotNull
    public Socket createSocket() throws IOException {
        Socket socket = this.internalSSLSocketFactory.createSocket();
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"internalSSLSocketFactory.createSocket()");
        return this.enableTLSOnSocket(socket);
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull Socket s, @NotNull String host, int port, boolean autoClose) throws IOException {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Socket socket = this.internalSSLSocketFactory.createSocket(s, host, port, autoClose);
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"internalSSLSocketFactory\u2026s, host, port, autoClose)");
        return this.enableTLSOnSocket(socket);
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull String host, int port) throws IOException, UnknownHostException {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Socket socket = this.internalSSLSocketFactory.createSocket(host, port);
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"internalSSLSocketFactory.createSocket(host, port)");
        return this.enableTLSOnSocket(socket);
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull String host, int port, @NotNull InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)localHost, (String)"localHost");
        Socket socket = this.internalSSLSocketFactory.createSocket(host, port, localHost, localPort);
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"internalSSLSocketFactory\u2026  localPort\n            )");
        return this.enableTLSOnSocket(socket);
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull InetAddress host, int port) throws IOException {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Socket socket = this.internalSSLSocketFactory.createSocket(host, port);
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"internalSSLSocketFactory.createSocket(host, port)");
        return this.enableTLSOnSocket(socket);
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull InetAddress address, int port, @NotNull InetAddress localAddress, int localPort) throws IOException {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)localAddress, (String)"localAddress");
        Socket socket = this.internalSSLSocketFactory.createSocket(address, port, localAddress, localPort);
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"internalSSLSocketFactory\u2026  localPort\n            )");
        return this.enableTLSOnSocket(socket);
    }

    private final Socket enableTLSOnSocket(Socket socket) {
        if (socket instanceof SSLSocket) {
            ((SSLSocket)socket).setEnabledProtocols(this.versions);
        }
        return socket;
    }
}

