/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.emitter;

import androidx.annotation.RestrictTo;
import com.snowplowanalytics.core.emitter.TLSSocketFactory;
import com.snowplowanalytics.core.emitter.TLSVersion;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/snowplowanalytics/core/emitter/TLSArguments;", "", "tlsVersions", "Ljava/util/EnumSet;", "Lcom/snowplowanalytics/core/emitter/TLSVersion;", "(Ljava/util/EnumSet;)V", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "getSslSocketFactory", "()Ljavax/net/ssl/SSLSocketFactory;", "setSslSocketFactory", "(Ljavax/net/ssl/SSLSocketFactory;)V", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "getTrustManager", "()Ljavax/net/ssl/X509TrustManager;", "setTrustManager", "(Ljavax/net/ssl/X509TrustManager;)V", "versions", "", "", "getVersions", "()[Ljava/lang/String;", "snowplow-android-tracker_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class TLSArguments {
    @NotNull
    private final EnumSet<TLSVersion> tlsVersions;
    public X509TrustManager trustManager;
    public SSLSocketFactory sslSocketFactory;

    public TLSArguments(@NotNull EnumSet<TLSVersion> tlsVersions) {
        Intrinsics.checkNotNullParameter(tlsVersions, (String)"tlsVersions");
        this.tlsVersions = tlsVersions;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (!(trustManagers.length == 1 && trustManagers[0] instanceof X509TrustManager)) {
                boolean bl = false;
                String string = "Unexpected default trust managers:" + Arrays.toString(trustManagers);
                throw new IllegalStateException(string.toString());
            }
            TrustManager trustManager = trustManagers[0];
            Intrinsics.checkNotNull((Object)trustManager, (String)"null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
            this.setTrustManager((X509TrustManager)trustManager);
            this.setSslSocketFactory(new TLSSocketFactory(this.getVersions()));
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public final X509TrustManager getTrustManager() {
        X509TrustManager x509TrustManager = this.trustManager;
        if (x509TrustManager != null) {
            return x509TrustManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"trustManager");
        return null;
    }

    public final void setTrustManager(@NotNull X509TrustManager x509TrustManager) {
        Intrinsics.checkNotNullParameter((Object)x509TrustManager, (String)"<set-?>");
        this.trustManager = x509TrustManager;
    }

    @NotNull
    public final SSLSocketFactory getSslSocketFactory() {
        SSLSocketFactory sSLSocketFactory = this.sslSocketFactory;
        if (sSLSocketFactory != null) {
            return sSLSocketFactory;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"sslSocketFactory");
        return null;
    }

    public final void setSslSocketFactory(@NotNull SSLSocketFactory sSLSocketFactory) {
        Intrinsics.checkNotNullParameter((Object)sSLSocketFactory, (String)"<set-?>");
        this.sslSocketFactory = sSLSocketFactory;
    }

    @NotNull
    public final String[] getVersions() {
        String[] acceptedVersions = new String[this.tlsVersions.size()];
        Iterator iterator = this.tlsVersions.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            TLSVersion version = (TLSVersion)((Object)iterator.next());
            acceptedVersions[i] = version.toString();
        }
        return acceptedVersions;
    }
}

