/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.emitter;

import androidx.annotation.RestrictTo;
import com.snowplowanalytics.core.Controller;
import com.snowplowanalytics.core.emitter.Emitter;
import com.snowplowanalytics.core.tracker.ServiceProviderInterface;
import com.snowplowanalytics.snowplow.configuration.NetworkConfiguration;
import com.snowplowanalytics.snowplow.controller.NetworkController;
import com.snowplowanalytics.snowplow.network.HttpMethod;
import com.snowplowanalytics.snowplow.network.NetworkConnection;
import com.snowplowanalytics.snowplow.network.OkHttpNetworkConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR(\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\r\"\u0004\b\u001a\u0010\u000fR$\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R(\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010!\u001a\u0004\u0018\u00010\"8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lcom/snowplowanalytics/core/emitter/NetworkControllerImpl;", "Lcom/snowplowanalytics/core/Controller;", "Lcom/snowplowanalytics/snowplow/controller/NetworkController;", "serviceProvider", "Lcom/snowplowanalytics/core/tracker/ServiceProviderInterface;", "(Lcom/snowplowanalytics/core/tracker/ServiceProviderInterface;)V", "customNetworkConnection", "", "getCustomNetworkConnection", "()Z", "customPostPath", "", "getCustomPostPath", "()Ljava/lang/String;", "setCustomPostPath", "(Ljava/lang/String;)V", "dirtyConfig", "Lcom/snowplowanalytics/snowplow/configuration/NetworkConfiguration;", "getDirtyConfig", "()Lcom/snowplowanalytics/snowplow/configuration/NetworkConfiguration;", "emitter", "Lcom/snowplowanalytics/core/emitter/Emitter;", "getEmitter", "()Lcom/snowplowanalytics/core/emitter/Emitter;", "endpoint", "getEndpoint", "setEndpoint", "method", "Lcom/snowplowanalytics/snowplow/network/HttpMethod;", "getMethod", "()Lcom/snowplowanalytics/snowplow/network/HttpMethod;", "setMethod", "(Lcom/snowplowanalytics/snowplow/network/HttpMethod;)V", "timeout", "", "getTimeout", "()Ljava/lang/Integer;", "setTimeout", "(Ljava/lang/Integer;)V", "snowplow-android-tracker_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class NetworkControllerImpl
extends Controller
implements NetworkController {
    public NetworkControllerImpl(@NotNull ServiceProviderInterface serviceProvider) {
        Intrinsics.checkNotNullParameter((Object)serviceProvider, (String)"serviceProvider");
        super(serviceProvider);
    }

    public final boolean getCustomNetworkConnection() {
        NetworkConnection networkConnection = this.getEmitter().getNetworkConnection();
        return networkConnection != null && !(networkConnection instanceof OkHttpNetworkConnection);
    }

    @Override
    @NotNull
    public String getEndpoint() {
        return this.getEmitter().getEmitterUri();
    }

    @Override
    public void setEndpoint(@NotNull String endpoint) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        this.getEmitter().setEmitterUri(endpoint);
    }

    @Override
    @NotNull
    public HttpMethod getMethod() {
        return this.getEmitter().getHttpMethod();
    }

    @Override
    public void setMethod(@NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        this.getEmitter().setHttpMethod(method);
    }

    @Override
    @Nullable
    public String getCustomPostPath() {
        return this.getEmitter().getCustomPostPath();
    }

    @Override
    public void setCustomPostPath(@Nullable String customPostPath) {
        this.getDirtyConfig().setCustomPostPath(customPostPath);
        this.getEmitter().setCustomPostPath(customPostPath);
    }

    @Override
    @Nullable
    public Integer getTimeout() {
        return this.getEmitter().getEmitTimeout();
    }

    @Override
    public void setTimeout(@Nullable Integer timeout) {
        this.getEmitter().setEmitTimeout(timeout);
    }

    private final Emitter getEmitter() {
        return this.getServiceProvider().getOrMakeEmitter();
    }

    private final NetworkConfiguration getDirtyConfig() {
        return this.getServiceProvider().getNetworkConfiguration();
    }
}

