/*
 * Decompiled with CFR 0.152.
 */
package com.smartystreets.api.us_zipcode;

import com.smartystreets.api.Credentials;
import com.smartystreets.api.GoogleSender;
import com.smartystreets.api.GoogleSerializer;
import com.smartystreets.api.RetrySender;
import com.smartystreets.api.Sender;
import com.smartystreets.api.Serializer;
import com.smartystreets.api.SigningSender;
import com.smartystreets.api.StaticCredentials;
import com.smartystreets.api.StatusCodeSender;
import com.smartystreets.api.us_zipcode.Client;

public class ClientBuilder {
    private Credentials signer;
    private Serializer serializer = new GoogleSerializer();
    private Sender httpSender;
    private int maxRetries = 5;
    private int maxTimeout = 10000;
    private String urlPrefix = "https://us-zipcode.api.smartystreets.com/lookup";

    ClientBuilder() {
    }

    public ClientBuilder(Credentials signer) {
        this();
        this.signer = signer;
    }

    public ClientBuilder(String authId, String authToken) {
        this(new StaticCredentials(authId, authToken));
    }

    public ClientBuilder retryAtMost(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public ClientBuilder withMaxTimeout(int maxTimeout) {
        this.maxTimeout = maxTimeout;
        return this;
    }

    public ClientBuilder withSender(Sender sender) {
        this.httpSender = sender;
        return this;
    }

    public ClientBuilder withSerializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public ClientBuilder withUrl(String urlPrefix) {
        this.urlPrefix = urlPrefix;
        return this;
    }

    public Client build() {
        return new Client(this.urlPrefix, this.buildSender(), this.serializer);
    }

    public Sender buildSender() {
        if (this.httpSender != null) {
            return this.httpSender;
        }
        Sender sender = new GoogleSender(this.maxTimeout);
        sender = new StatusCodeSender(sender);
        if (this.signer != null) {
            sender = new SigningSender(this.signer, sender);
        }
        if (this.maxRetries > 0) {
            sender = new RetrySender(this.maxRetries, sender);
        }
        return sender;
    }
}

