/*
 * Decompiled with CFR 0.152.
 */
package com.smartystreets.api.us_zipcode;

import com.smartystreets.api.exceptions.BatchFullException;
import com.smartystreets.api.us_zipcode.Lookup;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

public class Batch {
    public static final int MAX_BATCH_SIZE = 100;
    private Map<String, Lookup> namedLookups = new LinkedHashMap<String, Lookup>();
    private Vector<Lookup> allLookups = new Vector();

    public void add(Lookup lookup) throws BatchFullException {
        if (this.allLookups.size() >= 100) {
            throw new BatchFullException("Batch size cannot exceed 100");
        }
        String key = lookup.getInputId();
        if (key != null) {
            this.namedLookups.put(key, lookup);
        }
        this.allLookups.add(lookup);
    }

    public void clear() {
        this.namedLookups.clear();
        this.allLookups.clear();
    }

    public int size() {
        return this.allLookups.size();
    }

    public Iterator<Lookup> iterator() {
        return this.allLookups.iterator();
    }

    public Map<String, Lookup> getNamedLookups() {
        return this.namedLookups;
    }

    public Vector<Lookup> getAllLookups() {
        return this.allLookups;
    }

    public Lookup get(String inputId) {
        return this.namedLookups.get(inputId);
    }

    public Lookup get(int inputIndex) {
        return this.allLookups.get(inputIndex);
    }
}

