/*
 * Decompiled with CFR 0.152.
 */
package com.smartystreets.api.us_street;

import com.google.api.client.util.Key;
import com.smartystreets.api.us_street.Candidate;
import java.util.ArrayList;

public class Lookup {
    private ArrayList<Candidate> result = new ArrayList();
    private String inputId;
    @Key(value="street")
    private String street;
    @Key(value="street2")
    private String street2;
    @Key(value="secondary")
    private String secondary;
    @Key(value="city")
    private String city;
    @Key(value="state")
    private String state;
    @Key(value="zipcode")
    private String zipCode;
    @Key(value="lastline")
    private String lastline;
    @Key(value="addressee")
    private String addressee;
    @Key(value="urbanization")
    private String urbanization;
    @Key(value="candidates")
    private int maxCandidates = 1;

    public Lookup() {
    }

    public Lookup(String freeformAddress) {
        this();
        this.street = freeformAddress;
    }

    public void addToResult(Candidate newCandidate) {
        this.result.add(newCandidate);
    }

    public ArrayList<Candidate> getResult() {
        return this.result;
    }

    public Candidate getResult(int index) {
        return this.result.get(index);
    }

    public String getInputId() {
        return this.inputId;
    }

    public String getStreet() {
        return this.street;
    }

    public String getStreet2() {
        return this.street2;
    }

    public String getSecondary() {
        return this.secondary;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public String getLastline() {
        return this.lastline;
    }

    public String getAddressee() {
        return this.addressee;
    }

    public String getUrbanization() {
        return this.urbanization;
    }

    public int getMaxCandidates() {
        return this.maxCandidates;
    }

    public void setResult(ArrayList<Candidate> result) {
        this.result = result;
    }

    public Lookup setInputId(String inputId) {
        this.inputId = inputId;
        return this;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public void setStreet2(String street2) {
        this.street2 = street2;
    }

    public void setSecondary(String secondary) {
        this.secondary = secondary;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public void setLastline(String lastline) {
        this.lastline = lastline;
    }

    public void setAddressee(String addressee) {
        this.addressee = addressee;
    }

    public void setUrbanization(String urbanization) {
        this.urbanization = urbanization;
    }

    public void setMaxCandidates(int maxCandidates) throws IllegalArgumentException {
        if (maxCandidates <= 0) {
            throw new IllegalArgumentException("Max candidates must be a positive integer.");
        }
        this.maxCandidates = maxCandidates;
    }
}

