/*
 * Decompiled with CFR 0.152.
 */
package com.smartystreets.api.us_street;

import com.smartystreets.api.exceptions.BatchFullException;
import com.smartystreets.api.us_street.Lookup;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

public class Batch {
    public static final int MAX_BATCH_SIZE = 100;
    private Map<String, Lookup> namedLookups = new LinkedHashMap<String, Lookup>();
    private Vector<Lookup> allLookups = new Vector();
    private boolean standardizeOnly = false;
    private boolean includeInvalid = false;

    public void add(Lookup newAddress) throws BatchFullException {
        if (this.allLookups.size() >= 100) {
            throw new BatchFullException("Batch size cannot exceed 100");
        }
        this.allLookups.add(newAddress);
        String key = newAddress.getInputId();
        if (key == null) {
            return;
        }
        this.namedLookups.put(key, newAddress);
    }

    public void reset() {
        this.clear();
        this.standardizeOnly = false;
        this.includeInvalid = false;
    }

    public void clear() {
        this.namedLookups.clear();
        this.allLookups.clear();
    }

    public int size() {
        return this.allLookups.size();
    }

    public Iterator<Lookup> iterator() {
        return this.allLookups.iterator();
    }

    public boolean getStandardizeOnly() {
        return this.standardizeOnly;
    }

    public boolean getIncludeInvalid() {
        return this.includeInvalid;
    }

    public Map<String, Lookup> getNamedLookups() {
        return this.namedLookups;
    }

    public Lookup get(String inputId) {
        return this.namedLookups.get(inputId);
    }

    public Lookup get(int inputIndex) {
        return this.allLookups.get(inputIndex);
    }

    public Vector<Lookup> getAllLookups() {
        return this.allLookups;
    }

    public void setStandardizeOnly(boolean newValue) {
        this.standardizeOnly = newValue;
    }

    public void setIncludeInvalid(boolean newValue) {
        this.includeInvalid = newValue;
    }
}

