/*
 * Decompiled with CFR 0.152.
 */
package com.smartystreets.api;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class Request {
    private static final String CHARSET = "UTF-8";
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Map<String, String> parameters = new LinkedHashMap<String, String>();
    private String urlPrefix;
    private String method = "GET";
    private byte[] payload;

    public Request() {
    }

    public Request(String urlPrefix) {
        this();
        this.urlPrefix = urlPrefix;
    }

    public void putHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void putParameter(String name, String value) {
        if (name == null || value == null || name.length() == 0) {
            return;
        }
        this.parameters.put(name, value);
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, CHARSET);
        }
        catch (Exception ex) {
            return "";
        }
    }

    public String getUrl() {
        String url = this.urlPrefix;
        if (!url.contains("?")) {
            url = url + "?";
        }
        for (String value : this.parameters.keySet()) {
            if (!url.endsWith("?")) {
                url = url + "&";
            }
            String encodedName = Request.urlEncode(value);
            String encodedValue = Request.urlEncode(this.parameters.get(value));
            url = url + encodedName + "=" + encodedValue;
        }
        return url;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.method = "POST";
        this.payload = payload;
    }
}

