/*
 * Decompiled with CFR 0.152.
 */
package com.smartystreets.api;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.smartystreets.api.Request;
import com.smartystreets.api.Response;
import com.smartystreets.api.Sender;
import com.smartystreets.api.exceptions.SmartyException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class GoogleSender
implements Sender {
    private int maxTimeOut = 10000;
    private HttpTransport transport = new NetHttpTransport();

    public GoogleSender() {
    }

    public GoogleSender(int maxTimeout) {
        this();
        this.maxTimeOut = maxTimeout;
    }

    GoogleSender(HttpTransport transport) {
        this();
        this.transport = transport;
    }

    @Override
    public Response send(Request request) throws SmartyException, IOException {
        HttpRequest httpRequest = this.buildHttpRequest(request);
        this.copyHeaders(request, httpRequest);
        try {
            return this.buildResponse(httpRequest.execute());
        }
        catch (HttpResponseException ex) {
            return new Response(ex.getStatusCode(), new byte[0]);
        }
    }

    private HttpRequest buildHttpRequest(Request request) throws IOException {
        HttpRequestFactory factory = this.transport.createRequestFactory();
        GenericUrl url = new GenericUrl(request.getUrl());
        if (request.getMethod().equals("GET")) {
            return factory.buildGetRequest(url);
        }
        ByteArrayContent content = new ByteArrayContent("application/json; charset=UTF-8", request.getPayload());
        return factory.buildPostRequest(url, (HttpContent)content);
    }

    private void copyHeaders(Request request, HttpRequest httpRequest) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpRequest.setHeaders(httpHeaders);
        Map<String, String> headers = request.getHeaders();
        for (String headerName : headers.keySet()) {
            httpHeaders.set(headerName, (Object)headers.get(headerName));
        }
        httpHeaders.setUserAgent("smartystreets (sdk:java@1.0.7)");
    }

    private Response buildResponse(HttpResponse httpResponse) throws IOException {
        int statusCode = httpResponse.getStatusCode();
        byte[] payload = this.readResponseBody(httpResponse);
        return new Response(statusCode, payload);
    }

    private byte[] readResponseBody(HttpResponse httpResponse) throws IOException {
        int totalBytesRead;
        InputStream inputStream = httpResponse.getContent();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int BUFFER_SIZE = 16384;
        byte[] buffer = new byte[16384];
        while ((totalBytesRead = inputStream.read(buffer, 0, 16384)) != -1) {
            outputStream.write(buffer, 0, totalBytesRead);
        }
        return outputStream.toByteArray();
    }
}

