/*
 * Copyright (C) 2025 Smartsheet
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Cell and column formatting model classes for the Smartsheet API.
 * <p>
 * This package contains classes related to cell and column formatting in Smartsheet,
 * including formatting options for text appearance, alignment, colors, borders, and
 * other visual properties.
 * </p>
 * <p>
 * These classes allow programmatic control over how data appears in Smartsheet sheets,
 * enabling rich formatting capabilities through the API.
 * </p>
 *
 * @see com.smartsheet.api.models
 */
package com.smartsheet.api.models.format;
