/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk.file.parameters;

import com.smartling.api.sdk.file.parameters.FileNameMode;
import com.smartling.api.sdk.file.parameters.LocaleMode;
import com.smartling.api.sdk.file.parameters.ParameterBuilder;
import com.smartling.api.sdk.file.parameters.RetrievalType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class GetFilesArchiveParameterBuilder
implements ParameterBuilder {
    private List<String> fileUris;
    private List<String> localeIds;
    private Boolean includeOriginalStrings;
    private RetrievalType retrievalType;
    private FileNameMode fileNameMode;
    private LocaleMode localeMode;

    public List<String> getFileUris() {
        return this.fileUris;
    }

    public List<String> getLocaleIds() {
        return this.localeIds;
    }

    public FileNameMode getFileNameMode() {
        return this.fileNameMode;
    }

    public LocaleMode getLocaleMode() {
        return this.localeMode;
    }

    public RetrievalType getRetrievalType() {
        return this.retrievalType;
    }

    public Boolean getIncludeOriginalStrings() {
        return this.includeOriginalStrings;
    }

    public GetFilesArchiveParameterBuilder files(List<String> fileUris) {
        this.fileUris = fileUris;
        return this;
    }

    public GetFilesArchiveParameterBuilder localeIds(List<String> localeIds) {
        this.localeIds = localeIds;
        return this;
    }

    public GetFilesArchiveParameterBuilder retrievalType(RetrievalType retrievalType) {
        this.retrievalType = retrievalType;
        return this;
    }

    public GetFilesArchiveParameterBuilder includeOriginalStrings(Boolean includeOriginalStrings) {
        this.includeOriginalStrings = includeOriginalStrings;
        return this;
    }

    public GetFilesArchiveParameterBuilder fileNameMode(FileNameMode fileNameMode) {
        this.fileNameMode = fileNameMode;
        return this;
    }

    public GetFilesArchiveParameterBuilder localeMode(LocaleMode localeMode) {
        this.localeMode = localeMode;
        return this;
    }

    @Override
    public List<NameValuePair> getNameValueList() {
        LinkedList<NameValuePair> paramsList = new LinkedList<NameValuePair>();
        paramsList.addAll(this.convertFileUrisParams("fileUris", this.fileUris));
        paramsList.addAll(this.convertFileUrisParams("localeIds", this.localeIds));
        if (this.includeOriginalStrings != null) {
            paramsList.add((NameValuePair)new BasicNameValuePair("includeOriginalStrings", this.includeOriginalStrings.toString()));
        }
        if (this.retrievalType != null) {
            paramsList.add((NameValuePair)new BasicNameValuePair("retrievalType", this.retrievalType.name()));
        }
        if (this.fileNameMode != null) {
            paramsList.add((NameValuePair)new BasicNameValuePair("fileNameMode", this.fileNameMode.name()));
        }
        if (this.localeMode != null) {
            paramsList.add((NameValuePair)new BasicNameValuePair("localeMode", this.localeMode.name()));
        }
        return paramsList;
    }

    private List<NameValuePair> convertFileUrisParams(String prefix, List<String> values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        for (String value : values) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair(prefix + "[]", value));
        }
        return nameValuePairs;
    }
}

