/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk.auth;

import com.google.gson.reflect.TypeToken;
import com.smartling.api.sdk.BaseApiClient;
import com.smartling.api.sdk.ProxyConfiguration;
import com.smartling.api.sdk.auth.AuthenticationCommand;
import com.smartling.api.sdk.auth.AuthenticationContext;
import com.smartling.api.sdk.dto.file.StringResponse;
import com.smartling.api.sdk.exceptions.SmartlingApiException;
import com.smartling.api.sdk.file.response.ApiV2ResponseWrapper;
import com.smartling.api.sdk.file.response.Response;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;

public class AuthApiClient
extends BaseApiClient {
    public static final String AUTH_API_V2_AUTHENTICATE = "/auth-api/v2/authenticate";
    public static final String AUTH_API_V2_REFRESH = "/auth-api/v2/authenticate/refresh";
    private final ProxyConfiguration proxyConfiguration;

    public AuthApiClient() {
        this(null, "https://api.smartling.com");
    }

    public AuthApiClient(ProxyConfiguration proxyConfiguration) {
        this(proxyConfiguration, "https://api.smartling.com");
    }

    public AuthApiClient(String baseUrl) {
        this(null, baseUrl);
    }

    public AuthApiClient(ProxyConfiguration proxyConfiguration, String baseUrl) {
        this.proxyConfiguration = proxyConfiguration;
        this.baseUrl = baseUrl;
    }

    public Response<AuthenticationContext> authenticate(AuthenticationCommand authenticationCommand) throws SmartlingApiException {
        HttpPost httpPost = this.createJsonPostRequest(this.getApiUrl(AUTH_API_V2_AUTHENTICATE, this.baseUrl), authenticationCommand);
        StringResponse response = this.httpUtils.executeHttpCall((HttpRequestBase)httpPost, this.proxyConfiguration);
        return AuthApiClient.getApiV2Response(response.getContents(), new TypeToken<ApiV2ResponseWrapper<AuthenticationContext>>(){});
    }

    public Response<AuthenticationContext> refresh(String refreshKey) throws SmartlingApiException {
        HttpPost httpPost = this.createJsonPostRequest(this.getApiUrl(AUTH_API_V2_REFRESH, this.baseUrl), refreshKey);
        StringResponse response = this.httpUtils.executeHttpCall((HttpRequestBase)httpPost, this.proxyConfiguration);
        return AuthApiClient.getApiV2Response(response.getContents(), new TypeToken<ApiV2ResponseWrapper<AuthenticationContext>>(){});
    }

    private String getApiUrl(String url, String baseAuthApiUrl) {
        return baseAuthApiUrl + url;
    }
}

