/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk;

import com.google.gson.reflect.TypeToken;
import com.smartling.api.sdk.BaseApiClientAdapter;
import com.smartling.api.sdk.ProjectApiClientAdapter;
import com.smartling.api.sdk.ProxyConfiguration;
import com.smartling.api.sdk.dto.ApiResponse;
import com.smartling.api.sdk.dto.ApiResponseWrapper;
import com.smartling.api.sdk.dto.file.StringResponse;
import com.smartling.api.sdk.dto.project.ProjectLocaleList;
import com.smartling.api.sdk.exceptions.ApiException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public class ProjectApiClientAdapterImpl
extends BaseApiClientAdapter
implements ProjectApiClientAdapter {
    private static final Log logger = LogFactory.getLog(ProjectApiClientAdapterImpl.class);
    private static final String GET_PROJECT_LOCALES_API_URL = "%s/project/locale/list?";

    public ProjectApiClientAdapterImpl(String apiKey, String projectId) {
        super(apiKey, projectId);
    }

    public ProjectApiClientAdapterImpl(String apiKey, String projectId, ProxyConfiguration proxyConfiguration) {
        super(apiKey, projectId, proxyConfiguration);
    }

    public ProjectApiClientAdapterImpl(boolean productionMode, String apiKey, String projectId) {
        super(productionMode, apiKey, projectId);
    }

    public ProjectApiClientAdapterImpl(boolean productionMode, String apiKey, String projectId, ProxyConfiguration proxyConfiguration) {
        super(productionMode, apiKey, projectId, proxyConfiguration);
    }

    public ProjectApiClientAdapterImpl(String baseApiUrl, String apiKey, String projectId) {
        super(baseApiUrl, apiKey, projectId);
    }

    public ProjectApiClientAdapterImpl(String baseApiUrl, String apiKey, String projectId, ProxyConfiguration proxyConfiguration) {
        super(baseApiUrl, apiKey, projectId, proxyConfiguration);
    }

    @Override
    public ApiResponse<ProjectLocaleList> getProjectLocales() throws ApiException {
        logger.debug((Object)String.format("Get project locales: projectId = %s, apiKey = %s", this.projectId, this.maskApiKey(this.apiKey)));
        String params = this.buildParamsQuery(new NameValuePair[0]);
        HttpGet getRequest = new HttpGet(this.buildUrl(GET_PROJECT_LOCALES_API_URL, params));
        StringResponse response = this.getHttpUtils().executeHttpCall((HttpRequestBase)getRequest, this.proxyConfiguration);
        ApiResponse<ProjectLocaleList> apiResponse = this.getApiResponse(response.getContents(), new TypeToken<ApiResponseWrapper<ProjectLocaleList>>(){});
        logger.debug((Object)String.format("Get last modified: %s. %s", apiResponse.getCode(), this.getApiResponseMessages(apiResponse)));
        return apiResponse;
    }
}

