/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.smartling.api.sdk.ProxyConfiguration;
import com.smartling.api.sdk.dto.ApiResponse;
import com.smartling.api.sdk.dto.ApiResponseWrapper;
import com.smartling.api.sdk.dto.Data;
import com.smartling.api.sdk.util.DateTypeAdapter;
import com.smartling.api.sdk.util.HttpUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public abstract class BaseApiClientAdapter {
    private static final String API_KEY_MASK = "%s-XXXXXXXXXXXX";
    private static final String RESPONSE_MESSAGES = "Messages: %s";
    private static final String SMARTLING_API_URL = "https://api.smartling.com/v1";
    private static final String SMARTLING_SANDBOX_API_URL = "https://sandbox-api.smartling.com/v1";
    private HttpUtils httpUtils;
    protected static final String SUCCESS_CODE = "SUCCESS";
    protected String baseApiUrl;
    protected String apiKey;
    protected String projectId;
    protected ProxyConfiguration proxyConfiguration;

    public HttpUtils getHttpUtils() {
        return this.httpUtils;
    }

    public void setHttpUtils(HttpUtils httpUtils) {
        this.httpUtils = httpUtils;
    }

    protected BaseApiClientAdapter(String apiKey, String projectId) {
        this(SMARTLING_API_URL, apiKey, projectId);
    }

    protected BaseApiClientAdapter(String apiKey, String projectId, ProxyConfiguration proxyConfiguration) {
        this(SMARTLING_API_URL, apiKey, projectId, proxyConfiguration);
    }

    protected BaseApiClientAdapter(boolean productionMode, String apiKey, String projectId) {
        this(productionMode ? SMARTLING_API_URL : SMARTLING_SANDBOX_API_URL, apiKey, projectId);
    }

    protected BaseApiClientAdapter(boolean productionMode, String apiKey, String projectId, ProxyConfiguration proxyConfiguration) {
        this(productionMode ? SMARTLING_API_URL : SMARTLING_SANDBOX_API_URL, apiKey, projectId, proxyConfiguration);
    }

    protected BaseApiClientAdapter(String baseApiUrl, String apiKey, String projectId) {
        this(baseApiUrl, apiKey, projectId, null);
    }

    protected BaseApiClientAdapter(String baseApiUrl, String apiKey, String projectId, ProxyConfiguration proxyConfiguration) {
        Validate.notNull((Object)baseApiUrl, (String)"Api url is required", (Object[])new Object[0]);
        Validate.notNull((Object)apiKey, (String)"apiKey is required", (Object[])new Object[0]);
        Validate.notNull((Object)projectId, (String)"projectId is required", (Object[])new Object[0]);
        this.baseApiUrl = baseApiUrl;
        this.apiKey = apiKey;
        this.projectId = projectId;
        this.proxyConfiguration = proxyConfiguration;
        this.httpUtils = new HttpUtils();
    }

    protected String buildUrl(String apiServerUrl, String apiParameters) {
        StringBuilder urlWithParameters = new StringBuilder(String.format(apiServerUrl, this.baseApiUrl));
        urlWithParameters.append(apiParameters);
        return urlWithParameters.toString();
    }

    protected String buildParamsQuery(NameValuePair ... nameValuePairs) {
        List<NameValuePair> qparams = this.getRequiredParams();
        for (NameValuePair nameValuePair : nameValuePairs) {
            if (nameValuePair.getValue() == null) continue;
            qparams.add(nameValuePair);
        }
        return URLEncodedUtils.format(qparams, (String)"UTF-8");
    }

    protected List<NameValuePair> getRequiredParams() {
        ArrayList<NameValuePair> qparams = new ArrayList<NameValuePair>();
        qparams.add((NameValuePair)new BasicNameValuePair("apiKey", this.apiKey));
        qparams.add((NameValuePair)new BasicNameValuePair("projectId", this.projectId));
        return qparams;
    }

    protected String maskApiKey(String apiKey) {
        return apiKey.contains("-") ? String.format(API_KEY_MASK, apiKey.substring(0, apiKey.lastIndexOf("-"))) : apiKey;
    }

    protected List<BasicNameValuePair> getNameValuePairs(String name, List<String> values) {
        if (null == values || values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        for (String value : values) {
            nameValuePairs.add(new BasicNameValuePair(name, value));
        }
        return nameValuePairs;
    }

    protected String getApiResponseMessages(ApiResponse<?> apiResponse) {
        String responseMessages = "";
        if (!SUCCESS_CODE.equals(apiResponse.getCode())) {
            responseMessages = String.format(RESPONSE_MESSAGES, StringUtils.join(apiResponse.getMessages(), (String)", "));
        }
        return responseMessages;
    }

    protected <T extends Data> ApiResponse<T> getApiResponse(String response, TypeToken<ApiResponseWrapper<T>> responseType) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        Gson gson = builder.create();
        ApiResponseWrapper responseWrapper = (ApiResponseWrapper)gson.fromJson(response, responseType.getType());
        return responseWrapper.getResponse();
    }
}

