/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk.util;

import com.smartling.api.sdk.ProxyConfiguration;
import com.smartling.api.sdk.dto.file.StringResponse;
import com.smartling.api.sdk.exceptions.ApiException;
import com.smartling.api.sdk.util.HttpProxyUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class HttpUtils {
    private static final Log logger = LogFactory.getLog(HttpUtils.class);
    private static final String LOG_MESSAGE_ERROR_TEMPLATE = "GENERAL ERROR: %s";
    static final String SCHEME_HTTPS = "https";
    static final String SCHEME_HTTP = "http";
    static final String PROPERTY_SUFFIX_PROXY_HOST = ".proxyHost";
    static final String PROPERTY_SUFFIX_PROXY_PORT = ".proxyPort";
    static final String PROPERTY_SUFFIX_PROXY_USERNAME = ".proxyUsername";
    static final String PROPERTY_SUFFIX_PROXY_PASSWORD = ".proxyPassword";
    private HttpProxyUtils httpProxyUtils = new HttpProxyUtils();

    public void setHttpProxyUtils(HttpProxyUtils httpProxyUtils) {
        this.httpProxyUtils = httpProxyUtils;
    }

    public StringResponse executeHttpCall(HttpRequestBase httpRequest, ProxyConfiguration proxyConfiguration) throws ApiException {
        StringResponse stringResponse;
        CloseableHttpClient httpClient;
        block12: {
            httpClient = null;
            ProxyConfiguration newProxyConfiguration = this.mergeSystemProxyConfiguration(proxyConfiguration);
            httpClient = this.httpProxyUtils.getHttpClient(newProxyConfiguration);
            RequestConfig proxyRequestConfig = this.httpProxyUtils.getProxyRequestConfig(httpRequest, newProxyConfiguration);
            if (proxyRequestConfig != null) {
                httpRequest.setConfig(proxyRequestConfig);
            }
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpRequest);
            String charset = EntityUtils.getContentCharSet((HttpEntity)response.getEntity());
            stringResponse = this.inputStreamToString(response.getEntity().getContent(), charset);
            if (response.getStatusLine().getStatusCode() != 200) break block12;
            StringResponse stringResponse2 = stringResponse;
            try {
                if (null != httpClient) {
                    httpClient.close();
                }
            }
            catch (IOException ioe) {
                logger.warn((Object)String.format(LOG_MESSAGE_ERROR_TEMPLATE, ioe.getMessage()));
            }
            return stringResponse2;
        }
        try {
            try {
                throw new ApiException(stringResponse.getContents());
            }
            catch (IOException ioe) {
                logger.error((Object)String.format(LOG_MESSAGE_ERROR_TEMPLATE, ioe.getMessage()));
                throw new ApiException(ioe);
            }
        }
        catch (Throwable throwable) {
            try {
                if (null != httpClient) {
                    httpClient.close();
                }
            }
            catch (IOException ioe) {
                logger.warn((Object)String.format(LOG_MESSAGE_ERROR_TEMPLATE, ioe.getMessage()));
            }
            throw throwable;
        }
    }

    private StringResponse inputStreamToString(InputStream inputStream, String encoding) throws IOException {
        byte[] contentsRaw = IOUtils.toByteArray((InputStream)inputStream);
        String responseEncoding = null == encoding || !encoding.toUpperCase().contains("UTF-16") ? "UTF-8" : "UTF-16";
        String contents = new String(contentsRaw, responseEncoding);
        return new StringResponse(contents, contentsRaw, responseEncoding);
    }

    private ProxyConfiguration mergeSystemProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        String protocol = this.defineSchemeFromSystemProperties();
        if (protocol != null) {
            ProxyConfiguration newProxyConfiguration = new ProxyConfiguration();
            newProxyConfiguration.setHost(System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_HOST));
            newProxyConfiguration.setPort(Integer.valueOf(System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_PORT)));
            newProxyConfiguration.setUsername(System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_USERNAME));
            newProxyConfiguration.setPassword(System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_PASSWORD));
            return newProxyConfiguration;
        }
        return proxyConfiguration;
    }

    private String defineSchemeFromSystemProperties() {
        if (StringUtils.isNotBlank((CharSequence)System.getProperty("https.proxyHost")) && StringUtils.isNotBlank((CharSequence)System.getProperty("https.proxyPort"))) {
            return SCHEME_HTTPS;
        }
        if (StringUtils.isNotBlank((CharSequence)System.getProperty("http.proxyHost")) && StringUtils.isNotBlank((CharSequence)System.getProperty("http.proxyPort"))) {
            return SCHEME_HTTP;
        }
        return null;
    }
}

